CREATE TABLE MOBILE_APP_CONFIG
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '名称',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   APPID                VARCHAR(50) NOT NULL COMMENT '外系统应用ID',
   SECRET               VARCHAR(50) NOT NULL COMMENT '外系统应用密钥',
   TYPE_ID              BIGINT NOT NULL COMMENT '应用类型',
   PRIMARY KEY (ID)
);

ALTER TABLE MOBILE_APP_CONFIG COMMENT '移动应用配置信息';

CREATE UNIQUE INDEX UNIQUE_APPID ON MOBILE_APP_CONFIG
(
   APPID,
   TYPE_ID
);

CREATE TABLE MOBILE_SIMPLE_TYPE
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '名称',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   CLASS_TYPE           VARCHAR(255) NOT NULL COMMENT '类类型',
   SERIAL_NUMBER        INT(5) NOT NULL DEFAULT 0 COMMENT '序号',
   PRIMARY KEY (ID)
);

ALTER TABLE MOBILE_SIMPLE_TYPE COMMENT '移动端简单类型';

CREATE UNIQUE INDEX UNIQUE_CODE ON MOBILE_SIMPLE_TYPE
(
   CODE,
   CLASS_TYPE
);

CREATE TABLE MOBILE_USER_BIND
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '名称',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   OPENID               VARCHAR(50) NOT NULL COMMENT '外系统应用ID',
   UPDATE_TIME          DATETIME NOT NULL COMMENT '更新时间',
   EXPIRED_TIME         DATETIME NOT NULL COMMENT '到期时间',
   TYPE_ID              BIGINT NOT NULL COMMENT '应用类型',
   EMPLOYEE_CODE        VARCHAR(50) NOT NULL COMMENT '登陆工号',
   TOKEN                VARCHAR(225) COMMENT '登陆Token',
   PRIMARY KEY (ID)
);

ALTER TABLE MOBILE_USER_BIND COMMENT '移动用户绑定信息';

CREATE UNIQUE INDEX UNIQUE_OPENID ON MOBILE_USER_BIND
(
   OPENID,
   TYPE_ID
);

ALTER TABLE MOBILE_APP_CONFIG ADD CONSTRAINT FK_MOBILE_APP_TYPE FOREIGN KEY (TYPE_ID)
      REFERENCES MOBILE_SIMPLE_TYPE (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE MOBILE_USER_BIND ADD CONSTRAINT FK_USER_BIND_TYPE FOREIGN KEY (TYPE_ID)
      REFERENCES MOBILE_SIMPLE_TYPE (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

