CREATE TABLE DOC_BOOK
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '名称',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   CREATOR_CODE         VARCHAR(50) NOT NULL COMMENT '创建人',
   ENABLE               INT(1) NOT NULL DEFAULT 0 COMMENT '是否生效',
   DESCRIPTION          VARCHAR(1000) COMMENT '描述',
   OPEN                 INT(1) NOT NULL DEFAULT 0 COMMENT '是否公开',
   COVER_ID             BIGINT COMMENT '封面',
   UPDATE_TIME          DATETIME COMMENT '更新时间',
   SN                   INT(5) NOT NULL DEFAULT 0 COMMENT '序号',
   PRIMARY KEY (ID)
);

ALTER TABLE DOC_BOOK COMMENT '知识库图书';

CREATE UNIQUE INDEX UNIQUE_CODE ON DOC_BOOK
(
   CODE
);

CREATE TABLE DOC_COLLECT
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '名称',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   CREATOR_CODE         VARCHAR(50) NOT NULL COMMENT '创建人',
   ENABLE               INT(1) NOT NULL DEFAULT 0 COMMENT '是否生效',
   NODE_ID              BIGINT NOT NULL COMMENT '节点',
   PRIMARY KEY (ID)
);

ALTER TABLE DOC_COLLECT COMMENT '知识库收藏表';

CREATE UNIQUE INDEX UNIQUE_CODE ON DOC_COLLECT
(
   CODE
);

CREATE UNIQUE INDEX UNIQUE_NODE ON DOC_COLLECT
(
   CREATOR_CODE,
   NODE_ID
);

CREATE TABLE DOC_FILE
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '名称',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   CREATOR_CODE         VARCHAR(50) NOT NULL COMMENT '创建人',
   TYPE_ID              BIGINT NOT NULL COMMENT '类型',
   SIZE                 BIGINT NOT NULL COMMENT '大小（字节）',
   PATH                 VARCHAR(1000) COMMENT '存储路径',
   LOCATION_ID          BIGINT NOT NULL COMMENT '存储位置',
   ENABLE               INT(1) NOT NULL DEFAULT 0 COMMENT '生效',
   PRIMARY KEY (ID)
);

ALTER TABLE DOC_FILE COMMENT '知识库文件表';

CREATE UNIQUE INDEX UNIQUE_CODE ON DOC_FILE
(
   CODE
);

CREATE TABLE DOC_NODE
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '名称',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   CLASS_TYPE           VARCHAR(255) NOT NULL COMMENT '类类型',
   CREATOR_CODE         VARCHAR(50) NOT NULL COMMENT '创建人',
   ENABLE               INT(1) NOT NULL DEFAULT 0 COMMENT '是否生效',
   DESCRIPTION          VARCHAR(1000) COMMENT '描述',
   PAGE_ID              BIGINT COMMENT '内容',
   FILE_ID              BIGINT COMMENT '文件',
   BOOK_ID              BIGINT NOT NULL COMMENT '归属图书',
   TYPE_ID              BIGINT NOT NULL COMMENT '节点类型',
   PARENT_ID            BIGINT COMMENT '父节点',
   UPDATE_TIME          DATETIME COMMENT '更新时间',
   SN                   INT(5) NOT NULL DEFAULT 0 COMMENT '序号',
   PRIMARY KEY (ID)
);

ALTER TABLE DOC_NODE COMMENT '知识库图书节点';

CREATE UNIQUE INDEX UNIQUE_CODE ON DOC_NODE
(
   CODE
);

CREATE TABLE DOC_PAGE
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '名称',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   CREATOR_CODE         VARCHAR(50) NOT NULL COMMENT '创建人',
   ENABLE               INT(1) NOT NULL DEFAULT 0 COMMENT '是否生效',
   CONTENT              LONGTEXT COMMENT '内容',
   BOOK_ID              BIGINT NOT NULL COMMENT '图书',
   PRIMARY KEY (ID)
);

ALTER TABLE DOC_PAGE COMMENT '知识库文章表';

CREATE UNIQUE INDEX UNIQUE_CODE ON DOC_PAGE
(
   CODE
);

CREATE TABLE DOC_PAGE_DEPT
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '名称',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   CREATOR_CODE         VARCHAR(50) NOT NULL COMMENT '创建人',
   DEPT_CODE            VARCHAR(50) NOT NULL COMMENT '部门编码',
   PAGE_ID              BIGINT NOT NULL COMMENT '文章',
   PRIMARY KEY (ID)
);

ALTER TABLE DOC_PAGE_DEPT COMMENT '知识库文章协作部门';

CREATE UNIQUE INDEX UNIQUE_CODE ON DOC_PAGE_DEPT
(
   CODE
);

CREATE TABLE DOC_PAGE_USER
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '名称',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   CREATOR_CODE         VARCHAR(50) NOT NULL COMMENT '创建人',
   USER_CODE            VARCHAR(50) NOT NULL COMMENT '用户编码',
   PAGE_ID              BIGINT NOT NULL COMMENT '文章',
   PRIMARY KEY (ID)
);

ALTER TABLE DOC_PAGE_USER COMMENT '知识库文章协作用户';

CREATE UNIQUE INDEX UNIQUE_CODE ON DOC_PAGE_USER
(
   CODE
);

CREATE TABLE DOC_SIMPLE_TYPE
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '名称',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   CLASS_TYPE           VARCHAR(255) NOT NULL COMMENT '类类型',
   SERIAL_NUMBER        INT(5) NOT NULL DEFAULT 0 COMMENT '序号',
   PRIMARY KEY (ID)
);

ALTER TABLE DOC_SIMPLE_TYPE COMMENT '知识库简单类型';

CREATE UNIQUE INDEX UNIQUE_CODE ON DOC_SIMPLE_TYPE
(
   CODE,
   CLASS_TYPE
);

ALTER TABLE DOC_BOOK ADD CONSTRAINT FK_BOOK_COVER FOREIGN KEY (COVER_ID)
      REFERENCES DOC_FILE (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE DOC_COLLECT ADD CONSTRAINT FK_COLLECT_NODE FOREIGN KEY (NODE_ID)
      REFERENCES DOC_NODE (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE DOC_FILE ADD CONSTRAINT FK_FILE_LOCATION FOREIGN KEY (LOCATION_ID)
      REFERENCES DOC_SIMPLE_TYPE (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE DOC_FILE ADD CONSTRAINT FK_FILE_TYPE FOREIGN KEY (TYPE_ID)
      REFERENCES DOC_SIMPLE_TYPE (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE DOC_NODE ADD CONSTRAINT FK_NODE_BOOK FOREIGN KEY (BOOK_ID)
      REFERENCES DOC_BOOK (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE DOC_NODE ADD CONSTRAINT FK_NODE_FILE FOREIGN KEY (FILE_ID)
      REFERENCES DOC_FILE (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE DOC_NODE ADD CONSTRAINT FK_NODE_PAGE FOREIGN KEY (PAGE_ID)
      REFERENCES DOC_PAGE (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE DOC_NODE ADD CONSTRAINT FK_NODE_TYPE FOREIGN KEY (TYPE_ID)
      REFERENCES DOC_SIMPLE_TYPE (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE DOC_PAGE ADD CONSTRAINT FK_PAGE_BOOK FOREIGN KEY (BOOK_ID)
      REFERENCES DOC_BOOK (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE DOC_PAGE_DEPT ADD CONSTRAINT FK_DEPT_PAGE FOREIGN KEY (PAGE_ID)
      REFERENCES DOC_PAGE (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE DOC_PAGE_USER ADD CONSTRAINT FK_USER_PAGE FOREIGN KEY (PAGE_ID)
      REFERENCES DOC_PAGE (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

