CREATE TABLE CRM_CONTRACT
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '名称',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   UPDATE_TIME          DATETIME NOT NULL COMMENT '更新时间',
   CREATOR_CODE         VARCHAR(50) NOT NULL COMMENT '操作员编码',
   LEAD_ID              BIGINT NOT NULL COMMENT '线索',
   CUSTOMER_ID          BIGINT NOT NULL COMMENT '客户',
   TYPE_ID              BIGINT NOT NULL COMMENT '类型',
   START_TIME           DATETIME NOT NULL COMMENT '开始时间',
   END_TIME             DATETIME NOT NULL COMMENT '结束时间',
   OWNER_CODE           VARCHAR(255) NOT NULL COMMENT '负责人',
   AMOUNT               DECIMAL(10,2) DEFAULT 0 COMMENT '合同金额',
   CHECK_STATUS         VARCHAR(255) COMMENT '审批状态',
   PRIMARY KEY (ID)
);

ALTER TABLE CRM_CONTRACT COMMENT '合同';

CREATE UNIQUE INDEX UNIQUE_CODE ON CRM_CONTRACT
(
   CODE
);

CREATE TABLE CRM_CUSTOMER
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '名称',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   UPDATE_TIME          DATETIME NOT NULL COMMENT '更新时间',
   CREATOR_CODE         VARCHAR(50) NOT NULL COMMENT '操作员编码',
   MOBILE               VARCHAR(50) COMMENT '手机号',
   TYPE_ID              BIGINT NOT NULL COMMENT '类型',
   WEBSITE              VARCHAR(255) COMMENT '网址',
   EMAIL                VARCHAR(255) COMMENT '邮箱',
   CHECK_STATUS         VARCHAR(255) COMMENT '审批状态',
   PRIMARY KEY (ID)
);

ALTER TABLE CRM_CUSTOMER COMMENT '客户';

CREATE UNIQUE INDEX UNIQUE_CODE ON CRM_CUSTOMER
(
   CODE
);

CREATE TABLE CRM_DICTIONARIES
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '值',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   TYPE_ID              BIGINT NOT NULL COMMENT '字典类型',
   SERIAL_NUMBER        INT(5) NOT NULL DEFAULT 1 COMMENT '序列',
   ENABLE               INT(1) NOT NULL DEFAULT 0 COMMENT '生效',
   PRIMARY KEY (ID)
);

ALTER TABLE CRM_DICTIONARIES COMMENT '字典表';

CREATE UNIQUE INDEX UNIQUE_CODE ON CRM_DICTIONARIES
(
   CODE
);

CREATE TABLE CRM_LEAD
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '名称',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   UPDATE_TIME          DATETIME NOT NULL COMMENT '更新时间',
   CREATOR_CODE         VARCHAR(50) NOT NULL COMMENT '操作员编码',
   MOBILE               VARCHAR(255) COMMENT '手机号码',
   AMOUNT               DECIMAL(10,2) COMMENT '金额',
   BRITHDAY             DATE COMMENT '生日',
   ADDRESS              VARCHAR(255) COMMENT '地址',
   SOURCE_ID            BIGINT COMMENT '来源',
   AGE                  INT(3) COMMENT '年龄',
   SIZE                 VARCHAR(255) COMMENT '百分数',
   STATUS               VARCHAR(255) COMMENT '状态',
   EMAIL                VARCHAR(255) COMMENT '邮箱',
   EMPLOYEE             VARCHAR(255) COMMENT '员工',
   DEPT                 VARCHAR(255) COMMENT '部门',
   CUSTOMER_ID          BIGINT COMMENT '客户',
   CHECK_STATUS         VARCHAR(255) COMMENT '审批状态',
   PRIMARY KEY (ID)
);

ALTER TABLE CRM_LEAD COMMENT '线索';

CREATE UNIQUE INDEX UNIQUE_CODE ON CRM_LEAD
(
   CODE
);

CREATE TABLE CRM_SIMPLE_TYPE
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '工号',
   NAME                 VARCHAR(255) NOT NULL COMMENT '姓名',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   CLASS_TYPE           VARCHAR(255) NOT NULL COMMENT '枚举实体类名',
   SERIAL_NUMBER        INT(5) NOT NULL DEFAULT 1 COMMENT '序列',
   PRIMARY KEY (ID)
);

ALTER TABLE CRM_SIMPLE_TYPE COMMENT '枚举表';

CREATE UNIQUE INDEX UNIQUE_CODE ON CRM_SIMPLE_TYPE
(
   CODE
);

ALTER TABLE CRM_CONTRACT ADD CONSTRAINT FK_CRM_CONTRACT_CUSTOMER FOREIGN KEY (CUSTOMER_ID)
      REFERENCES CRM_CUSTOMER (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE CRM_CONTRACT ADD CONSTRAINT FK_CRM_CONTRACT_LEAD FOREIGN KEY (LEAD_ID)
      REFERENCES CRM_LEAD (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE CRM_DICTIONARIES ADD CONSTRAINT FK_CRM_DICTIONARIES_TYPE FOREIGN KEY (TYPE_ID)
      REFERENCES CRM_SIMPLE_TYPE (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE CRM_LEAD ADD CONSTRAINT FK_CRM_LEAD_CUSTOMER FOREIGN KEY (CUSTOMER_ID)
      REFERENCES CRM_CUSTOMER (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

ALTER TABLE CRM_LEAD ADD CONSTRAINT FK_CRM_LEAD_TYPE FOREIGN KEY (SOURCE_ID)
      REFERENCES CRM_DICTIONARIES (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

