CALL add_sharding_template('DruidDataSource', '阿里数据源', 'DataSource', '[{"code":"type","name":"类型"},{"code":"driverClassName","name":"驱动类"},{"code":"url","name":"连接地址"},{"code":"username","name":"用户名"},{"code":"password","name":"密码"},{"code":"connectionErrorRetryAttempts","name":"连接失败重试次数"},{"code":"breakAfterAcquireFailure","name":"连接失败终止"},{"code":"failFast","name":"连接失败终止"}]', null);

CALL add_sharding_template('INLINE', '行分片算法模板', 'ShardingAlgorithm', '[{"name": "行表达式","code": "algorithm-expression"},{"name": "是否允许范围查询","code": "allow-range-query-with-inline-sharding","description": "注意：范围查询会无视分片策略，进行全路由（boolean类型，可不设置，默认为false）"}]', null);
CALL add_sharding_template('INTERVAL', '时间范围分片算法模板', 'ShardingAlgorithm', '[{"name": "分片键的时间戳格式","code": "datetime-pattern","description": "必须遵循 Java DateTimeFormatter 的格式。例如：yyyy-MM-dd HH:mm:ss，yyyy-MM-dd 或 HH:mm:ss 等。"},{"name": "时间分片下界值","code": "datetime-lower","description": "格式与 datetime-pattern 定义的时间戳格式一致"},{"name": "时间分片上界值","code": "datetime-upper","description": "格式与 datetime-pattern 定义的时间戳格式一致（可不设置，默认为当前时间）"},{"name": "分片数据源或真实表的后缀格式","code": "sharding-suffix-pattern","description": "必须遵循 Java DateTimeFormatter 的格式，必须和 datetime-interval-unit 保持一致。例如：yyyyMM"},{"name": "分片键时间间隔","code": "datetime-interval-amount","description": "超过该时间间隔将进入下一分片（可不设置，默认为1）"},{"name": "分片键时间间隔单位","code": "datetime-interval-unit","description": "必须遵循 Java ChronoUnit 的枚举值。例如：MONTHS（可不设置，默认值为DAYS）"}]', null);
CALL add_sharding_template('COSID_INTERVAL', '基于CosId的固定时间范围的分片算法模板', 'ShardingAlgorithm', '[{"name": "时区","code": "zone-id",	"description": "必须遵循 java.time.ZoneId 的所含值。 例如：Asia/Shanghai"},{"name": "分片数据源或真实表的前缀格式","code": "logic-name-prefix"},{"name": "时间分片下界值","code": "datetime-lower",	"description": "格式与 yyyy-MM-dd HH:mm:ss 的时间戳格式一致"},{"name": "时间分片上界值","code": "datetime-upper",	"description": "格式与 yyyy-MM-dd HH:mm:ss 的时间戳格式一致"},{"name": "分片数据源或真实表的后缀格式","code": "sharding-suffix-pattern",	"description": "必须遵循 Java DateTimeFormatter 的格式，必须和 datetime-interval-unit 保持一致。例如：yyyyMM"},{"name": "分片键时间间隔","code": "datetime-interval-amount",	"description": "超过该时间间隔将进入下一分片"},{"name": "分片键时间间隔单位","code": "datetime-interval-unit",	"description": "必须遵循 Java ChronoUnit 的枚举值。例如：MONTHS"}]', '固定时间范围的分片算法');
CALL add_sharding_template('COMPLEX_INLINE', '复合行表达式分片算法', 'ShardingAlgorithm', '[{"name": "分片列名称","code": "sharding-columns",	"description": "多个列用逗号分隔。如不配置则不能校验"},{"name": "分片算法的行表达式","code": "algorithm-expression"},{"name": "是否允许范围查询","code": "allow-range-query-with-inline-sharding",	"description": "注意：范围查询会无视分片策略，进行全路由（boolean类型，可不设置，默认为false）"}]', null);
CALL add_sharding_template('HINT_INLINE', '强制分片算法模板', 'ShardingAlgorithm', '[{"name": "分片算法的行表达式","code": "algorithm-expression"}]', null);
CALL add_sharding_template('CLASS_BASED', '自定义类分片算法模板', 'ShardingAlgorithm', '[{"name": "分片策略类型","code": "strategy",	"description": "支持 STANDARD、COMPLEX 或 HINT（不区分大小写）"},{"name": "分片算法全限定类名","code": "algorithmClassName",	"description": "类需实现接口StandardShardingAlgorithm"}]', null);

CALL add_sharding_template('standard', '标准分片表配置模板', 'ShardingStrategy', null, '分片列名（单列）');
CALL add_sharding_template('complex', '复合分片表配置模板', 'ShardingStrategy', null, '分片列名（多列，逗号分隔）');
CALL add_sharding_template('hint', '强制分片表配置模板', 'ShardingStrategy', null, null);
CALL add_sharding_template('none', '不分片表配置模板', 'ShardingStrategy', null, null);
