CREATE TABLE REPORT_DESIGN
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '姓名',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   SN                   INT(5) NOT NULL DEFAULT 1 COMMENT '序列',
   ENABLE               INT(1) NOT NULL DEFAULT 0 COMMENT '是否生效',
   CREATOR_CODE         VARCHAR(50) NOT NULL COMMENT '创建人',
   DEFINITION_ID        BIGINT NOT NULL COMMENT '报表定义',
   POSITION             VARCHAR(50) NOT NULL COMMENT '位置',
   CHART_TYPE           VARCHAR(50) COMMENT '图表类型',
   DATA_DIMENSION       VARCHAR(50) COMMENT '维度列编码',
   PRIMARY KEY (ID)
);

ALTER TABLE REPORT_DESIGN COMMENT '报表设计';

CREATE UNIQUE INDEX UNIQUE_CODE ON REPORT_DESIGN
(
   CODE
);

ALTER TABLE REPORT_DESIGN ADD CONSTRAINT FK_DESIGN_DEFINITION FOREIGN KEY (DEFINITION_ID)
      REFERENCES REPORT_DEFINITION (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

CREATE TABLE REPORT_DESIGN_CATEGORY
(
   DESIGN_ID            BIGINT NOT NULL COMMENT 'ID',
   DATA_CATEGORY        VARCHAR(50) NOT NULL COMMENT '编码',
   PRIMARY KEY (DESIGN_ID, DATA_CATEGORY)
);

ALTER TABLE REPORT_DESIGN_CATEGORY COMMENT '报表设计分类';

ALTER TABLE REPORT_DESIGN_CATEGORY ADD CONSTRAINT FK_DESIGN_CATEGORY FOREIGN KEY (DESIGN_ID)
      REFERENCES REPORT_DESIGN (ID) ON DELETE RESTRICT ON UPDATE RESTRICT;

CREATE TABLE REPORT_DESIGN_SORT
(
   ID                   BIGINT NOT NULL COMMENT 'ID',
   CODE                 VARCHAR(50) NOT NULL COMMENT '编码',
   NAME                 VARCHAR(255) NOT NULL COMMENT '姓名',
   VERSION              VARCHAR(50) NOT NULL COMMENT '版本号',
   CREATE_TIME          DATETIME NOT NULL COMMENT '创建时间',
   SN                   INT(5) NOT NULL DEFAULT 1 COMMENT '序列',
   ENABLE               INT(1) NOT NULL DEFAULT 0 COMMENT '是否生效',
   CREATOR_CODE         VARCHAR(50) NOT NULL COMMENT '创建人',
   DESIGN_CODE          BIGINT NOT NULL COMMENT '报表设计编码',
   PRIMARY KEY (ID)
);

ALTER TABLE REPORT_DESIGN_SORT COMMENT '首页排序';

CREATE UNIQUE INDEX UNIQUE_CODE ON REPORT_DESIGN_SORT
(
   CODE
);
