---
title: About EU misappropriation sanctions
---
Following the revolutions in 2011 in Tunisia and Egypt and 2014 in Ukraine, the Council of the European Union imposed misappropriation sanctions on people suspected of corruption from the ousted regimes.

These require that any assets relating to persons on the list, including houses and bank accounts, are frozen in all EU Member States.

Sanctions are imposed by the Council of the EU to promote the objectives of the Common Foreign and Security Policy: peace, democracy and the respect for the rule of law, human rights and international law.

Each year, the Council of the EU decides whether these sanctions should be renewed, amended or lifted. [1](https://eeas.europa.eu/topics/external-investment-plan/423/sanctions-policy_en)


## Glossary

*Disclaimer: The following is a general description of terms used throughout this website. For exact terms used in context, please see the up-to-date version of the relevant legislation. If you are in doubt about any of the below, please contact your competent national authority or seek independent legal advice.*

### Asset freeze
Asset freezes make funds and economic resources of the designated person unavailable for the period they are in force. This process does not however involve a confiscation or a change in the ownership of the frozen funds and economic resources. [1](https://www.gov.uk/government/publications/financial-sanctions-faqs)

### Asset recovery
The process of identifying, freezing and returning assets stolen through corruption to the country of origin. [1]( https://cifar.eu/what-is-asset-recovery/)

### Competent authority
Designated national authorities of EU Member States responsible for implementing financial sanctions. For a list of these authorities see the [Guidelines page]((https://sanctionswatch.cifar.eu/guidelines/)) on this website. 

### Council of the European Union
Often referred to as the Council, an institution representing the European Union Member State governments, where national ministers from each EU country meet to adopt laws and coordinate policies. [1](https://www.consilium.europa.eu/en/council-eu/)

### Kleptocrat
A ruler who uses their power to steal their country's resources. [1]( https://en.oxforddictionaries.com/definition/kleptocrat)

### Misappropriation sanctions
A type of financial sanction related to grand corruption - “misappropriation of state assets”. These sanctions can restrict access to funds and economic resources of individuals, entities and bodies. See more in our [report](https://cifar.eu/wp-content/uploads/2019/03/CiFAR_Sanctioning-kleptocrats.pdf)

### Sanctions
Restrictive measures that can take a number of different forms, in pursuit of a variety of goals. Measures rangee from comprehensive economic and trade sanctions to more targeted measures such as arms embargoes, travel bans, and financial or commodity restrictions. [1](https://www.un.org/sc/suborg/en/sanctions/information)


## EU legal acts & useful links

### Egypt
- [EU Council Decision. 23.03.2017 consolidated basic legal act - 2011/172/CFSP](https://eur-lex.europa.eu/legal-content/EN/TXT/?uri=CELEX:02011D0172-20170323)
- [EU Council Regulation. 23.03.2017 consolidated basic legal act - (EU) No 270/2011](https://eur-lex.europa.eu/legal-content/EN/TXT/?uri=CELEX:02011R0270-20170323)
- [EU Council Implementing Regulation. 21.03.2018 amendments not yet included in the consolidated legal act - (EU) 2018/465](https://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=CELEX:32018R0137&from=EN)
- [EU Council Decision. 21.03.2018 amendments not yet included in the consolidated legal act - (CFSP) 2018/466](https://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=CELEX:32018D0141&from=EN)

### Tunisia
- [EU Council Decision. 31.01.2011 consolidated basic legal act - 2011/72/CFSP](https://eur-lex.europa.eu/legal-content/EN/TXT/?uri=CELEX:02011D0072-20170128)
- [EU Council Regulation. 04.02.2011 consolidated basic legal act - (EU) No 101/2011](https://eur-lex.europa.eu/legal-content/EN/TXT/?uri=CELEX:02011R0101-20170128)
- [EU Council Implementing Regulation. 28.01.2019 amendments not yet included in the consolidated legal act - (EU) 2019/132]( https://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=OJ:L:2019:025:FULL&from=EN)
- [EU Council Decision. 28.01.2019 amendments not yet included in the consolidated legal act - (CFSP) 2019/135]( https://eur-lex.europa.eu/legal-content/EN/TXT/PDF/?uri=OJ:L:2019:025:FULL&from=EN)



### Ukraine
- [EU Council Decision. 05.03.2014 consolidated basic legal act - 2014/119/CFSP](https://eur-lex.europa.eu/legal-content/EN/TXT/?uri=CELEX:02014D0119-20170305)
- [EU Council Regulation. 05.03.2014 consolidated basic legal act - (EU) No 208/2014](https://eur-lex.europa.eu/legal-content/EN/TXT/?uri=CELEX:02014R0208-20170305)
- [EU Council Implementing Regulation. 06.03.2018 amendments not yet included in the consolidated legal act - (EU) 2018/326](https://eur-lex.europa.eu/legal-content/EN/TXT/?uri=uriserv:OJ.L_.2018.063.01.0005.01.ENG&toc=OJ:L:2018:063:TOC)
- [EU Council Decision. 06.03.2018 amendments not yet included in the consolidated legal act - (CFSP) 2018/333](https://eur-lex.europa.eu/legal-content/EN/TXT/?uri=uriserv:OJ.L_.2018.063.01.0048.01.ENG&toc=OJ:L:2018:063:TOC)

### EU Sanctions Map
The [EU Sanctions Map](https://sanctionsmap.eu/) provides information about EU sanctions and UN sanctions implemented by the EU.
