---
title: Sanctioning Kleptocrats. An Assessment of EU Misappropriation Sanctions 
date: March 2019
author: Dr. Clara Portela, University of Valencia, Spain
downloadTitle: Download Report as PDF (420kB)
downloadLink: https://cifar.eu/wp-content/uploads/2019/03/CiFAR_Sanctioning-kleptocrats.pdf
---
[Download Annex](https://cifar.eu/wp-content/uploads/2019/03/Tables-evolution-of-asset-freezes.pdf) - The Evolution of Asset Freezes in Egypt, Tunisia and Ukraine 

## Executive Summary

#### Sanctions as a political tool

In 2011 revolutions ousted the presidents of Tunisia and Egypt, and in 2014 similar large protests led to the overthrow of the leadership of Ukraine. These uprisings removed from power leaders and their close associates who had long been suspected of stealing vast amounts of public wealth from their countries and hiding this wealth overseas.

Responding to these revolutions, the European Union (EU) put in place freezes on the European bank accounts and property of the former rulers, as well as on their families and entourages, preventing these assets from being transferred and hidden again. To accomplish this aim, the EU employed the same type of legislative acts it uses for foreign policy sanctions, which are adopted under its Common Foreign and Security Policy (CFSP) and are primarily designed to advance political objectives.

These sanctions were agreed for two main reasons:
- To prevent the flight of suspected stolen public assets by former regime elites, through freezing the assets, thereby making it possible to recover the assets at a later stage;
- To stabilise the post-revolutionary leaderships and new governments in Cairo, Tunis and Kiev.

#### A story of limited success

While there is evidence to suggest that the sanctions were successful in building bridges with the new governments in the three countries, particularly after initial, lukewarm support for regime change in Egypt and Tunisia, progress in the recovery of the allegedly stolen wealth has been limited.

These three cases are moreover the first and only examples of EU level sanctions imposed to address the suspected theft of public funds - in EU terminology the “misappropriation of state assets”. 

The difficulties experienced in the three cases and the limited use of CFSP sanctions to fight the misappropriation of state assets are, to an extent, linked. The principal obstacle with the Tunisia, Egypt and Ukraine cases was legal challenges to the sanctions in front of European courts, which often ruled in favour of annulling listings due to insufficient substantiation.

While judicial defeat is common to all EU sanctions regimes, in the case of misappropriation sanctions this problem was exacerbated by the Council’s over-reliance on evidence supplied by Egypt, Tunisia and Ukraine, which suffered from weak investigative capacity and political interference in the judicial system.

The Council’s reliance on evidence from other countries has made the EU hesitant to extend its use of sanctions for misappropriation. In addition to this is the problem of the link between the sanctions and any recovery of stolen assets. The CFSP sanctions framework is not empowered to deal with the restitution of funds, leaving this to the Member States where the assets are located. This means that the sanctions often exist independently of any domestic criminal investigation.

By way of comparison, the Swiss Foreign Illicit Assets Act, enacted in the wake of the revolutionary regime changes and tailored to the objective of asset recovery, specifies criteria for the freezing of assets, and provides a legal basis for their confiscation and restitution, covering all stages of the asset recovery process.

#### Available alternatives

Several alternatives exist that could be taken up by policy makers to address the limitations of EU-wide sanctions to address grand corruption.

Asset freezes could be made to work more effectively towards asset recovery by, for example, transferring the basis for asset freezes to a different legislative framework that involves judicial co-operation, or by creating new legislation addressing all aspects of the asset recovery process. While discussions are underway to introduce reforms in EU sanctions policy, these need to build on the lessons of existing misappropriation sanctions regimes.

## Introduction

Media reports tend to portray sanctions as a tool of foreign and security policy, often overlooking the existence of sanctions imposed to address the misappropriation of state assets. Reporting on the current EU sanctions regime in response to the crisis in Ukraine highlights the sanctions against Russian targets for their support of destabilisation in Eastern Ukraine, as well as the embargo on Crimea following its annexation. However, the existence of a sanctions regime freezing the assets misappropriated by members of the political elite ousted in the spring of 2014 receives by comparison little attention.

Indeed, while the EU has been imposing sanctions for decades under its Common Foreign and Security Policy (CFSP), the use of sanctions to address misappropriation of state assets represents a novel application of this tool. It emerged in response to the Arab uprisings of early 2011, and it was employed again in the aftermath of regime change in Ukraine. However, since the Maidan crisis in Ukraine, the EU has not applied assets freezes for this purpose again. These cases remain unique in the context of CFSP sanctions policy, as they constitute the only instances in which sanctions have been applied to leaders after their ousting. Further, they are the only assets freezes unaccompanied by visa bans.##Boogaerts et al. 2016##

After a life span of roughly four to seven years, the application of asset freezes under the CFSP to address misappropriation does not boast a satisfactory record. These measures have run into trouble. Firstly, following the initial freezing, the lack of criminal convictions of the individuals by their country’s judicial systems has not allowed the sanctions to move into the phase of asset recovery. Secondly, some of the targets have successfully challenged their designation in front of EU courts, which have annulled their listing due to insufficient evidence for the imposition of sanctions. The EU’s inability to maintain the freezing of assets swiftly effected after the ousting of the governments of Tunisia, Egypt and Ukraine has been mournfully described as a “short-term success but a long- term failure”.##Boogaerts 2018##

In light of this sub-optimal state of affairs, the present contribution aims to investigate the following questions with regard to misappropriation sanctions:

- What are the reasons behind the imposition of misappropriation sanctions and why have they been applied only in three cases?
- Have CFSP sanctions proved effective in combatting the misappropriation of state assets?
- Which obstacles constrain the effectiveness of these sanctions as a tool for asset recovery?
- How does the use of misappropriation sanctions compare to alternative tools for asset recovery?

Ultimately, the objective of the study is to generate knowledge that can inform the actions of civil society organisations and policy experts active in the field. Existing research cannot be relied upon for this purpose: Scholarship has produced some studies on the impact of blacklists on individuals. However, such research has focused on the measures’ impacts on the behaviour of designees##Cosgrove 2005; Wallensteen and Grusell 2012; Portela 2018a# or on the political dynamics in the country affected##Portela 2010## rather than on their ability to facilitate asset recovery. Thus, a misappropriation angle is missing. The proposed study aims to address this gap, focusing on the EU’s experience. The investigation relies on desk review of both academic and grey literature, selected jurisprudence and EU official documents as well as anonymous interviews with representatives from various EU Member States and EU institutions in Brussels conducted between spring 2017 and autumn 2018.

The study proceeds as follows. First, it outlines the EU’s use of assets freezes to address misappropriation of state funds, identifying their aims and evaluating their efficacy. Secondly, based on the information available, it attempts an explanation of the selectivity with which this tool has been employed so far: it entails only three cases, all of which occurred in the period from 2011 to 2014. The following section delves into the characteristics of existing EU legislation, performing an analysis of the CFSP instrument and comparing it to the Swiss legislative model addressing the same issue. This is followed by an exploration of the three instances of application of asset freezes: Tunisia, Egypt and Ukraine. To conclude, a final section presents the overall findings.

## Asset freezes as CFSP Sanctions

Before analysing the EU ́s employment of asset freezing sanctions to address the misappropriation of state funds, this section will outline the decision-making environment in which such decisions are framed, and contextualise it within EU external governance. The assets freezes were agreed under the foreign policy coordination framework of the EU, the CFSP. In this intergovernmental forum, each Member State has one vote and decisions are adopted by unanimity, meaning that each Member State formally has a veto. CFSP sanctions are adopted in pursuance of the objectives of the EU’s external action as stipulated in Art 21(2) of the Treaty on European Union (TEU), which include, among others, to consolidate and support democracy, the rule of law, human rights and international law, as well as to foster the sustainable economic, social and environmental development of developing countries.##European Union (2008) Treaty on European Union, art 21(2)##

The trigger for the adoption of sanctions comes from the geographical working group dealing with the country concerned. A Member State must present the proposal, although it may also be tabled by the High Representative of the Union for Foreign Affairs and Security Policy (HR). Ultimately, though, all Member States must agree to it, given the requirement for unanimity. A request by a third country is only discussed if a Member State or the HR asks for its inclusion in the agenda. Nothing precludes any of the Member States from proposing an asset freeze in a third country in the absence of an explicit request. Indeed, in CFSP practice, the proposal of sanctions regimes at the request of a third country represents the exception rather than the norm.

The decision-making procedure consists of two steps.##Portela 2010## A Council Decision is first adopted under Title V of the TEU. This act represents the political decision to wield sanctions. Because of their bearing on the single market, decisions on sanctions require the subsequent adoption of another type of EU legal act - a Regulation - to give effect to the bans reflected in the CFSP act. Accordingly, Regulations, which are agreed under qualified majority voting (QMV), invariably follow the initial CFSP measure.##For a background to this mechanism, see Gestri 2016## The current legal basis is Article 215 of the Treaty on the Functioning of the European Union (TFEU), which provides for the adoption of sanctions against third countries as well as individuals, groups and non-state entities. 

#### Article 215 (3), TFEU

1. Where a decision, adopted in accordance with Chapter 2 of Title V of the Treaty on European Union, provides for the interruption or reduction, in part or completely, of economic and financial relations with one or more third countries, the Council, acting by a qualified majority on a joint proposal from the High Representative of the Union for Foreign Affairs and Security Policy and the Commission, shall adopt the necessary measures. It shall inform the European Parliament thereof.

2. Where a decision adopted in accordance with Chapter 2 of Title V of the Treaty on European Union so provides, the Council may adopt restrictive measures under the procedure referred to in paragraph 1 against natural or legal persons and groups or non- State entities.

Once sanctions are enacted, they are subjected to periodic renewal, normally every twelve months. Renewals take the form of Council Decisions and must again be agreed upon by unanimity. Under the current treaty, the Court of the Justice of European Union (CJEU) has limited powers in the CFSP. However, sanctions imposed against individuals are subject to the jurisdiction of the Court, which established in its 2008 ruling on Kadi8 that it is competent to review the conformity of CFSP designations with fundamental rights.##Happold 2016; Portela 2009## As a result, sanction regulations must provide adequate safeguards to protect the fundamental rights of those affected by the measures.

As a general foreign policy framework lacking any specific anti-corruption dimension, CFSP acts do not contain any elements permitting a follow-up to the initial freeze. There are no provisions for efforts leading to the confiscation and return of assets at EU level, which means that any action for asset recovery must take place at the level of the individual Member States concerned.

## The Use and Efficacy of Assets Freezes

Sanctions are generally believed to be geared towards achieving a change of behaviour in the target.##See e.g. Nephew 2018## However, scholarship has long recognised that sanctions success should not be measured just in terms of their contribution to the achievement of a change of behaviour in the targeted leadership. Sanctions fulfil a number of functions beyond forcing compliance. Several authors have pointed to a myriad of roles played by sanctions other than coercion.##Barber 1979## They can limit the military or economic capacity of the target, thereby preventing them from pursuing policies opposed by the sanctioning authority. Sanctions may also deter third countries from following a similar course.##Barber 1979## They can be used to protect activists and political opponents exposed to state repression, or to divert the attention of the local public from domestic problems, focusing discontent on a battle against an “external enemy”.##Stepien et al. 2016## Imposing sanctions can also improve the image and electoral prospects of the leaders who advocate them. Importantly, they can be employed to position international actors strategically in the context of an international dispute.##Taylor 2009; Hellquist 2016## In the case of the EU, it has been suggested that wielding sanctions helps strengthen its international presence.##Blavoukos and Bourantonis 2014## The differentiated evaluation of multiple goals has gradually established itself in sanctions research.##Biersteker et al. 2016; Moret et al. 2016; Giumelli 2018## The success or failure of sanctions can only be evaluated against their goals. In order to assess the efficacy of the measures, their objectives must first be ascertained.

Misappropriation sanctions regimes differ fundamentally from the rest of CFSP sanctions. They are accordingly treated as special cases by EU authorities. From the perspective of EU Member States, standard CFSP sanctions are meant to compel the target to change course, and deter specific forms of behaviour. By contrast, misappropriation regimes were not conceived as means of pressure to bring about a specific outcome from the targeted individuals or national authorities.##Boogaerts 2018## Instead, the freezes were imposed with a two-fold intention in mind, one of them is rather technical in nature, while the other is political.

Firstly, the freezing of assets constitutes a pre-requisite for the later recovery of assets. The objective was to prevent the flight of capital by members of the ousted leadership and their associates. The freezes are meant to prevent the flight of misappropriated funds until these can be recovered. Illustratively, the measure is referred to as “preventive blocking” (French: “blocage preventif”) under Swiss legislation.

Since deposed leaders left office abruptly and swiftly, they retained access to public funds they could easily transfer, in addition to access to funds misappropriated at an earlier stage. The urgency of the situation made it imperative to freeze the assets immediately, in order to afford some time for the authorities from the affected countries to issue international mutual legal assistance requests. Thus, the freezes were temporary in character, and were put in place in a quickly evolving context, on the assumption that they would be replaced by a formal request of mutual legal assistance (MLA) shortly after. As explained by then-HR Catherine Ashton, “the frozen assets cannot just be released; first ownership must rightfully be transferred to the new state structures”.##Ashton 2012## The EU intends “to be ready to lift them quickly when we are in the position to be able to make sure that the assets are returned to the people”.##Ashton 2012## This formulation reveals that the recovery of assets and their restoration to the coffers of the originating countries##The terms originating and requesting countries are employed indistinctively throughout the text, indicating the state that issues the request for freezing and/or MLA.## constitutes the ultimate objective of the measure. Equally, this shows that misappropriation sanctions do not pursue the goal of coercing any government or individual to change behaviour, which contrasts sharply with the popular belief that sanctions are invariably about those goals. Any coercive intention would be ineffective anyway given that the targeted individuals are no longer in office. Having fled the country, former leaders and most of their entourage have disappeared from the political landscape.

The freezing of assets constitutes only the first step in the recovery process, and it is also the only one that can be dealt with at the EU level under the current legal framework. The subsequent stages, i.e. identification of assets and return to the originating state with the help of a MLA are to be handled at the level of Member States.

A separate - if closely related - rationale of misappropriation sanctions is to support the new leaderships that replaced the rulers ousted during the Arab Spring. The motivation is clearly political: the asset freezes were applied as a signal of support to the post-revolutionary leaderships of Tunisia and Egypt.##Boogaerts 2018## This goal was of key importance to the EU given that the initial European response to the protests had not been one of unequivocal backing. Prior to the overthrow of the doomed regimes, most European government had been cautious about aligning themselves with the upheavals. France infamously offered help to the Tunisian government to repress the revolts.##Chrisafis 2011## From this point of vantage, the freezing of the assets of ousted leaders was designed to make up for the initial absence of support and to build bridges with a new political elite, with which Europeans had no previous links. Such conciliatory gestures were all the more pertinent given that European hesitation about backing the popular protests was at odds with the EU’s declared objective of promoting democracy in its neighbourhood. The situation repeated itself three years later with the Maidan protests in Ukraine, where the freezing of assets by the EU followed a sudden change of government. Due to the parallelism between the Arab Spring and the Maidan protest, characterised by a pattern of popular unrest leading to the unexpected ousting of the leadership, the EU replicated the approach witnessed in the aftermath of the Arab revolts. This reading was confirmed by the CJEU, which declared in relation to the Egyptian freeze that the freezes were “part of a policy of supporting the new Egyptian authorities”.##Case C-220/14 P, Ezz and others v Council, 15 March 2015, para 43—48##

The message of support conveyed by the freezes is not merely a symbolic gesture of solidarity with post- revolutionary forces that seized power. Restoring the assets frozen to the state coffers contributes to the stabilisation of post-revolutionary situations and of new governments. Recovered funds can be used to aid the economic development of the often impoverished requesting states.##The Economist 2014, Kettis and Hakala 2013## With limited finances, new leaderships find it difficult to build legitimacy and to implement reforms. The Council of the EU framed the adoption of freezes as part of a policy of democracy promotion. The original text of the CFSP Decision on Tunisia announced the freezing of assets “against persons responsible for misappropriation of Tunisian state funds and who are thus depriving the Tunisian people of the benefits of the sustainable development of their economy and society and undermining the development of democracy in the country” (author’s emphasis).##Council 2011a## Similar wording was inserted in the CFSP Decision adopting identical measures with regard to Egypt barely two months later.##Council 2011a##

In consequence, any evaluation of whether sanctions have been successful ought to be conducted with reference to these two sets of objectives: enabling asset recovery and conveying support to post-revolutionary governments.##Interview with EU Member States representatives (2) and (4), Brussels, September 2018 and October 2018##

## The Selective Application of Asset Freezes

After adopting a practice of freezing assets to aid their recovery, the EU has made sparse use of this tool, deploying it in some but not all occasions where it could have been relevant. How can this be explained?

As described above, the freezes were originally agreed as temporary measures, in the expectation that they would be replaced by mutual legal assistance requests shortly after. However, several years on, few designees have been indicted in their countries of origin. In some cases, no charges have yet been made. The slow pace at which these cases are proceeding can be explained by several reasons. Firstly, the ownership of funds by members of the former leadership is often difficult to establish, as it might be hidden under several layers of front companies. Thus, investigations are often of a complex and protracted nature. As explained by Bill Browder, chief executive of Hermitage Capital and anti-corruption activist, money launderers “create a situation where the money has moved through so many different companies and so many different countries, in so many different accounts that it would be almost impossible to recreate the trail”.#Quoted in Aljazeera 2018##  Misappropriated assets were reportedly transferred to companies in Ukraine via bank accounts in Latvia and later passed through dozens of offshore shell companies in Cyprus, Belize, British Virgin Islands and the UK, for example.##Aljazeera 2018##

Secondly, the judicial system in post-revolutionary settings is seldom free of political interference. As posited by asset recovery expert Gretta Fenner, “independence of the prosecutor general office is...often not given in countries that still struggle in democratic transition. Prosecution services all around the world, in countries with young democracy or no democracy for a long time, have actively been used as a tool of political power”.##Fenner 2016, p.19## To take Ukraine as an example: the director of the Ukrainian Anti-corruption Bureau has complained about political interference claiming that “resistance is very strong from the elites who are in power now and the more we investigate, the more we face this resistance”, alluding also to the obstructive role of parliament: “Parliament is taking steps to side-line the management of the Anti-Corruption Agency and take control”.##Quoted in Aljazeera 2018## The problem is particularly acute in the case of the Ukrainian judiciary.##Lough and Dubrovskiy 2018, Bullough 2014## The Ukrainian judiciary performs very poorly according to indicators of judicial independence produced by the World Economic Forum, which ranks Ukraine 129 out of 137 countries in judicial independence for the year 2017.

### The view from Brussels

This state of affairs is unsatisfactory from the viewpoint of Brussels.##The present section is primarily based on interviews with anonymous officials and experts conducted between spring 2017 and autumn 2018. See Annex 1.## While EU capitals have different views on the usefulness of assets freezes to address misappropriation, negative assessments prevail. The main problem that the Council of the EU has encountered is the scrutiny of its own judiciary.

Following the 2008 landmark ruling on Kadi,##Court of Justice of the EU 2008## a citizen who successfully contested his inclusion in the EU’s terrorism list, blacklisted individuals frequently challenge their designations in front of EU courts.##Happold 2016; Portela 2009, 2018a## For years, the Council lost a large percentage of the cases brought to Court, which obliged it to drop the designations. The requirements of the CJEU to uphold the legality of blacklists have led the Council to seek better substantiation to underpin its designations (see below), improving their solidity. However, it has also compelled the Council to broaden the designation criteria as defined in EU legislation in an attempt to fend off court challenges. In the event, these efforts have borne fruit, managing to reverse the trend. Michael Bishop, an official from the legal service at the Council Secretariat reported: “In 2012, 2013 and 2014 the Council was still losing twice as many cases as it won... In 2015 that trend was reversed; the Council won more than twice as many cases as it lost. The same applies for 2016”.####Bishop quoted in House of Lords 2017#### Improvement to the statement of reasons has indeed allowed the Council to uphold designations. This is visible in the few cases of litigation initiated by Tunisian targets: the General Court has rejected requests to annul the listings of Mehdi Ben Ali, Fahed Al Matri’s, Sirine Ben Ali and Mohamed Mabrouk.##Boogaerts 2018##

Despite a positive trend, litigation remains a concern for the Council. Unfavourable rulings are seen as impinging upon the Council’s credibility and prestige.##Interview with EU member state representative (1), Brussels, March 2017## In order to satisfy CJEU requirements, the Council requests updated supporting information from the prosecutor offices of the requesting states every time that a court case is decided as well as prior yearly revision of measures, in an effort to strengthen the evidentiary basis of the listings. This constitutes an exercise especially resented by Member States which have not located any misappropriated assets in their jurisdictions. Since the EU does not conduct independent investigations, the Council depends on the information submitted by foreign prosecutor offices. As former UK cabinet member David Lidington confirmed, “the information the EU relies upon to conduct its review can only be provided by an authority in the targeted state”.##Lidington 2015a, p.2## Deadlines have been met sometimes very narrowly by the judiciaries of the requesting states. In one instance reported to the UK House of Lords, a final piece of supporting information was only received from the Ukrainian authorities the day before the renewal of the measures.##Lidington 2015, p.2##  This led the chair of the Select Committee on the European Union in the UK House of Lords to complain about the resulting lack of parliamentary scrutiny, claiming that the European External Action Service (EEAS) “should have impressed upon the Ukrainian authorities the importance of providing the information in sufficient time for prior scrutiny by national parliaments, rather than a few days before adoption by the Council”.##Boswell 2015, p.1##

However, the Council is unable to speed up the pace of investigation and indictment as this process remains in the hands of the judiciaries of the requesting countries. EU Member States are reticent about influencing foreign judicial systems, which are expected to operate independently from political pressure. In the words of David Lidington, “although EU Member States are committed to supporting the asset recovery process in Ukraine, Egypt and Tunisia, there are limits to the influence we can bring to bear on their national judicial proceedings”.##Lidington 2015a, p.2## In sum, the Council is responsible for upholding often fragile designations in front of its own judiciary for an indefinite period, while it is not in its power to bring the investigation process to a successful conclusion. This situation has generated uneasiness and a certain degree of pessimism.##Boogaerts 2018## In the words of one interviewee, “these sanctions regimes are unsustainable in the long term”.##Interview with EU Member State representative (3), Brussels, October 2018## The fragile nature of these sanctions regimes can be read off the decremental dynamics of the blacklists: The list is only altered due to the dropping of existing designations, but never as a result of the insertion of new entries.

Indeed, in the absence of convictions in the requesting country, the de-listing of designees has occurred under either of the following scenarios:
1. successful court challenges by the designee;
2. a decision by the Council to drop the entry based on the realisation that the evidentiary basis of the listing was unlikely to withstand judicial scrutiny;
3. a decision by the requesting country to drop charges, often having reached a settlement with the listed individual, which compels the EU to de- list the individual.

In view of the outlined difficulties, prospects of recourse to asset freezes along the lines of the Tunisia, Egypt and Ukraine regimes seem dim.##Interview with EU Member State representative (1),Brussels, March 2017; Interview with EU Member State representatives (3) and (4), Brussels, October 2018## Nevertheless, the establishment of new misappropriation sanctions cannot be excluded. Member States are satisfied with the political performance of the sanctions regimes as a link of solidarity and support to the leaderships in the requesting states,##Interview with EU Member State representative (2), Brussels, September 2018## as demonstrated by the continuation of the freezes. Moreover, since 2014, we have not witnessed any revolutionary movement that has culminated in the replacement of the leadership in any country. Neither has there been any (known) instance of a third country requesting the EU to freeze assets presumed to have been misappropriated by members of a leadership previously in power. Therefore, there is no firm evidence that current discontent with the state of affairs will prevent the Council from resorting to CFSP asset freezes in future.

### The specificities of the misappropriation regimes

An analysis of the misappropriation sanctions regimes shows that the absence of a coercive objective is not the only feature that sets them apart from other sanctions regimes. A number of differences that have hardly been captured by observers point to misappropriation regimes as measures “for the benefit of a third party”, in the absence of an established technical term. Here, the EU limits its role to back a judicial process in a third country. Catherine Ashton presented the freezes as a policy of assistance, rather than of anti-corruption: “ownership must rightfully be transferred to the new state structures. This is a complex process. (...) [w]e are ready to assist those states concerned” (author’s emphasis).##Ashton 2012##

The regime is characterised by the following traits:
1. The listings emanate from the third country, rather than from EU Member States.
2. The aim of the EU is not to fight corruption per se. In the words of David Lidington, they were imposed “to prevent misappropriated state funds from undermining the stability and development of the state in question”.##Lidington 2015a, p.1## There is a difference in nuance that points to political stability in the affected state rather than to notions such as the fight against impunity that characterise the anti-corruption discourse.
3. Even though the Council conducts its own review of listings prior to their periodical renewal, it relies on information that can only be provided by third state parties. The Council is not required to show that allegations against the individual are well-founded, but rather that the listing criteria are met.##Timmermans and Mogherini 2017## The corollary is that individuals are de-listed as soon as third state authorities have reached a settlement with them. As confirmed by UK Minister for Europe Alan Duncan, “those designated under the EU’s misappropriation sanctions for Tunisia, Ukraine and Egypt can be de-listed when the Council is satisfied that legal cases and judicial procedures in these countries have been concluded or discontinued”.##Duncan 2017, p.2##

The practice of freezing assets to address misappropriation has been criticised by legal practitioners. Maya Lester, a barrister experienced in acting for blacklisted individuals, complained about the potential for political misuse associated with the reliance on designations requested by third parties as they circumvent established processes for countries providing each other with MLA requests: “The EU lists people said to be connected with former regimes (the Yanukovych, Ben Ali & Mubarak regimes) on the basis that people are under ‘judicial investigation’ in those countries for having misappropriated State funds. (...) The European Court has upheld the lawfulness of those regimes, and rejected submissions that there should be adequate safeguards to ensure that there is evidence, a prima facie case, and a fair trial in those countries”.##Lester 2016, p. 6##

The risk that requesting leaderships may be tempted to neutralise innocent political opponents by suggesting their inclusion in EU blacklists is mitigated by the review of the designations that precedes the yearly renewal of the measures. This exercise involves an assessment by the EEAS and the Council of the progress made in each of the outstanding proceedings against the blacklisted individuals to ensure that they remain justified.##Duncan 2017, p.1-2## The practice of regular review of designations has been praised by the UN Special Rapporteur Idriss Jazairy.##European Parliament 2017c## Nevertheless, some level of risk remains.

### Conclusion

In conclusion, various factors underline the exceptionality of the misappropriation regimes. The freezes were originally adopted as a response to a crisis of the magnitude of the Arab Spring. Because of the atypical nature of the crisis, the EU lacked a ‘blueprint’ for addressing successful revolutionary revolts. The imposition of an asset freeze was instrumental in establishing amicable links to the post- revolutionary elites, by meeting one of their first requests to the EU. Thus, it helped European governments position themselves in favour of the new governments. The Council resorted to the CFSP not only because it is an instrument often used to freeze assets, but also because the situation at hand was seen as a foreign policy matter requiring a foreign policy response. The Maidan crisis replicated this pattern, giving rise to an identical reaction.

Over time, the adoption of this policy came to be regarded as disappointing, although some variation exists among Member States in the level of satisfaction with this set of measures. The main source of unease are the abundantcourt challenges. Given that designations do not come from Member States, but from the requesting country concerned, the Council has had to rely on a third party for the substantiation of listings. This puts the EU in the uncomfortable position of depending on an external party for information to uphold its listings, almost inverting the notion of “petitioning state”. That the process of indictment and conviction remains the hands of judicial systems which are not free from political interference further complicates the matter. The EU lacks the legitimacy to exert influence on a foreign judiciary, as well as the means to protect it from domestic interference.

Even though the CFSP includes the rule of law among its objectives, the EU did not regard the freezing of assets in Tunisia, Egypt and Ukraine as a measure to fight corruption in the first place. A foreign policy rationale prevailed over anti-corruption considerations. This is in consonance with EU sanctions tradition: While sanctions have often been applied in response to democratic backsliding in third countries,##Bartels 2014## there is no single case of sanctions imposed to address corruption other than the three misappropriation regimes in question here.##Boogaerts et al. 2016## Notably, none of these sanctions pits the EU against a foreign government. Because they concern deposed leaders, they do not carry a political cost to the EU. Rather, they afford the EU with the gratitude of the post- revolutionary governments, which perceive it as a powerful gesture of support. This is despite the fact that misappropriation blacklists have also represented a source of tension. In spite of the EU asset freeze, the UK Treasury failed to ensure property linked to individuals convicted of embezzling funds from Egypt was adequately frozen, leading to accusations that ministers were “more interested in preserving the City of London's cosy relationship with the Arab financial sector than in securing justice”.##Shenker 2012## Tunisia and Ukraine further discreetly complain that some EU Member States are unprepared to share information necessary for the domestic investigations.##Boogaerts 2018##

This primarily foreign policy rationale of the misappropriation sanctions regimes represents a reason for its perpetuation despite the meagre progress achieved so far: Member States see the value of keeping them in place because of the appreciation shown by the requesting governments, where societal demand for asset recovery is very pronounced.##Bullough 2014, Anticorruption Action Centre 2017## Particular importance is attached to bilateral relations with the requesting countries, which are all partners included in the European Neighbourhood Policy (ENP), with which the EU seeks close relations on account of their location in its unstablesurroundings.##Portela 2017##

## The EU and the Swiss Legal Frameworks

### The EU Framework

#### Legal Instruments Implementing Asset Freezes

As mentioned at the outset, sanctions are agreed by a unanimous decision of the EU Council.##TEU, Art. 24.## However, to the extent that such decisions require measures that affect the Union’s “economic and financial relations with one or more third countries”, they must further be implemented by a regulation detailing the exact scope of those measures.##TFEU, Art. 215(1)## Sanctions falling within this provision include “restrictive measures against natural or legal persons and groups”, in particular asset freezes.##TFEU, Art. 215(2)## Because of this dual structure, EU sanctions-based asset freeze measures, such as those related to misappropriation of public funds in third countries, always rest on two separate legal instruments: a Council Decision and a Council Regulation implementing that Decision. The regulations are directly applicable in all EU Member States, meaning that they create legal obligations directly to EU citizens and entities established in the EU, without any need for additional national implementing measures. For instance, any EU financial institution is obligated to implement an asset freeze measure immediately upon a regulation entering into force via publication in the Official Journal of the European Union.

Each of the misappropriation sanctions regimes of the EU have been established through a different set of legal instruments. Chronologically, the first of these were sanctions related to Tunisia, adopted through Council Decision 2011/72/CFSP on 31 January 2011, followed closely by those related to Egypt, adopted through Council Decision 2011/172/CFSP on 21 March 2011. Finally, sanctions related to misappropriation in Ukraine were established through Council Decision 2014/199/CFSP on 5 March 2014.##Council 2011a, 2011b and 2014##

Each decision was accompanied by a regulation implementing its economic and financial aspects: respectively, Council Regulation (EU) No 101/2011, Council Regulation (EU) No 270/2011, and Council Regulation No (EU) 208/2014. All six legal instruments have been amended several times since their adoption, primarily in order to modify their annexes which contain the lists of persons targeted by the asset freezes, their identification details, and statements of reasons for each person targeted, as well as in certain cases to amend “listing criteria”, i.e. the definition of who can be subjected to the asset freezing measure. Very often such modifications were a reaction to judgements from the European Court of Justice, annulling specific measures due to procedural or other defects, as discussed below.

The substantive provisions of each regulation are almost identical. For instance, the current regulation related to Ukraine contains the following provisions: Article 1 provides for the definitions used in the Regulation; Article 2 provides for the freezing of assets, and the prohibition on making assets available, to parties listed in an annex; Article 3 describes the criteria under which persons may be added to the annex as well as the information that must be provided for each entry on it; Articles 4 to 7 provide for various grounds on the basis of which national competent authorities may authorise exceptions to the freezing measures as well as other exemptions (such as for funds needed to basic living expenses, to pay for pre-existing debts, legal fees, etc.); Articles 8 and 12 provide for reporting to authorities of assets frozen as well as exchanging such information among the Member States and the European Commission; Article 9 establishes a prohibition on measures intended to circumvent the asset freeze##This is one of the two provisions not included in the
regulations relating to Egypt or Tunisia.##; Articles 10 and 11 provide for limits of liability and protection from claims of EU operators##The “no claims” article is the other of the two provision not included in the regulations relating to Egypt or Tunisia.##; Articles 13 and 16 require Member States to designate national frozen funds to the originating governments. In their absence, the title to any frozen assets would have to be transferred to the requesting state via a bilateral MLA request, which relies on domestic judicial proceeding in the originating country and bilateral co-operation between judicial authorities. In 2012, the EU adopted new legislation aimed at facilitating the release and return to the Egyptian and Tunisian authorities of funds frozen under EU sanctions by authorising EU Member States to release frozen assets on the basis of judicial decisions recognised in other EU members.##Council 2012## Despite this improvement, recovering and repatriating assets remains a competence of Member States and must occur via a MLA procedure. Thus, the asset freeze enacted by the EU remains unconnected from subsequent endeavours to recover and repatriate assets, which must be effected at the level of Member States.##Kettis and Hakala 2013##

### Case Law and Analysis

EU sanctions measures implementing asset freezes in response to misappropriation of state funds in third countries have been extensively tested in the CJEU, as have other forms of EU targeted sanctions. By December 2018, the General Court (its court of first instance) and the Court of Justice (the appellate body) had issued a total of 35 judgments related to the asset freeze regimes on Egypt, Tunisia, and Ukraine. The primary focus of those cases has been claims by those targeted that the asset freeze violated their substantive or procedural fundamental rights, such as the right to property, the right to a fair trial, including rights of the defence, and failure to state reasons, and that the Council had made manifest errors of judgment and misused its powers in ordering the freezes.##In chronological order based on the publication of the judgement, these are Cases T-188/11, T-200/11, T- 290/14, T-486/14, T-246/15, T-434/14, T-258/17, T- 187/11, T-133/12, T-331/14, T-332/14, T-341/14, T- 340/14, T-348/14, T-346/14, T-731/15, T-256/11, C- 220/14, T-200/14, T-224/14, T-516/13, T-545/13, T- 221/15, T-215/15, T-149/15, T-175/15, C-598/16, C- 599/16, T-245/15, T-242/16, T-190/16, T-288/15, T- 216/17, T-358/17 and C-530/17. See Annex 2.## Out of 31 General Court judgements, the appeal by the designees has been entirely dismissed in twelve cases, with six appeals being successful and a further nine leading to partial annulment of the measures. Four appeals have been lodged to the Court of Justice by designees, all of them unsuccessful until Mykola Azarov, a former Prime Minister of Ukraine, won his appeal in December 2018. In most cases where the Council lost, it re-imposed the sanctions under improved evidence or a procedure.

This case law, and that related to other EU sanctions, delineates the limits of the EU’s competence in adopting and maintaining asset freezes in the CFSP context as well as procedural requirements in doing so. Prior to the Arab Spring, the EU had never adopted CFSP sanctions in response to misappropriation of state funds. Until then, they were targeted at more traditional security and foreign policy threats##Portela 2012##: human rights breaches and democratic backsliding##E.g. Myanmar##, armed conflict##E.g. Syria##, proliferation of weapons of mass destruction##E.g. Iran## and terrorism.##E.g. the EU autonomous terrorism listings under Common Position 2001/931/CFSP## One of the questions underlying the early case law was, therefore, whether the imposition of misappropriation sanctions was appropriate under the CFSP at all, or whether other mechanism should have been used.

However, the General Court explicitly rejected any such claims, noting on the case of Egypt that the Council adopted the measures to “support the peaceful and orderly transition to a civilian and democratic government in Egypt based on the rule of law, with full respect for human rights and fundamental freedoms” as part of part of a “policy of supporting the new Egyptian authorities, intended to promote both the economic and political stability in Egypt”. As such, the Court ruled, the measures were “fully based on the CFSP and satisfied” the objectives of EU external action.##Case T-256/11, Ezz and others v Council, 27 February 2014, para 44##

Importantly, the Court has affirmed that the act of using the CFSP asset freeze mechanism in relation to third state misappropriation situations is not, in itself, a disproportionate violation of the right to property of those targeted. The Court recalled that under the EU Charter of Fundamental Rights, such rights may be limited under certain conditions – specifically, limitations are justified to the extent that they are provided for by law, pursue an important general interest of the EU, and are proportional to the general interest being pursued.##Case T-256/11, Ezz and others v Council,27 February 2014, para 196## In the context of misappropriation sanctions, the Court has been satisfied that all three can, in principle, be met.

As for the general interest being pursued, the Court noted that the sanctions in the case of Egypt, by way of example, were “part of a policy of supporting the new Egyptian authorities, intended to promote both the economic and political stability of Egypt and, in particular, to assist the authorities of that country in their fight against the misappropriation of State funds” which, in turn, was compatible with EU external policy objectives laid down in the Treaty, including the aim to “consolidate and support democracy, the rule of law, human rights and the principles of international law”.##Case C-220/14 P, Ezz and others v Council, 15 March 2015, para 43—48##

As for the proportionality of the asset freeze in relation to that objective, the Court has emphasised that “respect for the rule of law is one of the primary values on which the European Union is founded”##Case T-348/14, Yanukovych v Council, 15 September 2016, para 98## and therefore a weighty objective. At the same time, the Court highlighted that not all acts of misappropriation of public funds in third countries would be serious enough to be capable of undermining the rule of law to the extent that a CFSP asset freeze, and the resulting infringement of the right to property, would be a justified and proportionate measure. For an (alleged) act to qualify, the Court reasoned, it would have to be serious enough “having regard to the amount or the type of funds or assets misappropriated or to the context in which the offence took place” so that it could “undermine the legal and institutional foundations of [the country in question] and in particular the principles of legality, prohibition of arbitrary exercise of power by the executive, effective judicial review and equality before the law and, ultimately, to undermine respect for the rule of law in that country”.##Case T-340/14, Klyuyev v Council, 15 September 2016, para 91## But within such a context, the General Court ruled, the asset freeze measure would be proportional.##Ibid## On appeal, the Court of Justice further confirmed that an asset freeze could be justified also against a person subject to merely a pre-trial investigation for such acts, since “the effectiveness of a decision to freeze funds would be undermined if the adoption of restrictive measures were made subject to the criminal convictions of persons suspected of having misappropriated funds, since those persons would have enough time pending their conviction to transfer their assets”.##Case C-599/16 P, Yanukovych v Council, para 60##

As for being “provided for by law”, the Court has noted the activities of which the targeted person is accused must strictly fall within the stated objective of the measure, i.e. constitute “misappropriation”. To establish the scope of the term misappropriation, undefined in all of the regulations, the Court has relied on an EU Directive related to financial crime, which defines it as “the action of a public official who is directly or indirectly entrusted with the management of funds or assets to commit or disburse funds or appropriate or use assets contrary to the purpose for which they were intended in any way which damages the Union’s financial interests”.##Case T-246/15, Ivanyushchenko, v Council, 19 October 2017, para 92, and Article 4(3) of Directive (EU) 2017/1371 of the European Parliament and of the Council on the fight against fraud to the Union’s financial interests by means of criminal law## In this vein, the Court noted that a person accused of having engaged in cross-border money-laundering operations from Tunisia could not legally be subjected to an asset freeze on this basis, since, while unlawful in Tunisia, it did not constitute “misappropriation”.##Case T-187/11, Trabelsi and others v Council, 28 May 2013, para 93. See also Case T-246/15, Ivanyushchenko v Council, 8 November 2017, para 152—155## If, however, the alleged activity indeed does squarely fall within that definition, the Court has accepted that also this “provided by law” requirement is satisfied in EU’s misappropriation sanctions##Case T-256/11, 27 February 2014, para 202 and 206.## and that, therefore, they do not in themselves constitute an illegal violation of the right to property.

In other words, the EU Courts have confirmed that freezing assets to counter misappropriation of third State funds is within the acceptable remit of the asset freeze tool in the CFSP toolkit. However, the Court has also emphasised that any such measure must not only satisfy the proportionality described test above, but also a set of other, mostly procedural requirements.

According to established case law from the EU Courts, a decision to impose an asset freeze on any individual or entity must be based on a “solid factual basis”, as evidenced by information in the Council’s file.##See, for instance, Case C-280/12, Council v Fulmen and
Mahmoudian, 28 November 2013, para 64## In a series of cases ruled on by the Court in late 2015 and early 2016, former Ukrainian officials subject to an asset freeze claimed that no such basis existed for the measures to which they had been subjected.##Cases T-290/14, T-331/14, T-332/14, T-340/14, T-341/14, T-346/14, T-348/14, T-486/14, and T-741/14, all decided on nearly identical language on this issue## When prompted, the Council was only able to produce, as evidence of the factual basis of the measures, a letter from the Public Prosecutor’s Office of Ukraine to the EU’s foreign policy chief, listing the individuals in question and stating that “Ukrainian law enforcement authorities have initiated a number of criminal proceedings to investigate criminal acts committed” by the senior officials listed, and that “that the inquiry in question made it possible to establish misappropriation of sizeable amounts of State funds and the subsequent illegal transfer of those funds outside Ukraine”, without adding further detail.##E.g. Case T-290, Portnov v Council, 16 October 2015, para 41## The Court noted that the letter was so vague that the Council had not been able to show evidence indicating that it had “any information regarding the acts or conduct specifically imputed to the [persons in question],” even when taking into account the commonly known post-revolutionary context of Ukraine.##E.g. ibid., para 48##

To shield the Ukrainian freezes from successful challenges, the Council has taken a number of steps to build up the underlying evidence, broaden the criteria for listing the targeted persons, and elaborate on individual statements of reasons.##Council Decisions 2014/216/CFSP of 14 April 2014, 2015/143 of 29 January 2015, 2015/364 of 5 March 2015, 2015/1781 of 5 October 2015, 2016/318 of 4 March 2016, and 2018/333 of 5 March 2018## In September 2016, the General Court issued its judgement on the case brought against the Council by Viktor Yanukovych, the former president of Ukraine.##Case T-346/14, Yanukovych v Council, 15 September 2016## As with so many earlier cases, the Court noted that the vague letter from Ukrainian prosecutors was not specific enough to justify an EU asset freeze, and went on to annul the original asset freeze against Mr Yanukovych.##Ibid, para 44—53##

However, the Court then pointed out that the Council had, since the initial freeze, modified the underlying legal instruments by adopting a modified statement of reasons for the listing of Mr Yanukovych in 2015 and had provided, as evidence underlying that new decision, a new letter from the Ukrainian Prosecutors, received in October 2014. In this letter, the Court pointed out, the authorities had described in detail “three pre-trial investigations within the framework of criminal proceedings initiated with respect to the applicant in relation to acts classifiable as misappropriation of public funds [concerning] (i) misappropriation of assets while acting in concert with others as part of the illegal funding of construction of a telecommunications network; (ii) misappropriation of buildings, facilities and land, together with other public properties and the legalisation of ill-gotten gains, and (iii) misappropriation of a plot of land”.##Ibid, para 138## The Court was satisfied that this provided a sufficiently solid basis for the adoption of the measure and its statement of reasons, i.e. that Mr Yanukovych was “was the subject of criminal proceedings for misappropriation of public funds or assets” in Ukraine.

Mr Yanukovych’s appeal was later rejected by the Court of Justice, which confirmed that “the detailed nature of the charges brought against the appellant, as set out in [the 2015 letter]” established an appropriate factual basis for the asset freeze##Case C-598/16, Yanukovych v Council, 10 October 2017, para 74##, in the absence of contradicting exculpatory evidence produced by Mr Yanukovych. In later case law the Court has required, in cases where such contrary evidence plausibly challenges the reliability of the Council’s position, that the Council investigates further to determine the continued justification of the measure.##Case T-731/15, Klyuyev v Council, 21 February 2018, para 255—256##

In sum, the EU may choose to adopt misappropriation related asset freezes against individuals in third countries if:
1. the activities can be categorised as “misappropriation”, referring to “a public official who is directly or indirectly entrusted with the management of funds or assets” using, disbursing, or appropriating those funds contrary to the purpose to which they were intended;
2. the activities are serious enough to be capable of undermining the rule of law in that third country; and
3. the measures are based on solid factual basis, indicating, for each targeted person, at least the existence of an investigation into activities satisfying (1) and (2).

On the whole, the evolution of the misappropriation sanctions case law closely resembles that of traditional sanctions practice.##Pursiainen 2017## In other words, the Courts initially acknowledged that the Council had not overstepped its CFSP discretion or fundamental rights boundaries by ordering asset freezes on individuals, but still annulled a series of listings in the absence of any reliable evidence to support the stated reasons. Then, after designees were listed with stronger evidence, the Court deferred to the Council on their adequacy, as long as they were not manifestly insufficient. Similar treatment was applied also to the listing criteria.

In its December 2018 ruling on Mykola Azarov’s appeal, the Court held that the Council is required to verify thatdecisions by foreign authorities which serve as a basis for EU measures respect the rights of defence and the right to effective judicial protection.##C-530/17 P of 19 December 2018 reverses General Court’s judgment T-247/17 of 13 December 2018## In other words, the Court now demands the Council not only obtain from the originating state adequate documentation indicating the existence of domestic proceedings against designees for misappropriation, but that the Council must also establish that those domestic proceedings respect fundamental rights. This most recent jurisprudence on Azarov suggests the emergence of a further complication in upholding the listings as it requires the Council to tighten the scrutiny of third-country requests before adopting its own freezes.

### The Swiss Framework

As the host of a vast amount of foreign assets and the recipient of a large number of MLA requests, Switzerland is a leader in the international asset-recovery agenda. Its legal framework enabling the freezing of assets has been the object of revision in recent years, and has become increasingly sophisticated.##Lohaus forthcoming##

#### Constitutional Basis

In Switzerland, the constitutional basis for asset freezes related to the potential misappropriation of State funds by officials in third countries is established by Article 54(1) of the Federal Constitution.##This is the basis on which the current Foreign Illicit
Assets Act, FIAA, was issued. Prior to that, ordinances were issued directly on the basis of Article 184(3) of the Constitution, which permit that Federal Council to issue temporary ordinances “safeguarding the interests of the country so require”.## Freezing ordinances, which resemble EU freezing regulations, are today issued on the basis of the Constitution and a subordinate regulation, the Federal Act on the Freezing and the Restitution of Illicit Assets held by Foreign Politically Exposed Persons (Foreign Illicit Assets Act, FIAA), adopted in 2016. In contrast to the EU, where misappropriation related assets freezes are adopted under the CFSP, like any other sanctions against third states, the Swiss legal basis is separate from powers of the Federal Council to adopt sanctions related to international peace and security, which are contained in the Federal Act on the Implementation of International Sanctions.##Which provides, in particular, that Switzerland may adopt sanctions in order to align with the UN Security Council, the OSCE, or “Switzerland’s most significant trading partners” like the EU.##

#### Legal Instruments Implementing Asset Freezes

The Foreign Illicit Assets Act, divided into nine sections, contains most of the substantial provisions applicable to asset freeze regimes adopted though individual ordinances.

Section 1 describes the purpose of the act and definitions used in it. Section 2 then lays down three separate bases for an asset freeze, permitting this:
1. in order to support future cooperation within the
framework of mutual legal assistance proceedings with the country of origin, when (a) there is a change or imminent change of power in the country, (b) the level of corruption in the country is notoriously high, (c) assets appear likely to have been acquired criminally, and (d) Switzerland’s interests require freezing actions;
2. where assets have already been made subject to a provisional seizure order within the framework of international legal assistance proceedings, but (a) the third country is unable to satisfy the requirements for mutual legal assistance due to a structural failure of its judicial system and (b) Switzerland’s interests require freezing action; and
3. where a request for MLA has been received from a third country, but (a) that country is unable to meet basic procedural requirements for such co-operation laid down in Swiss law and (b) Switzerland’s interests require freezing action.

In each three alternative scenarios a set of cumulative criteria have to be met to establish a legal basis for the asset freeze. The criteria reflect the fact that the process is not designed to be a substitute or alternative to MLA proceedings, but rather to complement that primary tool in cases where weaknesses in the originating state’s domestic system prevent it from complying with the formal requirements of an MLA.

Section 2 also provides the procedure of adopting the lists of persons targeted by the freezes, the duration of measures, the obligation on persons and entities subject to Swiss jurisdiction to report of assets frozen, administration of such assets, the basis of which national competent authorities may authorise exceptions to the freezing measures, and “amicable settlement” for the restitution of assets. Section 3 provides for measures Swiss authorities may take in order to facilitate the restitution of the funds to the originating State, including through technical assistance and information sharing.

Section 4 provides for the conditions of confiscating assets that have been frozen, including when assets may be presumed to have been of illicit origin, and for protection of the rights of third parties. Section 5 lays down the procedure for the restitution of the assets frozen and confiscated to the originating State. Section 6 provides for the procedural rights of those that have been targeted by freezing measures.

Sections 7 covers aspects related to information exchange within the Swiss Government, data processing, and reporting to Parliament. Section 8 lays down penalties for violations of the Act, including the asset freeze and reporting obligations, as well as certain jurisdictional and procedural aspects related to resulting judicial proceedings. Finally, Section 9 contains provisions related to the entry into force, transitional periods, and other similar aspects of the law itself.

The targets of asset freezes are established through ordinances, adopted in relation to specific third countries in situations that satisfy one of the three criteria listed the Foreign Illicit Assets Act. At the time of writing, Switzerland maintains two ordinances based on the Foreign Illicit Assets Act: the Ordinance blocking assets in the context of Tunisia (Ordinance 196.127.58) and the Ordinance blocking assets in the context of Ukraine (Ordinance 196.127.67). A former ordinance adopted in relation to the situation in Egypt (Ordinance 946.231.132.1) has been revoked.##Federal Department of Foreign Affairs of Switzerland 2018## The ordinances are annexed with lists of persons targeted by the asset freeze.

#### Case Law and Analysis

In Switzerland, the Federal Administrative Court has been invited to rule on the three misappropriation ordinances on a handful of occasions. Unsurprisingly, the cases brought by persons targeted by asset freezes have rested on similar arguments as in the EU case law – in particular, the infringement of the right to property and violation of the principle of proportionality.##See, for instance, Case B-4797/2012, X v DDIP, 5 December 2013, para 2## The Court in Switzerland has accepted that the freezing of assets does indeed infringe the right to property, but noted, much like its EU counterpart, that such rights may be restricted under certain conditions: (i) the restriction must be based on law; (ii) it must be justified by public interest or the protection of rights of others; (iii) and it must be proportional, in other words, limited to what is necessary and adequate to obtain the justified interest pursued.##Ibid, para 3.##

The Court has also arrived at similar conclusions as the one in the EU. The interest being pursued by the measures was a legitimate interest protected by the Constitution, the Court determined, in particular protecting the financial system and reputation of Switzerland as well as furthering sustainable development and the fight against impunity, in particular where the targeted person is unquestionably closely associated with the regime of the third country.##Ibid, para 5.1—5.3. The judgment does not identify the person in question.## Further, the Court ruled that it is also necessary for that aim to adopt an all-encompassing asset freeze (rather than for example identifying specific assets that have been misappropriated), since assets could otherwise be moved beyond Switzerland’s reach before the third country authorities had time to conclude their investigations.##Ibid, para 7.2. —7.3.3.## Consequently, a measure such as the asset freeze in the context of Egypt on persons closely associated with the regime satisfied the constitutional principle of proportionality.##Ibid, para 7.7.##

The Court has further ruled that a measure against any individual has to strictly satisfy the four cumulative conditions laid down in Article 3(1)(2) of the FIAA, i.e. that (a) the Government or its members have, or are about to, lose power, (b) there is a high level of corruption in the country, (c) that it appears likely that the assets have been acquired through corruption, criminal mismanagement, or other felonies, and (d) that the safeguarding of Swiss interests require the freeze.##Case B-2682, A. Ltd v. FDFA, 7 April 2017, para 3.2.##

Of these, points (a), (b) and (d) are concerned with the gravity of the overall circumstances in the third country and their impact on Switzerland. In a case relating to the context of Ukraine, the Court reaffirmed its position that Switzerland’s interests are inherently jeopardised should it permit assets misappropriated from third countries to flow through its financial system. It also accepted on the basis of publicly available information, such as NGO reports, that corruption in Ukraine was widely spread, and that the President had lost power – accepting, therefore, that points (a), (b) and (d) were satisfied and implicitly accepting that the situation in Ukraine, in general, was such that the imposition of asset freezes on the basis of Foreign Illicit Assets Act could be justified.##Ibid, para 3.2.1.##

However, it would additionally have to be established, the Court stated, the assets frozen were likely to have been obtained through misappropriation or similar illicit means. Noting that the law was silent on the level of probability that should be associated with this criterion, the Court accepted that the threshold should initially be low, in order to protect the effectiveness of the measures. Given that the information provided to the Court by the administration, including a letter from the Ukrainian authorities, indicated that the relevant person appeared to have been engaged in systematic illegal enrichment, the Court ruled that there was a high probability that a given asset had, indeed, been illegally obtained – without actually tracing any specific illegal activity to the specific asset.##Ibid, para 3.2.2.## In other words, starting from a very different place, the Court reached a similar requirement as the EU Court: for an asset freeze against an individual person be justified, there has to be reliable information suggesting that the target has been personally involved in misappropriation or benefited from it.

Article 1 of the Foreign Illicit Assets Act adds one final criterion for an individual asset freeze to be justified, i.e. that the targeted person must be a “foreign politically exposed person” (PEP),##Servettaz 2014## which includes high level politicians and officials from different branches of Government, as well as their close associates.##See also ibid, para 3.2.1.## While EU misappropriation regulations do not explicitly contain any such requirement, it should be noted that under the definition adopted by the EU Court, only “a public official who is directly or indirectly entrusted with the management of funds or assets” can in fact engage in “misappropriation”. Given that the listing criteria under these regulations typically include also “natural or legal persons, entities or bodies associated” with persons suspected of misappropriation,##See, for instance, Article 1 of Council Decision 2014/119/CFSP, as amended.## it appears that the scope of the Swiss and EU measures are very similar.

## Comparing the EU and the Swiss Legal Frameworks

There are important differences that set the two legislative frameworks apart. Firstly, the EU relies on a general type of act designed to address foreign policy issues, while the FIAA is a purpose-made law to deal with misappropriation. Secondly, the Swiss FIIA explicitly lays down cumulative criteria that have to be met before asset freezes may be adopted. By contrast, the adoption EU sanctions measures is restricted only by the more general requirements developed in case law, i.e. that the measures seek to advance an important general interest of the EU, are proportional, and satisfy certain basic procedural requirements. Thirdly, and most importantly, Swiss legislation explicitly provides a legal basis not only for freezing, but also for confiscation and restitution, thereby offering a more mature basis for the recovery process as a whole. It addresses the various stages necessary in the recovery of assets to the requesting state.##Lohaus forthcoming## Within the EU misappropriation sanctions framework, by contrast, regulations speak exclusively to the freezing of assets identified as being owned, held, or controlled by targeted individuals. The exceptions and authorisations related to the release of frozen funds do not provide a basis for confiscation and restitution of assets to the authorities in the third state. This is bound to cause difficulties in the later stages of the recovery process.

The Swiss and EU legislative frameworks also display some similarities. In terms of enabling the freeze of assets belonging to persons suspected of misappropriation or their close associates, the legal frameworks of the EU and Switzerland appear, on the regulatory level, to be largely comparable. Both enable the authorities to impose freezing measures after determining that there is reason to believe that corrupt officials are likely to have engaged in mismanagement of state funds, assuming the circumstances are grave enough to warrant such a robust response. Finally, while the measures in both jurisdictions have rested on documentation provided by prosecutors or other authorities in the third state, neither jurisdiction explicitly provides the sources from which the evidence or information underlying the measures must originate. The EU Council must rely on information originating from the requesting state. The Swiss Federal Council, on the other hand, could presumably rely on the law enforcement and other agencies in the executive branch.

## Evaluating the Effectiveness of Freezes

Having reviewed the overall political and legal framework of EU asset freezes, we now turn to analyse the use of misappropriation sanctions in Tunisia, Egypt and Ukraine to ascertaining their effectiveness. In addition to evaluating the cases with reference to the aims stipulated in relevant EU documents, the present section pays attention to the following set of questions:

- Why were individuals listed and removed from the blacklists?
- Have the asset freezes ultimately facilitated/paved the way for asset recovery?
- What obstacles are preventing asset recovery?

### Tunisia, Egypt, Ukraine

#### Tunisia

Of all three misappropriation regimes, the one imposed against Tunisian targets features the simplest designation criteria, which have remained unaltered since the act was adopted. They read: “All funds and economic resources belonging to, owned, held or controlled by persons responsible for misappropriation of Tunisian State funds, and natural or legal persons or entities associated with them, as listed in the Annex, shall be frozen.”##Council 2011a, art. 1##

Chronologically the first EU sanctions regime addressing misappropriation, the Tunisian case features the longest blacklist, including 48 individuals. The list is characterised by the family connections existing among the designees. This is reflected in the repetition of surnames: The current list features only thirteen family names, scattered among 47 entries. The Tunisian list is the blacklist that has faced the least alteration: Only one entry has been removed since the asset freeze was first enacted.

With a limited number of physical assets recovered as early as by 2013, the Tunisian case has recorded the fastest progress so far. $80m, two airplanes and two boats were identified and then frozen or seized in Switzerland, France, Belgium and Italy. One of the planes, seized in France and owned by Ben Ali’s son in law, was returned to Tunis in July 2011. The other plane in Switzerland and the two yachts in Italy and Spain were also subsequently recovered. While the value of these assets represent only a small portion of what is estimated to have been stolen from Tunisia, their recovery illustrates that property located in foreign jurisdictions can be returned even before the finalization of the legal cases.##Brun 2014##

In April 2013, an even more visible success demonstrated that the consistent and patient efforts of the Tunisian authorities and others were paying off. Tunisia recovered $28.8m hidden in a Lebanese bank account controlled by the Ben Ali’s wife. Further, Switzerland had blocked CHF60 million in the wake of the Arab Spring##Keller 2015## and on the basis of a MLA filed by Tunis, Switzerland repatriated assets to Tunisia in two chunks: in May 2016, CHF 250,000 were transferred, and €3.5m followed one year on.##Reuters 2017##

**Table 1** Summary of CFSP designations for the misappropriation of state assets in Tunisia

<dl>
  <dt>Total number of designees</dt>
  <dd>48</dd>

  <dt>Individuals targeted in 1st round</dt>
  <dd>2</dd>

  <dt>Individuals targeted in a 2nd round</dt>
  <dd>46</dd>

  <dt>Individuals listed as of Dec.2018</dt>
  <dd>47</dd>
</dl>

Full table is available [here](https://cifar.eu/wp-content/uploads/2019/03/Table-3-EU_Tunisia.pdf)


As evident from the table above, the Tunisian misappropriation regime displays a pattern of stability. Patterns of litigation are low: Only 15% of Tunisian targets contested their designations in court.##Boogaerts 2018##

#### Egypt

Compared to the Tunisian sanctions regime, the text of the freeze imposed against Egyptian targets features two significant additions. The designation criteria, which have remained unaltered since the act was adopted, read as follows: “All funds and economic resources belonging to, owned, held or controlled by persons having been identified as responsible for misappropriation of Egyptian State funds, and natural or legal persons, entities or bodies associated with them, as listed in the Annex, shall be frozen”##Council 2011b, art. 1. Author’s emphasis.## (author’s emphasis). The formulation broadens the circle of potential designees to individuals “identified as responsible”, and explicitly extends the coverage to entities and bodies associated with blacklisted individuals.

The Egyptian blacklist is the shortest in our sample, featuring only 19 entries initially, and 9 at the time of publication. Similar to the Tunisian list, it displays a pattern of continuity along subsequent renewals. Around 55% of Egyptian targets challenged their designations in court.##Boogaerts 2018## The table below helps the visualisation of the designations under the CFSP misappropriation sanctions regime.

**Table 2** Summary of CFSP designations for the misappropriation of state assets in Egypt

<dl>
  <dt>Total number of designees</dt>
  <dd>19</dd>

  <dt>Individuals targeted in 1st round</dt>
  <dd>19</dd>

  <dt>Individuals targeted in a 2nd round</dt>
  <dd>0</dd>

  <dt>Individuals listed as of Dec.2018</dt>
  <dd>9</dd>
</dl>

Full table is available [here](https://cifar.eu/wp-content/uploads/2019/03/Table-6-CH_Egypt.pdf)


In 2012, Spain froze a number of assets belonging to businessman Hussein Salem, a dual citizen of Egypt and Spain. This included € 28m in cash and financial investments, and seized a number of luxury properties across the country, including two houses in a Madrid suburb with a combined value of around € 7m, seven properties in southern Spain worth around € 3m, and five luxury cars.##Govan 2012##

The UK also froze Egyptian assets whose value is estimated to be more than £90m.##Tovrov 2012, Dale 2013## However, its action was tarnished by revelations that the assets of some regime figures convicted of embezzling money from Egypt remained untouched by British authorities. Assets linked to Mubarak’s inner circle that had not been frozen 18 months after the adoption of EU sanctions included luxury houses and companies registered in central London. One close associate of Mubarak was even able to set up a UK-based business despite his inclusion in a British Treasury sanctions list of Egyptians linked to misappropriated assets and subject to an asset-freeze. Such revelations led Egyptian authorities to pursue a lawsuit against the UK Treasury for a slow progress in asset recovery efforts.##Shenker 2012##

Most funds misappropriated by the Mubarak clan were located in Swiss banks##Daily News Egypt 2018## and Switzerland froze about CHF 700m in the wake of his overthrow.##Häuptli 2018, Swissinfo 2018## In December 2016, Switzerland dropped the listing of six designees from Mubarak’s entourage and unfroze their assets, totalling about CHF 180m, which were restored to the designees. The dropping of designations and the unfreezing ensued due to a lack of co-operation between prosecutors in Egypt and Switzerland.##Egypt Independent 2017## The breakdown of co-operation was precipitated after the Swiss Attorney-General insisted that Egyptian courts had to prove the funds stashed in Swiss banks had been obtained illegally in order to move forward with its restitution. In August 2017, Swiss authorities ceased mutual legal efforts over the charges for lack of results.##Daily News Egypt 2018##

This was also linked to the effect of Egypt’s reconciliation law of 2015, which offered listed individuals immunity in exchange for restoring funds to the state. According to the Federal Department of Foreign Affairs of Switzerland: “In Egypt, several acquittals and reconciliation agreements contributed to the decision of the Egyptian judiciary to drop criminal proceedings in the most prominent cases with possible links to assets frozen in Switzerland. For this reason and in the absence of tangible results at the end of August 2017, the Swiss judicial authorities closed the mutual legal assistance procedures on cases with potential links to assets frozen in Switzerland. Therefore, the freeze on the Egyptian assets on the basis of the FIAA has no further purpose as defined by law and jurisprudence”.##Federal Department of Foreign Affairs 2018## The freeze was lifted in December 2017.

In 2016, Egypt officially concluded a reconciliation deal with Hussein Salem to drop charges against him in exchange for the giving up EGP 5.3bn, which accounts for 75% of his wealth.##Daily News Egypt 2018## Egypt subsequently called on Switzerland, Spain and Hong Kong to unfreeze his assets.##Staff 2016## However, it appears that the assets were unfrozen and made accessible to Salem instead of repatriated.##Public Eye 2017## In late 2017, following a reconciliation agreement struck between Egyptian authorities and politician and businessman Ahmed Ezz, Switzerland released his assets in Swiss banks, CHF 32m, which were transferred to the Egyptian state. This constituted the first repatriation of misappropriated assets to the Egyptian state by Switzerland ever. After the settlement with Ezz and the de-listing of six individuals, CHF 400m remain frozen, belonging to Mubarak’s sons Alaa and Gamal, as well as to four other individuals from his entourage.##Häuptli 2018##

#### Ukraine

The designation criteria applicable to the Ukrainian blacklist are both broader and more detailed than its Arab Spring predecessors. It is also the only misappropriation regime that has experienced a revision of designation criteria.
The original formulation in the legal act of spring 2014 mirrored the language of the Egyptian freeze, but included a reference to human rights that was absent from previous misappropriation regimes:

“All funds and economic resources belonging to, owned, held or controlled by persons having been identified as responsible for the misappropriation of Ukrainian State funds and persons responsible for human rights violations in Ukraine, and natural or legal persons, entities or bodies associated with them, as listed in the Annex, shall be frozen.” ##Council 2014, art. 1##

This makes the Ukrainian blacklist, uniquely, a human rights sanctions regime concurrently to a misappropriation sanctions regime. This criterion also de- localised the regime, reflecting the intervention in the country by foreign actors. While the embezzlement of state funds can be presumed to have been perpetrated by Ukrainian officials, the perpetration of “human rights violations in Ukraine” admits foreign agency.

With the renewal of the asset freeze that ensued one year after its first adoption, the Council inserted a definition of persons identified as responsible for the misappropriation of Ukrainian state funds, which “include persons subject to investigation by the Ukrainian authorities:
(a) for the misappropriation of Ukrainian public funds or assets, or being an accomplice thereto; or
(b) for the abuse of office as a public office-holder in order to procure an unjustified advantage for him- or herself or for a third party, and thereby causing a loss to Ukrainian public funds or assets, or being an accomplice thereto.”##Council 2015, art. 1. See also Annex 2.##

Despite the fact that the Ukrainian blacklist is chronologically the last one adopted, it displays unusual complexity. Sanctions were adopted in two rounds (March and April 2014), separated by merely five weeks. According to expert Gretta Fenner, “European jurisdictions acted as fast as they ever have”,##Fenner 2016, p.19## presumably thanks to the fact that they closely followed the Arab Spring blueprint.

Individuals were blacklisted at the request of the Office of the Prosecutor General of Ukraine. All designees filed cases in front of the CJEU. Some of them won their cases and got their designations annulled. Sometimes the EU removed entries from the blacklists while the cases were still being considered in the Court, delisting individuals listed on tenuous grounds before the Court issued its ruling, as in the case of Andriy Portnov. In other cases, such as Serhii Kliuiev, Ukraine dropped the case and the EU automatically removed the listing. Finally, the Court has also upheld some designations. In the recent ruling on Andrii Kliuiev, the Court annulled the original designation but upheld the legality of its renewal, which reflects an evolution in which the EU has gradually improved the evidentiary basis for the designations.##Radio Free Europe 2018##

The asset freezes have not yet been successful in facilitating asset recovery. However, they have only been in place for about five years, which is still a relatively short time.

**Table 3** Summary of CFSP designations for the misappropriation of state assets in Ukraine

<dl>
  <dt>Total number of designees</dt>
  <dd>22</dd>

  <dt>Individuals targeted in 1st round</dt>
  <dd>18</dd>

  <dt>Individuals targeted in a 2nd round</dt>
  <dd>4</dd>
  
  <dt>Court challenges</dt>
  <dd>16</dd>

  <dt>Individuals listed as of Dec.2018</dt>
  <dd>15</dd>
</dl>

Full table is available [here](https://cifar.eu/wp-content/uploads/2019/03/Table-1-EU_Ukraine_Updated.pdf)


The European Commission collects information on the amounts frozen,##Council 2011a, 2011b, 2014## but it is not authorised to disclose them. Ukrainian authorities reported freezes totalling $107.2m, €15.9m and CHF135m in Austria, the UK, Latvia, Cyprus, Italy, Liechtenstein, Switzerland and the Netherlands.##State Financial Monitoring Service of Ukraine 2018## As pointed out by Michael Howard, not a single Ukrainian politician or businessman implicated in the Yanukovych era has so far been brought to justice.##Howard 2018## To date, only middle-level public officials have been convicted.##Anti-corruption Action Centre 2017##

Funds belonging to several individuals closely associated with former president Viktor Yanukovich were identified in Latvian banks and frozen. They included Sergiy Kurchenko, one of the first individuals to be named on EU and US blacklists, Serhii Arbuzov, who had $49m frozen in Latvian accounts, and businessmen and politician Yuri Ivanyushenko, who had $32m plus CHF72m. However, neither Kurchenko, Arbuzov nor Ivanyushenko were under investigation in Ukraine over the ownership of funds held in Latvian banks and a series of court decisions led to their unfreezing and seizure by the Latvian state.##LSM 2016## Ivanyushenko, who was investigated in Ukraine over a different embezzlement case, was removed from the EU blacklist after the case against him was discontinued in 2017.##LSM 2017##


The obstacles preventing asset recovery in Ukraine are manifold. Firstly, the funds and their ownership are difficult to trace, and the Prosecutor General’s Office has little experience with financial investigations. However, the most significant problem is reportedly the persistence of political interference in the Office’s work, as well as the disincentives this creates for officials. This makes officials often reluctant to move cases forward for fear of retribution.##The Economist 2014## In the words of Gretta Fenner, Office members investigate “people who are still very powerful and have resources at their disposal to destroy you if they want to...If you are successful in your work, you expose yourself to risks”.##Fenner 2016, p.19## In addition, on the basis of her experience as an advisor to the Ukrainian Office of the Prosecutor General, the same expert points to an initial lack of understanding of the centrality of domestic prosecutions to the success of asset recovery.##Fenner 2016, p.20##

Nevertheless, the blacklists are considered political useful beyond their performance in paving the way for asset recovery. EU members consider the misappropriation sanctions part of a broader package imposed in response to Russian interference in Ukraine. Although formally separate and associated to different objectives, they are linked to the full embargo imposed on Crimea following its annexation by Russia and the sanctions addressing destabilisation of Eastern Ukraine. From this point of view, the freezes form part of a broader response to Russian interference with Ukrainian sovereignty, in which the EU presents a united front resolutely opposed to such actions. The political significance of the measures is of paramount importance to Member States, which remain willing to uphold the freezes as a gesture of solidarity with Ukraine.

Similarly to the EU list, there were two consecutive rounds of listings also in the case of Swiss FIAA freezes; however, the first round preceded the first round of CFSP sanctions, and the second round followed barely three weeks on. The faster pace of adoption of freezes in Switzerland can be explained because, as the EU is a composite actor, it generally takes time for the Council to decide on legislation. In addition, the requirement to translate legislation into all EU official languages further slows down its release.##Boogaerts 2018## Similarities in the selection of designees are observable however, even though the number of entries is higher in the Swiss list: The 20 initial entries of the Swiss list became 29 in the second round, while the EU listed 18 in the first round and added four more entries in the second

**Table 4** Evolution of designations under the FIAA freezes for the misappropriation of state assets in Ukraine

<dl>
  <dt>Total number of designees</dt>
  <dd>29</dd>

  <dt>Individuals targeted in 1st round</dt>
  <dd>20</dd>

  <dt>Individuals targeted in a 2nd round</dt>
  <dd>9</dd>

  <dt>Individuals listed as of Dec.2018</dt>
  <dd>15</dd>
</dl>

Full table is available [here](https://cifar.eu/wp-content/uploads/2019/03/Table-2-CH_Ukraine.pdf)


#### Comparing the three misappropriation regimes

Overall, there have been 35 court cases in the EU courts, out of which 4 are appeal judgements.##See footnote 67.## Interestingly, litigation activity has increased over time, and presents vastly different patterns across countries. The number of court cases is not proportional to the number of designees however: 32% of the total correspond to Tunisia, which is by far the longest list and more than doubles the number of designees of the second longest list, Ukraine. 10% of court cases concern Egypt, while Ukraine accounts for 58% of all court cases. Three out of the four appeals concern Ukraine, while the fourth refers to Egypt.

The outcomes of litigation vary from country to country. Overall, almost half of the General Court cases (48%) ended in dismissals (i.e. rulings in favour of the Council), while 29% were partial annulments and 23% resulted in annulments. Regarding Tunisia, 60% of cases were dismissed, two were annulled and two were partially annulled. By contrast, all Egyptian cases were dismissed. In Ukraine, the results of litigation are almost evenly distributed among the three categories: 33% dismissals, 39% partial annulments and 28% annulments. Including Court of Justice rulings in the calculation would only alter the results for Ukraine, since the only successful appeal (C-530/17) concerns one Ukrainian target: dismissals would make up 28% of the total, while annulments would represent 33%, inverting the positions of these categories before appeal. This makes Ukraine the only targeted country where designees have proved more successful in litigation than the Council. The figures for Ukraine depart from the overall Council-friendly trend observable since 2015, when the Council reportedly started to win twice as many cases than it lost,##Bishop quoted in House of Lords 2017## and deviates from the more favourable pattern witnessed in the Arab Spring cases. They also contradict the expectation that EU freezes should have, over time, become more resistant to legal challenges.

## Effective Anti-corruption Instruments?

The employment of CFSP assets freezes to advance asset recovery has proved unsatisfactory at the EU level and is unlikely to be repeated in the near future. Reluctance to activate this tool is not due to questions over the suitability of the CFSP to address misappropriation, which is less controversial. On the contrary, the CJEU has acknowledged these measures as part of a policy of supporting new authorities, intended to promote economic and political stability in the requesting country and to assist the authorities of that country in their fight against the misappropriation of state funds. This fits the EU external policy of consolidating democracy and the rule of law. The Court has merely set limits on the sort of misappropriation of public funds in third countries that is relevant to an EU freezing. The Court reasoned that a CFSP measure would only be appropriate if misappropriation jeopardises the legal and institutional foundations of the country in question, threatening the rule of law.

Instead, the key difficulty emanates from the vulnerability of designations to court challenges, in particular after the CJEU established that it was not admissible to freeze assets of individuals who were merely under investigation in the requesting state. What is unique to the misappropriation sanctions is that the listings do not originate from EU Member States, but from requesting states that do not always substantiate the requests with sufficient evidence. Therefore, the Council finds itself upholding designations of individuals not yet convicted in their home countries, sometimes lacking sufficient information to justify the freeze. This leaves the Council with few resources to fend off annulments by the Court of Justice, which carry a loss of prestige for the institution. This situation contrasts sharply with sanctions under regular CFSP regimes, where designations are proposed by Member States, and the Council engages in listing and de-listing of entries disconnected from external processes. Because the Council employs CFSP legislation designed to address foreign policy issues which maximises Council’s flexibility, no criteria exist stipulating the conditions under which sanctions can be employed. This leaves the door open for inconsistencies in the application of asset freezes to address grand corruption cases, even when these accompany significant international crises.

This said, the freezes have fulfilled other political objectives. As indicated at the outset, the evaluation of the effectiveness of misappropriation sanctions ought to be conducted with reference to a twofold objective: enabling asset recovery and conveying support to post- revolutionary governments. While the freezes have been barely successful in attaining the goal of asset recovery, given that very few designees have been indicted, the measures have been successful in helping EU Member States forge links with the post-revolutionary leaderships. The new elites report considerable appreciation for the EU’s willingness to keep the assets frozen, which they continue to regard as a gesture of solidarity and support, particularly in Kiev.##Interview with EU Member State representatives (2) and
(4), Brussels, September 2018 and October 2018## Upholding the Ukrainian asset freeze is of special significance to the EU given that the Kiev uprising was largely about approximation to the EU. Unlike the Arab uprisings, which resulted from purely internal processes, the Maidan protest erupted in response to the government’s refusal to sign an Association Agreement with the EU.##Webber 2019## This EU-related origin involved Brussels in a confrontational course with Russia, which is still ongoing. Thus, the initial political imperative that gave rise to the listings remains alive.

### Available Alternatives

#### Modifying the legislative framework

In the face of the unsatisfactory state of affairs, how could existing mechanisms be optimised, or replaced with less problematic options? Several alternatives could be contemplated. One of them consists in replicating the Swiss legislative framework in force since 2016. The comparative strength of the Swiss law is that it addresses also confiscation and restitution, whereas the EU regulations do not. In addition, even if the Council of Ministers chose to collect evidence to back up the listings independently from requesting states, it would be poorly equipped for obtaining it as it relies merely on the capabilities of its Member States. The character of CSFP acts as foreign policy measures precludes their use in addresing situations of misappropriation which are disconnected from international crises, notably revolutionary regime change. Instead, legislation enabling the adoption of EU-wide asset freezes addressing misappropriation could be moved to the framework of Justice and Home Affairs, an EU policy domain with a growing external dimension.##Rees 2013##

Another way in which this could be accomplished is by creating a horizontal sanctions list, defined as sanctions legislation devoted to address breaches in a particular field across constituencies, rather than breaches linked to a specific country.##Portela 2018b## This would not differ substantially from the current approach, given that the operative paragraphs of the three existing regimes are almost identical. This would fit the current trend towards theme-based sanctions lists that follow the model of anti-terrorism lists: Horizontal sanctions regimes to address cybercrime and the use of chemical weapons have already been established.##Portela 2018b## Legislation allowing to list perpetrators of grave human rights breaches has been tabled by the Netherlands under the name of “EU global human rights sanctions regime” and is currently under discussion.##152. Bayer 2018; Jozwiak 2018## In an open letter, ninety non-governmental organisations have recently expressed support for the initiative, claiming that Global Magnitsky-type legislation “will provide the EU with the ability to shine a spotlight on and compel changes of behaviour in some of the world’s worst human rights violators”, and that it “has the potential to deter would-be kleptocrats”.##Human Rights First et al. 2018; Transparency International 2018##

However, the initial Dutch proposal centres on human rights and lacks an explicit anti-corruption component,##Blok 2018## in contrast to the U.S. and Canadian iterations of the Global Magnitsky list. Thus, it remains to be seen whether the EU global human rights sanctions regime could be used for the purpose of fighting grand corruption. It is not believed that sufficient consensus exists among Member States to adopt the anti- corruption element that is integral to the North American lists. This is despite the recognition of a link between grand corruption and the foreign policy challenges faced by the EU. Former Prime Minister of Belgium and current MEP Guy Verhofstadt encourages the EU to “go after the billionaire cronies of the Kremlin who really set policy in Moscow while laundering money in the West”, claiming that the “finances and opulent lifestyles of Kremlin-lined tycoons should be fiercely scrutinised in line with EU anti-money laundering legislation”.##Verhofstadt 2018## In the absence of an anti-corruption dimension in the EU version under discussion, the creation of separate legislation dedicated to listing individuals involved in grand corruption could be envisaged. The European Parliament has expressed support for anti-corruption movements in third countries in various resolutions.##European Parliament 2017a and 2017b##

#### Introducing partial reforms to the current system

The current system could also be made more efficient by inserting conditional deadlines for the renewal of measures, again following the Swiss model. The current CFSP sanctions system foresees the yearly renewal of measures; however, there is no explicit conditional aspect to it. By contrast, Swiss legislation stipulates that the extension of the original listings “is expected to yield tangible progress in pending proceedings”, and that Bern will “decide whether the freezes on these assets will be prolonged on the basis of the progress made in the respective legal proceedings”.##Conseil Federal 2016## The adoption of such conditionality component would provide an unequivocal incentive for requesting states to make progress with their investigations lest the frozen funds be released.

Another option consists in imposing an EU-wide CFSP assets freeze initially, and replacing it at a later stage with national assets freezes in those countries where assets have been identified. An EU-wide freeze becomes redundant once it becomes known in which constituencies the funds are located. If assets are identified in say, four EU Member States, the freeze could be upheld in the concerned countries via national measures. This would allow for the EU freeze to be revoked. Removing the CFSP freeze would eliminate the risk of challenges in the CJEU; instead, national courts would be competent. It would also release those Member States where no misappropriated assets exist from the responsibility of ensuring the substantiation for listings, thereby mitigating their reluctance to effect assets freezes in future.

However, it must be emphasised that these alternatives present serious limitations: Partial reforms – such as the introduction of deadlines for renewal – fail to fully resolve the identified problems, while more dramatic reforms – such as replacing EU with national measures after an initial period, or moving the assets from the CFSP to the realm of Justice and Home Affairs – fundamentally alter the character and finalité of the measures.

Finally, the current system consists of a freeze at EU level, and does not entail any mechanism for asset recovery, which must take place at national level via MLAs. This system resembles the US system, which foresees the freezing of assets under the International Emergency Economic Power Act but has no provisions for confiscation.##Levey 2011## A new EU legislative framework could establish a link between both levels.

## Bibliography

Aljazeera (2018) “Dirty deal traced to three Ukrainian tycoons”, 7 January 2018, available at: [https://www.aljazeera.com/news/2017/12/exclusive-dirty-deal-traced-ukrainian-tycoons-171217131747631.html](https://www.aljazeera.com/news/2017/12/exclusive-dirty-deal-traced-ukrainian-tycoons-171217131747631.html)

Anti-corruption Action Centre (2017) Ukraine’s Experience in Asset Recovery, Kiev: AntAC.

Ashton, Catherine (2012) Speech by European Union High Representative on the EU’s policy on restrictive measures, European Parliament, Brussels, 1 February 2012, available at: http://europa.eu/rapid/press-release_SPEECH-12-64_en.html

Bayer, Lily (2018) “In accountability drive, Dutch seek targeted human rights sanctions”, Politico, 10 December 2018, available at: https://www.politico.eu/article/in-accountability-drive-dutch-seek-targeted-eu-human-rights-sanctions/

Barber, James (1979) “Economic Sanctions as a Policy Instrument”, International Affairs, 55(3): 367-38

Bartels, Lorand (2014) The European Parliament’s Role in Relation to Human Rights in Trade and Investment Agreements, EXPO/B/ DROI/2012-09, Brussels: Directorate-General for External Policies, European Parliament, 2014.

Biersteker, Thomas, Eckert, Sue and Tourinho, Marcos (eds) (2016) UN Targeted Sanctions, Cambridge: Cambridge University Press

Blavoukos, Spyros and Bourantonis, Dimitris (2014) “Do Sanctions Strengthen the International Presence of the EU?”, European Foreign Affairs Review 19(3), pp. 393–410

Blok, Stef (2018) ‘Closing remarks by the Minister of Foreign Affairs at a meeting on the EU Global Human Rights Sanction Regime’, 20 November 2018, The Hague (Netherlands), available at: https://www.government.nl/documents/speeches/2018/11/20/blok-on-eu-global-human-rights-sanction-regime

Boogaerts, Andreas (2018) “Short-term Success, Long-term Failure? Explaining the Signaling Effects of EU Misappropriation Sanctions Following Revolutionary Events in Tunisia, Egypt, and Ukraine”, Journal of International Relations and Development. Online first

Boogaerts, Andreas, Portela, Clara and Drieskens, Edith (2016) “One swallow Does Not Make Spring: A Critical Juncture Perspective on the EU Sanctions in Response to the Arab Spring”, Mediterranean Politics 21(2), pp. 205-225

Boswell, Timothy (2015) Letter to the Minister for Europe, House of Lords, London, 15 September 2015

Brun, Jean Pierre (2014) “Tracking Tunisia's stolen assets: the balance sheet three years on”, 14 January 2014, StAR Initiative, available under: https://star.worldbank.org/content/tracking-tunisias-stolen-assets-balance-sheet-three-year

Bullough, Oliver (2014) Looting Ukraine. How East and West Teamed up to Steal a Country. London: Legatum Institute

Chrisafis, Angelique (2011) „Sarkozy admits France made mistakes over Tunisia“, The Guardian, 24 January 2011, available at: www.theguardian.com/world/2011/jan/24/nicolas-sarkozy-tunisia-protests

Cosgrove, Erica (2005) “Examining Targeted Sanctions. Are Travel Bans Effective?” in P. Wallensteen and C. Staibano (eds) International Sanctions: Between words and wars in the global system, Frank Cass, Abingdon, pp. 207-228

Council of the European Union (2011a) Council Decision 2011/72/CFSP of 31 January 2011 concerning restrictive measures directed against certain persons and entities in view of the situation in Tunisia, OJ L 028 2.2.2011, p. 62

Council of the European Union (2011b) Council Decision 2011/172/CFSP of 21 March 2011 concerning restrictive measures directed against certain persons, entities and bodies in view of the situation in Egypt, OJ L 76, 22.3.2011, pp. 63–67

Council of the European Union (2012) “Egypt and Tunisia: Council facilitates asset recovery”, Doc. No. 16078/12, Press 469, Brussels, 26 November 2012

Council of the European Union (2014) Council Decision 2014/119/CFSP of 5 March 2014 concerning restrictive measures directed against certain persons, entities and bodies in view of the situation in Ukraine, OJ L 66, 6.3.2014, pp. 26–30

Council of the European Union (2015) Council Decision (CFSP) 2015/143 of 29 January 2015 amending Decision 2014/119/CFSP concerning restrictive measures directed against certain persons, entities and bodies in view of the situation in Ukraine, OJ L 24, 30.1.2015, p. 16

Court of Justice of the European Union (2008) Joined Cases C-402/05 P and C-415/05 P, Yassin Abdullah Kadi and Al Barakaat International Foundation v. Council of the European Union and Commission of the European Communities, Judgment of the Court (Grand Chamber) of 3 September 2008, available online under: https://eur-lex.europa.eu/legal-content/EN/TXT/?uri=CELEX:62005CJ0402

Dale, Tom (2013) “UK delegation assures return of Mubarak assets, denies inaction”, Egypt Independent, 15 January 2013, available at: https://ww.egyptindependent.com/uk-delegation-assures-return-mubarak-assets-denies-inaction/

Daily News Egypt (2018) “The years-long tale of going after Mubarak wealth”, Daily News Egypt 28 November 2018, available at: https://dailynewsegypt.com/2018/11/25/the-years-long-tale-of-going-after-mubarak-wealth/

Duncan, Alan (2017) Letter to the Chair of the EU Select Committee, House of Lords, London, 10 February 2017

Egypt Independent (2017) “Switzerland lifts freeze on ousted Mubarak’s financial assets”, Egypt Independent, 21 December 2017, available at: https://ww.egyptindependent.com/switzerland-lifts-freeze-ousted-mubaraks-financial-assets/

Egypt Today (2018) “Last corruption case against Ahmed Ezz dropped per reconciliation”, Egypt Today, 14 April 2018, available at: http://www.egypttoday.com/Article/1/47785/Last-corruption-case-against-Ahmed-Ezz-dropped-per- reconciliation

European Parliament (2017a) Resolution of 6 April 2017 on Russia, the arrest of Alexei Navalny and other protestors (2017/2646(RSP)), available at: http://www.europarl.europa.eu/sides/getDoc.do?type=TA&language=EN&reference=P8-TA- 2017-0125

European Parliament (2017b) Resolution of 13 September 2017 on corruption and human rights in third countries (2017/2028(INI)), available at: http://www.europarl.europa.eu/sides/getDoc.do?pubRef=%2f%2fEP%2f%2fTEXT%2bTA%2bP8-TA-2017-0346%2b0%2bDOC%2bXML%2bV0%2f%2fEN&language=EN

European Parliament (2017c) Exchange of views with Idriss Jazairy, UN Special Rapporteur on the negative impact of unilateral coercive measures on the enjoyment of Human Rights, the European Parliament Subcommittee on Human Rights, Brussels, 21 June 2017

European Union (2015) Directive (EU) 2015/849 of the European Parliament and of the Council of 20 May 2015 on the prevention of the use of the financial system for the purposes of money laundering or terrorist financing, amending Regulation (EU) No 648/2012 of the European Parliament and of the Council, and repealing Directive 2005/60/EC of the European Parliament and of the Council and Commission Directive 2006/70/EC

European Union (2014) Council Decision 2014/119/CFSP of 5 March 2014 concerning restrictive measures directed against certain persons, entities and bodies in view of the situation in Ukraine, available under: http://data.europa.eu/eli/dec/2014/119(1)/2017-03-05

Federal Department of Foreign Affairs (2018) “Freezing of assets”, available at https://www.eda.admin.ch/eda/en/home/foreign-policy/financial-centre-economy/illicit-assets-pep/freeze-assets.html (accessed 10 October 2018)

Fenner, Gretta (2016) “The really critical condition in investigating financial crimes is no political interference”, Ukrainian Weekly#5 (99)

Giumelli, Francesco (2018) “Quando sono utili le sanzioni internazionali? L'Italia, la Russia e l'Unione Europea”, Approfondimenti 142, Istituto di Affari Internazionali: Roma

Govan, Fiona (2012) “£23 million of Hosni Mubarak assets seized in Spain”, The Guardian, 13 December 2012, available at: https://www.telegraph.co.uk/news/worldnews/europe/spain/9743470/23-million-of-Hosni-Mubarak-assets-seized-in-Spain.html

Happold, Matthias (2016) “Targeted Sanctions and Human Rights”, in M. Happold and P. Eden (eds.) Economic Sanctions and International Law, Oxford: Hart, pp. 87-111

Hellquist, Elin (2016) “Either with Us or against Us? Third-country Alignment with EU Sanctions against Russia/Ukraine”, Cambridge Review of International Affairs 29(3), pp. 997-1021

House of Lords (2017) The Legality of EU Sanctions, European Union Committee, 11th Report of Session 2016–17. UK Parliament: London

Howard, Michael (2018) “The Never Ending Story: The Yanukovych Asset Recovery”, CIFAR, 17 October 2018

Human Rights First et al. (2018) Open Letter from Non-Governmental Organizations in Support of a Targeted, Global EU Human Rights Sanctions Regime, 5 December 2018, available at: https://www.humanrightsfirst.org/sites/default/files/European-Union-Sanctions-Letter.pdf

Jozwiak, Rikard (2018) “Netherlands proposes new EU Human Rights sanctions regime”, Radio Free Europe, 19 November 2018, available at: https://www.rferl.org/a/netherlands-propose-new-eu-human-rights-sanctions-regime/29609488.html

Keller, Benjamin (2015) “The complex case of Tunisia’s blocked funds”, Swissinfo, 06 April 2015, available at: https://www.swissinfo.ch/eng/politics/returning-stolen-assets_the-complex-case-of-tunisia-s-blocked-funds/41360476

Kettis, Andreas and Hakala, Pekka (2013) “Recovering Tunisian and Egyptian assets: Legal complexity challenges states in need”, DG EXPO/B/PolDep/Note/2013_92, available at: http://www.europarl.europa.eu/meetdocs/2009_2014/documents/dmas/dv/20130318_assets_recovery_/20130318_assets_recovery_en.pdf

Moret, Erica, et al. (2016) “The New Deterrent: International Sanctions against Russia”, Graduate Institute: Geneva

Häuptli, Lukas (2018) „Schweiz tritt 32 Millionen Franken an Ägypten ab“, NZZ am Sonntag, 24 March 2018, available at: https://nzzas.nzz.ch/schweiz/schweiz-tritt-32-millionen-an-aegypten-ab-ld.1369176?reduced=true

Lester, Maya (2016) Written evidence to the UK House of Lords Inquiry on “The legality of EU sanctions”, 14 October 2016, available at: http://data.parliament.uk/writtenevidence/committeeevidence.svc/evidencedocument/eu-justice-subcommittee/the-legality-of-the-eu-sanctions-process/written/41026.html

Lidington, David (2016) Letter to the Chair of the EU Select Committee, House of Lords, London, 2016

Lidington, David (2015a) Letter to the Chair of the EU Select Committee, House of Lords, London, 15 July 2015

Lidington, David (2015b) Letter to the Chair of the EU Select Committee, House of Lords, London, 18 December 2015

Lohaus, Mathis (forthcoming) Asset Recovery and Illicit Financial Flows from a Developmental Perspective, U4 Issue, Bergen: Anti-corruption Resource Centre

Lough, John and Dubrovskiy, Vladimir (2018) Are Ukraine’s Anti-corruption Reforms Working?, London: Chatham House

Louis, Justine (2017) “Egypt: The Failed Transition” in A. Mungiu-Pippidi and J. Warkotsch (eds) Beyond the Panama Papers: The Performance of EU Good Governance Promotion, Barbara Budrich, Opladen, pp. 89-99

LSM (Public Broadcasting of Latvia) (2017) “Latvia may keep further €25m of stolen Ukrainian funds”, 27 November 2017, available at: https://eng.lsm.lv/article/society/crime/latvia-may-keep-further-25m-of-stolen-ukrainian-funds.a258829/

LSM (Public Broadcasting of Latvia) (2016) “Latvia keeps €50m believed stolen from Ukraine”, 12 September 2016, available at: https://eng.lsm.lv/article/economy/economy/latvia-keeps-50m-believed-stolen-from-ukraine.a200426/

Nephew, Richard (2018) The Art of Sanctions: A View from the Field. Columbia University Press, New York

Portela, Clara (2009) “National Implementation of United Nations Security Council Sanctions: Towards fragmentation”, International Journal (Canada) 65(1), pp. 13-30

Portela, Clara (2010) European Union Sanctions and Foreign Policy, Routledge: London

Portela, Clara (2012) “EU Sanctions as a Foreign Policy Tool: Do They Work?” in SB. Gareis, G. Hauser and F. Kernic (eds) Europe as a Global Actor, Budrich: Opladen/Farmington Hills

Portela, Clara (2017) “Sanctions and the European Neighbourhood Policy” in T. Demmelhuber, A. Marchetti, T. Schumacher (eds) The Routledge Handbook on the European Neighbourhood Policy, London: Routledge

Portela, Clara (2018a) “Sanctions against Individuals for Grave Human Rights Violations”, Briefing Paper, European Parliament, General Directorate for External Policy, Brussels

Portela, Clara (2018b) “The Power of Blacklists: The European Parliament’s proposed Magnitsky Act”, London: European Council on Foreign Relations, available at: https://www.ecfr.eu/article/commentary_power_of_blacklist_european_parliament_magnitsky_act

Public Eye (2017) Failed Recovery, Lausanne: Public Eye, available under: https://www.publiceye.ch/fileadmin/doc/Finanzplatz/2017_PublicEye_Failed_Recovery_Report.pdf

Pursiainen, Aleksi (2017) “Targeted Sanctions and Fundamental Rights”, Solidplan Consulting: Helsinki

Radio Free Europe (2018) “EU Court clears ex-Yanukovych aide of past sanctions”, available at: https://www.rferl.org/a/eu-court-clears-ex-yanukovych-aide-past-sanctions-upholds-current-measures/29357641.html

Rees, Wyn (2013) “The External Face of Internal Security”, in C. Hill and M. Smith (eds) International Relations and the European Union, Oxford University Press: Oxford, pp. 226-245

Reuters (2017) “Swiss return funds from Ben Ali relative to Tunisia”, 26 May, available at: https://www.reuters.com/article/us-tunisia-swiss-assets/swiss-return-funds-from-ben-ali-relative-to-tunisia-idUSKBN18M1RN

Servettaz, Elena (2014) “A Sanctions Primer. What Happens to the Targeted?”, World Affairs 177(2), pp. 82-89

Shagina, Maria (2018) “Ukraine’s inconsistent sanctions policy towards Russia”, New Eastern Europe, available under: http://neweasterneurope.eu/2018/10/18/ukraines-inconsistent-sanctions-policy-towards-russia/

Shenker, Jack (2012) “Scandal of Mubarak regime millions in UK”, The Guardian, 2 September 2012, available at: https://www.theguardian.com/world/2012/sep/02/scandal-mubarak-regime-millions-assets-uk

Staff, Toi (2016) “Egypt asks foreign countries to unfreeze Mubarak-linked tycoon’s asset”, Times of Israel 24 August 2016, available under: https://www.timesofisrael.com/egypt-asks-foreign-countries-to-unfreeze-tycoons-assets/

State Financial Monitoring Service of Ukraine (2015) Information dated 09 December 2015, available at: http://www.sdfm.gov.ua/news.php?news_id=2927&lang=en

Stepien, Beata, Pospieszna, Paulina and Skrzypczynska, Joanna (2016) “Challenges in Evaluating Impact of Sanctions”, Przegląd Politologiczny (Political Science Review) 4, pp. 155-167

Swissinfo (2018) “Switzerland repatriates chunk of frozen Mubarak funds”, Swissinfo, 25 March 2018, available at: https://www.swissinfo.ch/eng/politics/chf32m-thaw_switzerland-repatriates-chunk-of-frozen-mubarak-funds/43999128

Taylor, Brendan (2009) Sanctions as Grand Strategy. IISS: London

Timmermans, Frans and Mogherini, Federica (2017), Letter to the Chair of the EU Select Committee, House of Lords, Brussels, 8 June 2017

The Economist (2014) “Ukraine’s stolen assets. A long, hard slog”, 5 March 2014

Tovrov, Daniel (2012) “Egypt sues UK over frozen Mubarak assets”, International Business Times, 16 April 2012, available under: https://www.ibtimes.com/egypt-sues-uk-over-frozen-mubarak-assets-437994

Transparency International (2016) “Lost Billions: Recovering Public Money in Egypt, Libya, Tunisia and Yemen”. Study completed by JMW Consulting. Berlin: TI

Transparency International (2018) “EU sanctions for corruption – the flight back starts here”, available at: http://transparency.eu/eu-sanctions-for-corruption-the-fight-back-starts-here/

Verhofstadt, Guy (2018) “How Europe can push back against Putin’s aggression”, EU Observer 30 November 2018

Wallensteen, Peter and Grusell, Helena (2012) “Targeting the Right Targets? The UN Use of Individual Sanctions”, Global Governance 18(2), pp. 207-230

Warkotsch, Jana (2017) “Tunisia: Great Expectations” in A. Mungiu-Pippidi and J. Warkotsch (eds) Beyond the Panama Papers: The Performance of EU Good Governance Promotion, Barbara Budrich, Opladen, pp. 104-116

Webber, Douglas (2019) European Disintegration? The Politics of Crisis in the European Union, London: Springer

## Annexes

### Annex 1: List of Interviews 
- Interview with Member State representative (1), Brussels, March 2017 
- Interview with Member State representative (2), Brussels, September 2018 
- Interview with Member State representative (3), Brussels, October 2018 
- Interview with Member State representative (4), Brussels, October 2018 
- Interview with expert, Brussels, October 2018
- E-mail communication with expert, remote, October 2018
- Interview with Member State representative (5), European capital, November 2018 
- Interview with EU officials, Brussels, November 2018
All interviewees are guaranteed full anonymity.

 #### All Annexes are available in the PDF version of the report [here](https://cifar.eu/wp-content/uploads/2019/03/CiFAR_Sanctioning-kleptocrats.pdf)
 #### To see all tables analysing the evolution of asset freezes in Egypt, Tunisia and Ukraine, click [here](https://cifar.eu/wp-content/uploads/2019/03/Tables-evolution-of-asset-freezes.pdf)
 
