---
title: Guidelines for the private sector
---
As well as assisting the countries of origin, businesses have a role and responsibilities to both
report and to act when there is a suspicion that they are dealing with people subject to
sanctions.

All EU nationals and legal entities established under EU law must comply with the EU sanctions that are in force, irrespective of where their activities take place. Failure to comply with sanctions might result in a criminal prosecution or a monetary penalty.

Banks and financial institutions, as well as real estate agents and retailers in the luxury goods sector are all particularly at risk of dealing with persons subject to sanctions. Undertaking due diligence obligations and ensuring your company does not deal with someone subject to sanctions is therefore key.

There is a number of processes that your company or institution can adopt in order to minimize the risk of non-compliance with sanctions. Depending on your business model and risk factors, these may include:

-	Establishing and updating a sanctions policy
-	Implementing a monitoring system to ensure continual compliance with sanctions
-	Raising awareness of sanctions-compliance amongst your staff and within your supply chain
-	Identifying and establishing a communication channel with your national competent authority 

As soon as practicable, EU regulations require natural and legal persons, entities and bodies to provide their national competent authorities with information that would facilitate compliance with the regulations. In case you might be dealing with a designated entity or you are unsure of your reporting obligations, you should seek independent legal advice or contact the relevant national competent authority from the list below.

## Contacts of National Competent Authorities

- [Austria](https://www.bmeia.gv.at/en/european-foreign-policy/foreign-policy/europe/eu-sanctions-national-authorities/)
- [Belgium](https://diplomatie.belgium.be/en/policy/policy_areas/peace_and_security/sanctions)
- [Bulgaria](http://www.mfa.bg/en/pages/135/index.html)
- [Croatia](http://www.mvep.hr/sankcije)
- [Cyprus](http://www.mfa.gov.cy/mfa/mfa2016.nsf/mfa35_en/mfa35_en?OpenDocument)
- [Czech Republic](http://www.financnianalytickyurad.cz/mezinarodni-sankce.html)
- [Denmark](http://um.dk/da/Udenrigspolitik/folkeretten/sanktioner/)
- [Estonia](http://vm.ee/et/estonian-competent-authorities-implementation-eu-restrictive-measures)
- [Finland](http://formin.finland.fi/Public/default.aspx?nodeid=49565&contentlan=1&culture=fi-FI)
- [France](http://www.diplomatie.gouv.fr/fr/autorites-sanctions/)
- [Germany](http://www.bmwi.de/Redaktion/DE/Artikel/Aussenwirtschaft/embargos-aussenwirtschaftsrecht.html)
- [Greece](http://www.mfa.gr/en/foreign-policy/global-issues/international-sanctions.html)
- [Hungary](http://www.kormany.hu/download/9/2a/f0000/EU%20szankci%C3%B3s%20t%C3%A1j%C3%A9koztat%C3%B3_20170214_final.pdf)
- [Ireland](https://www.dfa.ie/home/index.aspx?id=28519)
- [Italy](https://www.esteri.it/mae/it/politica_estera/politica_europea/misure_deroghe)
- [Latvia](http://www.mfa.gov.lv/en/policy/security-policy/links-addresses)
- [Lithuania](http://www.urm.lt/en/sanctions)
- [Luxembourg](https://maee.gouvernement.lu/fr/directions-du-ministere/affaires-europeennes/mesures-restrictives.html)
- [Malta](https://foreignaffairs.gov.mt/en/Government/SMB/Pages/Sanctions-Monitoring-Board.aspx)
- [Netherlands](https://www.rijksoverheid.nl/onderwerpen/internationale-sancties)
- [Poland](http://www.msz.gov.pl/en/foreign_policy/international_law/international_sanctions/)
- [Portugal](http://www.portugal.gov.pt/pt/ministerios/mne/quero-saber-mais/sobre-o-ministerio/medidas-restritivas/medidas-restritivas.aspx)
- [Romania](http://www.mae.ro/node/1548)
- [Slovakia](https://www.mzv.sk/europske_zalezitosti/europske_politiky-sankcie_eu)
- [Slovenia](http://www.mzz.gov.si/si/zunanja_politika_in_mednarodno_pravo/mednarodna_varnost/omejevalni_ukrepi/)
- [Spain](http://www.exteriores.gob.es/Portal/en/PoliticaExteriorCooperacion/GlobalizacionOportunidadesRiesgos/Paginas/SancionesInternacionales.aspx)
- [Sweden](http://www.ud.se/sanktioner)
- [United Kingdom](https://www.gov.uk/guidance/sanctions-embargoes-and-restrictions)

## Contacts of the European Commission

- [European Commission, Service for Foreign Policy Instruments (FPI)](https://ec.europa.eu/fpi/what-we-do/sanctions_en)
- [European External Action Service, Sanctions Division](https://eeas.europa.eu/generic-warning-system-taxonomy/404_en/423/Sanctions%20policy) 

## Useful links
- Service for Foreign Policy Instruments (FPI) - [Sanctions website](https://ec.europa.eu/fpi/what-we-do/sanctions_en)
- [Frequently Asked Questions on EU restrictive measures](http://eeas.europa.eu/archives/docs/cfsp/sanctions/docs/frequently_asked_questions_en.pdf)
- [A firm’s guide to preventing financial crime](https://www.handbook.fca.org.uk/handbook/document/FC1_FCA_20150427.pdf)


#### Note
*EU misappropriation sanctions are only one type of sanctions that businesses need to be aware of when performing due diligence investigation. The information on this website does not provide a comprehensive list of all sanctions nor can it replace legal advice. This website should be used as a resource to inform businesses about misappropriation sanctions and to aid the identification of designated persons.* 
