# import unittest
# import numpy as np

# from gptcache.manager.vector_data import VectorBase
# from gptcache.manager.vector_data.base import VectorData


# class TestWeaviateDB(unittest.TestCase):
#     def test_normal(self):
#         size = 1000
#         dim = 512
#         top_k = 10
#         class_name = "Vectorcache"

#         db = VectorBase(
#             "weaviate",
#             class_name=class_name,
#             top_k=top_k
#         )

#         created_class_name = db._create_class()
#         self.assertEqual(class_name, created_class_name)
#         data = np.random.randn(size, dim).astype(np.float32)
#         db.mul_add([VectorData(id=i, data=v) for v, i in zip(data, range(size))])
#         self.assertEqual(len(db.search(data[0])), top_k)
#         db.mul_add([VectorData(id=size, data=data[0])])
#         ret = db.search(data[0])
#         self.assertIn(ret[0][1], [0, size])
#         db.delete([0, 1, 2, 3, 4, 5, size])
#         ret = db.search(data[0])
#         self.assertNotIn(ret[0][1], [0, size])
#         db.rebuild()
#         db.update_embeddings(6, data[7])
#         emb = db.get_embeddings(6)
#         self.assertEqual(emb.tolist(), data[7].tolist())
#         emb = db.get_embeddings(0)
#         self.assertIsNone(emb)
#         db.close()

#         custom_class_name = "Customcache"
#         class_schema = {
#             "class": custom_class_name,
#             "description": "LLM response cache",
#             "properties": [
#                 {
#                     "name": "data_id",
#                     "dataType": ["int"],
#                     "description": "The data-id generated by GPTCache for vectors.",
#                 }
#             ],
#             "vectorIndexConfig": {"distance": "cosine"},
#         }

#         db = VectorBase(
#             "weaviate",
#             class_schema=class_schema,
#             top_k=top_k
#         )
#         created_class_name = db._create_class()
#         self.assertEqual(custom_class_name, created_class_name)
#         db.close()
