# 代码审核的速度

## 目录
*   [为什么应该尽快审核代码](#why)
*   [代码审核应该多迅速？](#fast)
*   [速度 vs. 中断](#interruption)
*   [快速响应](#responses)
*   [跨时区的审核](#tz)
*   [LGTM的评论](#lgtm-with-comments)
*   [大 CL](#large)
*   [代码审核在不断改善中](#time)
*   [紧急情况](#emergencies)

## 为什么应该尽快审核代码 {#why}

**在Google，我们优化团队开发产品的速度**，而不是优化单个开发人员写代码的速度。单个开发人员的开发速度固然重要，但远没有整个团队的开发速度 _重要_ 。

当代码审核者很慢的时候，会发生以下几件事：

*   **作为整体，团队的进度降低了。** 是的，单个审核者没有对代码审核及时响应，而是在完成其他的工作。如果每个人都这样的话，团队的新功能开发或缺陷修复就会延期，累积下来，延期可能是几天、几周，甚至几个月，团队中每个人都在等待别人审核（或再次审核）自己的代码。
    
*   **开发者开始抗议代码审核流程。** 如果审核者几天反馈一次，每次都要求 CL 重大改变，这样开发者就会变得很沮丧，很困惑。通常，这表达为对审核者太过“严格”的抱怨。如果审核者 _同样_ 要求大量的修改（的确有利于改善代码质量的修改），并且每当开发者更新后，审核者 _迅速_ 响应，抱怨就会消失。 **大多数关于代码审核流程的抱怨实际上可以通过让流程变得更快来解决。**
    
*   **影响代码质量。** 当审核很慢时，会增加开发者的压力，他会认为自己的代码不尽人意。迟缓的审核也会阻碍代码清理、重构，阻碍已有 CL 的进一步改善。

## 代码审核应该多迅速？ {#fast}

如果你现在没有进行一项需要集中精力的任务，**你应该在收到审核邀请时，短时间内就开始代码审核。** 

在收到审核请求时，**一个工作日是审核响应的最长期限** ，即第二天早上做的第一件事情。 

遵循这些规则意味着一个典型的 CL 的几轮审核（如果有必要的话）都会在一天内完成。

## 速度 vs. 中断 {#interruption}

当然也有列外。**如果你正在做一项需要集中精力的任务时，例如写代码时，不要打断自己。** 研究显示，在被打断之后，开发者很长时间才能进入打断前的状态。所以，与其在写代码的时候打断自己，不如让另外一位开发者稍候，否则 _成本更高_ 。

什么时候审核呢？在下一个工作断点之后再审核。这个断点可能是你当前的代码已经完成的时候、午饭后、某个会议结束、从公司的餐厅回来，等等。

## 快速响应 {#responses}

当我们谈及代码审核的速度时，我们指的是 _响应时间_ ，而不是审核 CL 整个流程走下来直到提交代码所花费的时间。整个流程也应该快，但 **更重要的是 _个人的快速响应_ ，而不是整个流程快点完成。**

即使整个 _审核_ 流程走下来会花费很多时间，但在整个过程中，审核者都在快速响应，这也会很大程度减轻开发者对 “慢” 代码审核的挫败感。

当收到一个 CL 审核的时候，如果你当时太忙没有时间做完整的审核，你仍然可以快速响应，告知开发者你稍后会做审核（但是当时没时间），他可以让他其他能快速响应的人先审核，或者先[提供一些初步的反馈](navigate.md)。（注意：这并不意味着你可以打断当前的编码工作，还是应该在工作的断点后再审核。）

**有一点很重要，当审核者反馈“LGTM”时，意味着他花了足够的时间审核代码，并且认为代码满足[代码标准](standard.md)。** 然而，每个人还是应该[迅速](#fast)响应。

## 跨时区的审核 {#tz}

当有时差时，尽量在开发者离开办公室之前给他反馈。如果对方已经下班回家，尽量确保在他在第二天早上来公司之前给出反馈。

## LGTM的评论 {#lgtm-with-comments}

为了加快代码审核，有一些确定的场景，你应该给出 LGTM/赞同 的反馈，即使开发者仍有一些未处理的反馈（unresolved comments）。这些场景如下（满足任一场景即可）：

*   审核者相信开发者会对所有未处理的反馈做出合适的响应。
*   未处理的反馈无关紧要，开发者 _没必要_ 处理。

审核者应该阐明他做出的 LGTM 是哪种场景。

LGTM 特别值得考虑，尤其是当开发者与审核者跨时区时，否则开发者又得等一整天时间才能得到“LGTM，赞成”。

## 大 CL {#large}

如果某位开发者提交一份很大的代码审核，你不大确认自己是否有时间审核它，一种典型的响应是让开发者[把一个CL拆分成多个](../developer/small-cls.md)，而不是让审核者一次审核大 CL。这样对审核者比较有用，虽然开发者有些额外的工作要做，这是值得的。

如果一个 CL *不能* 拆分成多个，并且你很难在短时间内审核代码，至少在CL的整体设计上向开发者提出反馈，以便让开发者改进。作为一个审核者，你的目标之一是：尽量不要阻塞开发者，让他能迅速采取下一步行动。当然，前提是不会降低代码质量。

## 代码审核在不断改善中 {#time}

在遵循本文中的建议进行代码审核之后，尽管代码审核很严格，你会发现，在运行一段时间后，整个流程会越来越快。开发者学会了健康的代码需要什么，在发送 CL 之前会尽量保证代码质量，因此需要审核的时间会越来越短。审核者学会了快速响应，不会在审核中增加不必要的延时。

但是， **不要为了想象中的速度提升，在[代码审核标准](standard.md)或质量上妥协**  ——实际上，从长期来，这样做并不会节省时间。

## 紧急情况 {#emergencies}

当然，也会有[紧急情况](../emergencies.md)，要求审核流程尽快完成，此时代码质量也有适当的弹性空间。但是，请先确保它的确属于紧急情况。如果不确认，先查看一下[什么是紧急情况](../emergencies.md#what)，这篇文章详细讲述了哪些情况属于紧急情况，哪些不是。

下一章: [怎样写代码审核的评论](comments.md)
