# 代码评论被拒绝时，应如何处理？

## 目录
*   [谁是对的？](#who_is_right)
*   [烦躁的开发者](#upsetting_developers)
*   [稍后再清理](#later)
*   [与严格相关的常见抱怨](#strictness)
*   [冲突解决](#conflicts)

有时候，面对审核者的评论，开发者可能会拒绝。他们不同意你的建议，或者他们认为你太过于苛刻了。

## 谁是对的? {#who_is_right}

当开发者不同意你的建议时，先考虑他们是否正确。开发者往往更熟悉代码，在某些方面他们对代码有更好的见解。他们的论点是否理由充分？站在代码健康的角度，是否应该如此？如果回答“是”，告诉他们，他们是对的，可以忽略这条评论。

但开发者并非总是对的。此时，代码审核者应该进一步解释为何他相信自己的建议是正确的。一个很好地解释通常包含两部分：对开发人员的回复的解释和进一步说明这么改的必要性。

尤其当审核者相信他们的建议能够有效提升代码质量时，他们应该继续坚持这种修改。即使有证据显示这种代码提升需要一些额外的工作，也值得做。 **提升代码质量往往是聚沙成塔的过程。**

有时候，需要经过好几轮的解释与澄清，你的建议才会被接受。确保自始至终都保持[礼貌](comments.md#courtesy) ，让开发者知道你在 *听* 他说话，只是不 *同意* 他的观点而已。

## 烦躁的开发者 {#upsetting_developers}

有时候，审核者相信，如果自己坚持改进，那么开发者可能会心烦。这种事的确偶有发生，但通常持续时间很短，稍后他们会感谢审核者，正是他的坚持让代码质量得以提升。通常，如果在评论中保持[礼貌](comments.md#courtesy)，开发者根本就不会烦躁，审核者不必担忧。烦躁大多是因为[写评论的方式](comments.md#courtesy)没有把焦点放在代码质量上。

## 稍后再清理 {#later}

一种常见的拒绝原因是：开发者想尽快完成它（这种心理很常见）。他们不想再进行一轮审核，只想快点把 CL 提交到代码库。所以，他们说他们会在稍后的 CL 中再清理代码，这样你应该对 *当前* CL 评论 LGTM了。有些开发者的确是这么做的，他们随后的确创建了一个新的 CL，用于修复当问题。然而，经验告诉我们，从开发者提交了原始 CL 之后，时间过得越久，他们清理代码的可能性越小。除非开发者在当前 CL 之后 *立即* 清理代码，否则以后也不会清理。这并不是说开发者不靠谱，而是因为他们有太多的开发工作要做，迫于其他工作的压力已经忘了清理之前提交的代码这件事。因此，我们建议，最好坚持让开发者 *现在* 就开始清理代码，而不是提交到代码库 *之后* 。 我们应该有种理念， 代码退化的常见原因有几个，“稍后再清理” 便是其中之一。

如果 CL 让代码变得复杂，那么它必须在提交之前清理完毕，除非是[紧急情况](../emergencies.md)。如果 CL 处处是问题却不立即解决，开发者应该给自己发一个清理代码相关的 bug，把它分配给自己，以避免遗忘。除此之外，在代码中加上 TODO 注释和相关的 bug 编号。

## 与严格相关的常见抱怨 {#strictness}

如果以前你在做代码评审时比较宽松，现在突然变得严格起来，有些开发者可能会抱怨。没关系，通过提升审核代码的[速度](speed.md)通常会让抱怨消失。

有时候，让抱怨消失的过程比较漫长，长达数月，但最后，开发者会往往趋于赞同严格审核代码的价值，因为在严格审核的帮助下，他们写出了伟大的代码。一旦大家认识到这种严格带来的价值，甚至最强烈的抗议者可能会变成最强大的拥护者。

## 冲突解决 {#conflicts}

作为审核者，如果你已经遵循本文中提到的所有规则，但仍旧与开发者之间产生了难以解决的冲突，可以参考[代码审核的标准](standard.md) ，以其中提到的规则与理论来指导冲突解决。
