# 代码审核的步骤

## 目录
*   [概述](#summary)
*   [第一步：全面了解 CL](#step_one)
*   [第二步：检查 CL 的主体部分](#step_two)
*   [第三步：以合适的顺序审视 CL 的其他部分](#step_three)

## 概要

到目前为止，你已经知道[在代码审核过程中要看些什么？](looking-for.md)。一个 CL 往往包含多个文件，怎样做会让代码审核变得高效呢？三步就可以做到：

1.  全面了解 CL。这个 CL 是否有意义？它是否包含好的[描述](../developer/cl-descriptions.md)？
2.  综观整个 CL 中最重要的部分。从整体来看，设计是否合理？
3.  以合适的顺序检查CL的其他部分。

## 第一步：全面了解 CL {#step_one}

阅读 [CL 描述](../developer/cl-descriptions.md)，了解CL实现的功能。判断这个修改是否有意义？如果答案是“否”，请立即回复，并解释为什么要取消这个修改。当拒绝的同时，你最好向开发者给出建议，这种情况应该怎么做。

例如，你可能会这么说：“这个 CL 的代码看起来挺不错的，谢谢你！不过，我们正在删除 FooWidget 系统，并用新的系统代替他，目前最好不要修改它（或对它加入新的功能）。建议换种方式，你看重构一下 BarWidget 类，怎么样？”

在上面的例子里，你拒绝了这个 CL ，并提供了一种可选方案。整个过程，你都 *很有礼貌* 。这种礼貌非常重要，这在告诉对方：尽管不同意你的观点，但我很尊重你。

如果这种情况（开发者提交了你认为不应该这么做的 CL）经常出现，那么你应该考虑一下，是不是应该优化团队的开发流程或外部贡献者（针对某些与外部开发人员共同协作的场景）的发布流程，与开发者先进行充分的沟通确保他已经理解开发的内容，再进行开发。最好在开发者开发一大堆工作之前就说“不”，以避免大量不必要的返工。

## 第二步：检查 CL 的主体部分 {#step_two}

找到包含 CL “主体”部分的文件。通常，如果一个文件包含大量的逻辑修改，那么它就是 CL 的主体部分。先审视这些主体部分有助于为其他部分理出上下文。如果 CL 太大，很难找到主体部分的位置，可以征询开发者的建议，你应该先看哪些部分，并建议他[把一个 CL 拆分成多个](../developer/small-cls.md)。

如果发现 CL 中有一些重要的设计问题或设计缺陷，立即给出反馈，即使现在还没来得及审核其他部分。实际上，审核其他部分很有可能是浪费时间。只要这个设计问题足够大，在重新设计时，其他代码很有可能会消失或变得无关紧要了。

为什么要立即对这重要设计问题给出反馈呢？有两个原因：

-   开发者经常在发出 CL 之后就立即基于这个 CL 开始新的工作。如果你发现正在审核的 CL 有重要设计问题，那么他正在做的新 CL 还得返工。我们应该及时指出，避免开发者在基于错误的设计下做了太多工作。
    
-   重要设计错误比小修改花费更多的时间。每个开发者在进行开发工作时都有时间期限；为了在保证代码质量的前提下按时交付，开发者需要**尽快**重新设计 CL。

## 第三步：以合适的顺序审视 CL 的其他部分 {#step_three}

在确认 CL 没有重要设计问题之后，整理出审视文件的顺序，并确保不会遗漏任何文件。通常，在审视了主要文件之后，最简单的方式就是按照代码审核工具呈现出来的顺序遍历每个文件。有时候，先阅读测试代码更有帮助，因为看了测试代码之后，你就明白这个 CL 的期望行为是什么。

下一章：[代码审核的速度](speed.md)
