# 怎样写代码审核的评论？

## 目录
*   [概述](#summary)
*   [礼貌](#polite)
*   [解释为什么](#why)
*   [提供指导](#guidance)
*	[标记评论的严重程度](#label-comment-severity)
*   [接受解释](#explanations)


## 概述 {#summary}

-   保持友善。
-   解释原因。
-   给出明确的信息，指出问题所在，让开发者最后做决定。
-   鼓励开发者简化代码，给代码添加注释，而不是向你解释为什么这么复杂。

## 礼貌 {#polite}

在审核代码时，礼貌和尊重都很重要，与此同时，评论应该描述清晰，有利于开发者改进代码。确保你对代码的评论应该是针对“代码”，而不是针对“开发者”本人。当然，不必总是遵循这条原则，但是当你要说某些可能让人沮丧或引起争议的话时，一定要对事不对人。例如：

不好的说法：“为什么**你**在这儿使用线程？明显这儿使用并发没有任何好处。”

好的说法：“这儿的并发模型增加了系统的复杂度，我在性能上没有看到好处。因为没有性能提升，这段代码最好还是由多线程改成单线程。”

## 解释为什么 {#why}

从上面“好的说法”中，我们看到，它有助于开发者理解 *为什么* 你要写这条评论。当然，不必每次都解释为什么，但某些情形——阐明你的意图、你正在遵循的最佳实践、你在提升代码健康程度——解释原因是有必要的。

## 提供指导 {#guidance}

**一般而言，修复 CL 的责任人是开发者，而不是审核者。** 你不必为开发者写出详细的设计方案，也不必为他写代码。

但这不代表审核者可以不提供任何帮助。作为审核者，你应该在指出问题所在与提供直接指导之间做好平衡。指出问题，并让开发者自己做决定，这样有助于开发者自我学习，审核者自己也很省时间。这种方式，开发者也更容易找出更好的解决方案，因为相对审核者，开发者对自己的代码更熟悉。

当然，有些时候也可以给出直接的指示、建议或代码。毕竟，代码审核的首要目标是尽可能让 CL 变得更好；次要目标才是提升开发者的技能，以缩短审核时间。

谨记，人不仅能从那些可以做得更好的事情学到知识（译者注：可以做得更好，意味着还有提升的空间），还可以通过强化那些已经做得好的事情学到知识。如果你发现某个 CL 你很喜欢，也请加上评论。例如，，开发人员清理了混乱的算法，添加了教科书级的测试用例覆盖率，或者作为审核人，你从 CL 中学到了知识。就像所有的评论一样，在评论中加上你喜欢某些内容的原因，进一步鼓励开发人员继续良好的实践。

## 标记评论的严重程度 <a id="label-comment-severity"></a>

标记评论的严重程度，旨在把必需的修改与指南、建议区分开来。

如下是一些建议：

> Nit： 这是件小事。技术上讲你应该这么做，但不这么做影响也不大。  
> 可选（或考虑）：我认为这是个好主意，但不是必须这么做。  
> FYI： 我并不期望你在这个 CL 中这样做，但你会发现如果考虑长远一点，它会很有趣。  

这使得评论意图明确，并帮助作者优先考虑各种评论的重要性。它还有助于避免误解，例如，如果没有评论标签，开发人员可能会误以为这些修改是强制的，即使某些评论只是为了提供信息，或者告知它只是可选方案。

## 接受解释 {#explanations}

如果某段代码你看不懂，让开发者解释，通常结果是他们会**重写代码让它更清晰**。有时候，添加注释也可以，只要它不是用来解释一段过于复杂的代码。

**仅仅把解释写到代码审核工具里不利于以后的代码阅读者。** 只有几种情况可以这样，如当你正在审核一段你并不是很熟悉的代码时，开发者向你解释的文字，其他开发者都知道，那这种解释就不必写到代码里。

下一章：[代码评论被拒绝时，应如何处理？](pushback.md)
