# 代码审核指南

## 目录
*   [介绍](#intro)
*   [代码审核者应该看什么?](#look_for)
    *   [挑选最好的代码审核者](#best_reviewers)
    *   [面对面审核](#in_person)
*   [参考](#seealso)

## 介绍 {#intro}

开发者写完代码后，让其他人来审视这些代码，这个过程称为代码审核（译者注：也译为“代码评审”或“代码审视”）。

在 Google，我们通过代码审核来保证代码质量，进而保证产品质量。

此文档是 Google 代码审核审核流程和政策的规范说明。

本节对代码审核过程作简要介绍，后面的两篇文档会做更详细的说明：
-   **[怎样做代码审核](reviewer/)** ：针对代码审核者的指南。
-   **[开发者指南](developer/)** ：针对 CL 提交者的指南。

## 代码审核者应该看什么？ {#look_for}

代码审核者应该关注以下事项：

-   **设计**：代码是否设计良好？这种设计是否适合当前系统？
-   **功能**：代码实现的行为与作者的期望是否相符？代码实现的交互界面是否对用户友好？
-   **复杂性**：代码可以更简单吗？如果将来有其他开发者使用这段代码，他能很快理解吗？
-   **测试**：这段代码是否有正确的、设计良好的自动化测试？
-   **命名**：在为变量、类名、方法等命名时，开发者使用的名称是否清晰易懂？
-   **注释**：所有的注释是否都一目了然？
-   **代码样式**：所有的代码是否都遵循[代码样式指南](http://google.github.io/styleguide/)？
-   **文档**：开发者是否同时更新了相关文档？

详情可参见文档：[怎样做代码审核](reviewer/) 。

### 挑选最好的代码审核者 {#best_reviewers}

一般来讲，你一定会找*最好*的代码审核者来帮你审核代码，这个人应该在你期望的时间内有能力对审核工作负责。

如果若干人能对你的代码给出正确的反馈意见，那么最好的审核者就是这些人中最有见地的那个。他可能是你正在修改的代码的原始作者，也可能不是。有时候，一个代码审核者无法覆盖整个 CL，他们只能审核其中一部分，这种情况就需要多位审核者（这并不意味着当一个审核者能覆盖所有代码时，就只需要一个审核者），以确保能覆盖所有代码。

如果最理想的代码审核者无法帮你审核，至少应该抄送给他（或者把他加到可选的审核者名单里去）。

### 面对面审核 {#in_person}

如果你正在与一个人结对编程，你的伙伴已经对代码做过细致审核，那么这段代码可以认为是审核通过的。

你还可以与代码审核者进行面对面审核。当有疑问时，审核者提问，开发者回答。

## 参考 {#seealso}

-   [怎样做代码审核](reviewer/)：针对代码审核者的指南。
-   [开发者指南](developer/)：针对 CL 提交者的指南。
