# Emergencies

## 目录
*   [哪些是紧急情况？](#what)
*   [哪些不是紧急情况？](#not)
*   [什么是硬期限？](#deadlines)

有时候会有紧急的 CL。紧急情况发生时，必须尽快完成审核流程并提交。


## 哪些是紧急情况？ {#what}

紧急 CL 应该是一个 **小** 修改：一个重要的发布版本需要包含某个功能（无法回滚），修复产品中严重影响用户的缺陷，处理紧迫的法律问题，关闭一个重要的安全漏洞，等等。

处于紧急情况时，我们应该关心整个代码审核流程的速度，而不仅仅是[响应的速度](reviewer/speed.md)。更准确地说，在这种情况下，审核者应该把审核速度与代码的正确性（代码是否解决了紧急问题？）放在首位。并且，当紧急情况发生时，它的审核优先级必须高于其他所有的代码审核。

当紧急情况处理完毕之后，应该回过头来再继续做一次[更全面的审核](reviewer/looking-for.md)。

## 哪些不是紧急情况？ {#not}

需要明确的是，如下情形 *不是* 紧急情况：

-   希望本周完成，而不是下周（除非有一些无法回避的[硬期限](#deadlines)如合作伙伴之间的契约）。
-   开发者为这个功能已经开发了很长一段时间，他们希望尽快提交代码。
-   所有的审核者都不在相同的时区，他们现在是半夜或下班时间。
-   现在是周五快下班的时间，如果开发者能在周末离开公司之前提交代码那就太棒了。
-   经理说这个审核必须完成，CL 在今天必须提交因今天是[截止日期(软期限，而非硬期限)](#deadlines)。
-   回滚一个造成测试失败或编译错误的 CL。
等等。

## 什么是硬期限？ {#deadlines}

所谓硬期限（hard deadline），就是错过了就会有**灾难性的事情发生**。例如：

-   合同规定，你必须在某个特定日期之前提交 CL。
-   如果产品没有在某个特定日期之前发布，很有可能会影响销量，甚至在产品市场导致失败。
-   有些硬件制造商每年只会发布一次产品。如果在截止日期之前没有提交代码给他们，而这些代码又非常重要，很有可能会造成灾难性的后果。

推迟一周发布不是灾难性的。错过某次重要的会议可能是灾难性的，也可能不是。

大多数截止日期都是软期限（soft deadline），并非是不可改变的。这些软期限期望在某个时间节点得到需要的功能。它们很重要，但不应该为了达到目标而破坏代码的健康状况。

如果发布周期较长（好几个月），则很有可能会牺牲代码质量，以期在下一个周期之前实现某个功能。如果这种模式反复出现，那就为项目筑起了难以承受的技术债，这是项目开发中常见的问题。如果开发者经常在临近开发周期结束的时候提交代码，那么团队“必定”只能做表面上的代码审核。此时，团队应该修改开发流程，大型的功能修改应该在周期的早期进行，以确保有足够的时间做好代码审核。
