# 如何处理审核者的评论

## 目录
*   [不要情绪化](#personal)
*   [修复代码](#code)
*   [站在协作的角度思考](#think)
*   [冲突解决](#conflicts) 

在发出 CL 之后，审核者一般会给出反馈（评论），让你修改代码。下面我们就来详细描述如何处理这些评论。

## 不要情绪化 {#personal}

代码审核的目标是保证提交到的代码库中代码的质量，进而保证产品的质量。当审核者提出一些批判性的评论时，开发者应该告诉自己，对方在尝试帮助你，保证代码库的质量，帮助 Google，而不是针对你的人身攻击或个人能力的怀疑。

有时候，审核者感到很沮丧，并在评论中表达了这种心情。其实，这不是一种正确的方式，但作为开发者，你应该有足够的心理准备来面对这种情况。问一下自己，“我能从审核者的评论中读出哪些建设性的意见？”假想他们就是以这种建设性的语气对你说的，然后按照这种建议去做。

**不要在代码审核中带着情绪回复评论。** 在审核代码过程中，违反专业礼仪是件很严重的事情，但我们永远没法确保别人不违反专业礼仪。我们可以保证自己不要违反它。如果你很生气或恼火，以致于无法友好地回复，那就离开电脑一会儿，或者先换一件事情做直到心态平静下来，再礼貌地回复。

一般情况下，如果审核者没有以建设性地口吻提供反馈，反馈的方式不够礼貌，可以私下与他沟通。如果不方便与他私下沟通，也不方便通过是视频电话远程沟通，可以给他单独发一封邮件。在邮件中，以友好的态度向他解释，你很难接受这种反馈方式，期待他能换一种沟通方式。如果他仍旧以一种非建设性的方式回复你，或没有达到预期效果，那就升级到他的主管吧。

## 修复代码 {#code}

如果审核者说，他对你的代码中有些内容不理解，你的第一反应是澄清代码本身。如果代码无法澄清，加一段注释用以解释为什么这段代码这样写。如果这段注释放到代码里毫无意义，那就应该放到代码评审工作的评论中作为反馈的解释。

如果审核者无法理解某段代码，很有可能其他的代码阅读者也不懂。在代码审核工具中回复它对未来的代码阅读者没有任何好处。这种情况应该尝试清理代码，或增加一些必要的注释，以帮助他们阅读。

## 站在协作的角度思考 {#think}

写一个 CL 会耗费大量精力。在提交一个 CL 审核时，开发者会往往会产生几乎快要完成的幻觉，自认为无需进一步修改。当审核者回复需要修改某些代码时，开发者容易可能会感到沮丧，尤其当开发者不同意审核者的观点时更加显著。

此时，最好还是先退一步，仔细考虑审核者是否在反馈中提供了有价值的内容，可以帮助提高代码库的质量。你的第一个问题应该永远都是，“我理解了审核者的要求吗？”

如果无法回答这个问题，很有可能审核者需要进一步澄清评论。

如果你确认已经理解评论，但不同意审核者的观点，此时应该站在协作的角度思考，而不是站在争论或防御地角度：

不好的回复：“不，我不想按照你的建议去做。”

好的回复：“我使用 X 是应为 [这些优点/缺点]和[权衡]。根据我的理解，使用 Y 将会更差，因为[这些原因]。你建议使用 Y 是能更好的满足最初的权衡，但它的权重并没那么高，你说是吗？或者，你看还有其他的意见吗？”

谨记，[礼貌和尊重](https://chromium.googlesource.com/chromium/src/+/master/docs/cr_respect.md)始终应放在首位。如果你不同意审核者的观点，与之合作：请求澄清，讨论优缺点，提供解释为什么你的方法把他的建议更好，对代码、用户或公司的益处更大。

有时候，你可能知道用户、代码、CL的某些背景，而这些信息是审核者所不了解的。在适当的地方[修复代码](#code)，把审核者卷入到讨论中来，给他们提供更多的背景信息。通常，以技术事实为依据，你们双方会很大程度达成共识。

## 冲突解决 {#conflicts}

在解决冲突的第一步永远都是应该先尝试与审核者达成共识。如果无法达成共识，可以参考[审核代码标准](../reviewer/standard.md)，当面临这种情形时，它为我们提供了一些准则。
