# Google代码实践的一些感悟

自认为是一枚资深码农，对代码review早已驾轻就熟。读完之后，仍旧受益匪浅。受到原文中“希望其他组织也能从中受益”这句话的感召，我决定将其翻译成中文，托管到Github上，与大家一起分享。

原文标题为工程实践文档，表达更直接点，就是代码review规约。全文分两部分，一部分是针对代码审核人的指南，另一部分是针对代码提交人的指南，两部分文档交相呼应。

这份文档讲述了代码review的标准是什么，详细列举了在代码review过程中常见的问题，如何避免或解决这些问题，同时讲解了这么做的原因以及不这么做可能产生的后果。

文档列举了不少正面与反面的例子，可操作性很强。相信企业文化接近的朋友在读了本文之后，会有很深的认同感。在文档中提到、现实中做得不够好的地方，能很快掌握，并能把它融进自己所在的团队中，提升整个团队的开发效率。企业文化差距比较大的朋友读了之后，即使管理机制与此不兼容，在个人的层面也有很多可以改进的地方。从事非软件开发行业的朋友读了之后，相信也能有所感悟。文中提到的一些软技能，如情绪管理、沟通技巧等，在日常生活与工作中也非常有用。

回顾自己过去十几年review代码与被review代码的经历，有些事项一直都这么做，我知道为什么应该这么做；有些事项一直都这么做，至于为什么这么做我颇有微词；也有事项直到今天才知道原来这样做更好。

荀子在《劝学》中提到：不积跬步，无以至千里。抗战时期“积小胜为大胜”的战略思想，也是同样的道理。在本文中，鼓励 **每次都做一点微小的改进，多次微小的改进比一次大的改进容易得多**。这与Scrum把大User Story拆分成小User Story的观点相吻合。因为Points比较大的User Story，往往因为太大而无从下手，时间上也不可控。在进行Scrum指导时，我常对团队说“我们一个迭代周期只需改进两三个重要的问题，不必一次到位。习惯的力量太强大，需要逐步改进、适应，再改进，直到我们需要改进的措施成为我们的习惯。” 

原文提到一条看似要求很低的原则：**在修改时，至少不要恶化代码。**不要恶化代码是底线，一旦发生微小的恶化，破窗效应开始起作用，代码的健康状况会飞流直下。制定过高的标准，容易让人受挫；而合理的标准配以可实操的步骤，更容易达到目标，建立自信心。

我见过这样的主管，一次性提出很多要求，让下属立即（或很快）按照要求实施，而他要求的这些改变与团队当前的环境、习惯、认知存在很大的差距。立即实施的要求看似简单，但缺乏行之有效的措施，忽视了客观环境，忽视了突然改变所付出的代价与造成的负面影响，注定无法长期坚持下去。道理很简单，反面教材在生活中的确很常见，如上海严格的垃圾分类政策。

关于尊重，在彼此尊重的环境里，大家心态比较放松，愿意以积极的心态去避免或解决问题。因为彼此的尊重，大家更愿意通过沟通、讲理的方式去解决问题，而非依职位定高下。在这方面，不少企业还有很大的提升空间。

提到沟通，本文提到了一些沟通与冲突解决的技巧。如，当审核者与开发者有不同观点时，文档对审核者说，“开发者对代码更熟悉，先考虑对方的看法是否是正确的。”对开发者说，“先思考审核者提供的反馈中是否存在有价值的部分。”很有趣，在冲突解决时，都是先审视自身，对方是否是对的。如果每个人都以这种方式处事，相信全人类离世界和平的愿望又接近了一步。

世事并不完美。在代码审核过程中，“违反专业礼仪是一件很严重的事情。我们可以保证自己遵守，但永远没法保证他人不违反。”当他人违反了专业礼仪，我们该怎么做呢？本文也提出了解决方案。

还有一点很重要，“**不要在代码审核中带着情绪回复评论。**” 为人处世也是如此，在情绪激动（或紧张）时，人很难理智地思考，此时做出的决定往往会让自己后悔。不如先采取措施让自己冷静下来，之后再做决定。

以上是我的个人感悟，有兴趣的朋友读读原文吧。
<p align="right">Frank<br>2019.10.18</p>
