﻿using Abp.VueTemplate.MenuManagement;
using Volo.Abp.Account;
using Volo.Abp.AutoMapper;
using Volo.Abp.FeatureManagement;
using Volo.Abp.Identity;
using Volo.Abp.Modularity;
using Volo.Abp.PermissionManagement;
using Volo.Abp.TenantManagement;

namespace Abp.VueTemplate
{
    [DependsOn(
        typeof(MenuManagementApplicationModule),
        typeof(VueTemplateDomainModule),
        typeof(AbpAccountApplicationModule),
        typeof(VueTemplateApplicationContractsModule),
        typeof(AbpIdentityApplicationModule),
        typeof(AbpPermissionManagementApplicationModule),
        typeof(AbpTenantManagementApplicationModule),
        typeof(AbpFeatureManagementApplicationModule)
        )]
    public class VueTemplateApplicationModule : AbpModule
    {
        public override void ConfigureServices(ServiceConfigurationContext context)
        {
            Configure<AbpAutoMapperOptions>(options =>
            {
                options.AddMaps<VueTemplateApplicationModule>();
            });
        }
    }
}
