<?php
declare(strict_types=1);

namespace zesk;

use zesk\Controller\Share;
use zesk\Exception\DirectoryNotFound;
use zesk\Route\Controller as ControllerRoute;
use zesk\PHPUnit\TestCase;

class ShareControllerTest extends TestCase {
	protected Share $share;

	public function setUp(): void {
		parent::setUp();
		$router = $this->application->router();
		$this->route = new ControllerRoute($router, '*', ['controller' => Share::class]);
		$share = $this->route->controller();
		$this->assertInstanceOf(Share::class, $share);
		$this->share = $share;
	}

	public function tearDown(): void {
		parent::tearDown(); // TODO: Change the autogenerated stub
		unset($this->route);
		unset($this->share);
	}

	/**
	 * @return void
	 * @throws DirectoryNotFound
	 */
	public function test_sharePath(): void {
		$this->share->addSharePath($this->test_sandbox(), 'dude');
	}

	public function test_sharePath_not(): void {
		$this->expectException(DirectoryNotFound::class);
		$this->share->addSharePath(Directory::path($this->test_sandbox(), 'not-a-dir'), 'dude');
	}
}
