<?php
declare(strict_types=1);

namespace zesk\Mail;

use zesk\Application;
use zesk\Module as BaseModule;

class Module extends BaseModule {
	public function initialize(): void {
		parent::initialize(); // TODO: Change the autogenerated stub
		$this->application->registerFactory('Mail', $this->appMailFactory(...));
	}

	public function appMailFactory(Application $application, array $headers = [], string $body = '', array $options = []): Mail {
		return new Mail($application, $headers, $body, $options);
	}

	public function setDebug(bool $set): void {
		$this->application->configuration->setPath([Mail::class, Mail::OPTION_DEBUG], true);
	}

	/**
	 * @return bool
	 */
	public function debug(): bool {
		return toBool($this->application->configuration->getPath([Mail::class, Mail::OPTION_DEBUG]));
	}
}
