## [v0.31.0][]

Major revamp of Zesk. PSR-4. PHP 8.1. Added typing to nearly all calls and will continue until they all have types (
except core `abstract` and `interface`s which are untyped).

Dropped internal ORM implementation and database abastraction in favor of [Doctrine](https://www.doctrine-project.org/)
which has an excellect Database Abstraction Layer (DBAL) as well as a very mature and robust Object Relational Mapping (
ORM) engine.

If you upgraded to this version you will have a lot of work to do.

We anticipate a few small releases before a full 1.0 release.

Many breaking changes:

- Zesk's `functions.php` calls for typing such as `to_bool` (`toBool`) are now `zesk\Types::toBool`, etc.
- `pair` and other cousins are in `zesk\StringTools::pair`
- `map` and other cousins are in `zesk\ArrayTools::map`
- `tr` is now `zesk\Types::replaceSubstrings`
- `zesk\Options` and `zesk\Configuration` keys are case-sensitive
- `zesk\Exception\KeyNotFound` is used in cases where the key should exist more often
- `zesk\Exception` naming refactored
- Doctrine added, `zesk\Database` and `zesk\ORM` were removed. LOL. Some remnants remain and will be removed.
- Module names are case-sensitive
- Module JSONs are now loaded via glob `*.module.json` to avoid case-sensitivity issues
- All modules restructured to new project layout, tests added
- `Net` module had major renaming, part-way finished (WIP)
- Removed all widget and most HTML-related tools - moving to a more API-centric server model.
- Deprecated: `avalue`, `zesk\Kernel`
- All namespaces for modules are now `zesk\ModuleName\ClassName`
- Using flatter namespaces for most references
- Major camelCase refactor and cleanup
- PHP 8.1 default
- Template paths are no longer case-insensitive
- Code coverage for testing is more than 50%
- Added docker and testing containers
- Support XDEBUG debugging from the container
- Major development, build, and release updates to the project in `docker`, `bin/build`
- Removed a ton of old code and things which were no longer used
- Exceptions were renamed and refactored, now all have an `Exception` suffix
- Better use of namespaces
- World Bootstrap moved into `zesk\World\Bootstrap`
- Hook system rewritten to use PHP `Attribute`s
- Case-sensitivity has generally been removed from most systems where it was unnecessary

Other changes and improvements:

- Docker for PHP and debugging using XDebug, built-in MySQL for testing (will add other databases)
- Fully automated build and deployment
- PHP Unit test suite with coverage reports
- Follow all [PSR's](https://www.php-fig.org/psr/) for naming now

What's coming:

- `zesk\Doctrine` is still in testing and is incomplete
- All other `zesk\ORM`-based modules need to be migrated
- Additional code coverage and improved quality
