# Zesk Platform

Zesk is an application development platform which solves many problems found in other development platforms:

- Object-Oriented, PHP 5.2+ support only
- Robust and flexible hook methodology
- Toolkits to easily manage database schemas
- MVC implementation
- Class autoloading mechanism to simplify code dependencies
- Integration with Composer
- 135 Modules and growing

[About this documentation](readme.md). [Version history](versions.md). [Next release notes](current.md).

# Basic Architecture

- [Naming Conventions](zesk-naming.md)
- [Application](application.md)
- [Configuration File Format](configuration-file-format.md)
- [Configuration](globals.md)
- [Router File Format](router-file-format.md)

## Hooks

- [Hooks](hooks.md)
- [List of Hooks](hooks-list.md)

## Kernel

- [Kernel](kernel.md)
- [Deprecating Functionality](deprecated.md)

## Modules

- [Modules](modules.md)
- [Module Configuration](module-conf.md)
- [module-version.md](module-version.md)

## Templates and Theming

- [templates.md](templates.md)

## Internationalization

- [Translation](translation.md)

## Zesk JavaScript

- [About zesk.js](zesk.js.md)

## Web resource sharing

- [Sharing resources](share.md)

## Command-line Tools

- [About zesk.sh](zesk.sh.md)
- [configure Command](command-configure.md)
- [zesk-commands.md](zesk-commands.md)
- [Cron](cron.md)
- [Daemons](daemons.md)

## Appendix

- [Background: Naming styles definitions](naming-styles-definitions.md)
- [Background: Understanding PHP Case Sensitivity](php-case-sensitivity.md)

## Deprecated 2022

- [Widgets](widget.md)
