# Zesk Globals

Zesk globals typically contain settings and custom configurations throughout the system. They also provide a means to customize per-object behavior in an application.

The main accessor for global settings is the methods in the `zesk\Configuration` class which is accessible from the `$application` context.

    $value = $application->configuration->get('named-value', $default_value); 
	$application->configuration->set('named-value', $new_value);
	
The configuration object allows for a deep traversal tree of settings which can be organized 
	
# $_ZESK Global Storage

The global variable `$_ZESK` is *named similarly* to the PHP superglobals `$_SERVER`, `$_REQUEST`, etc. but is **not** a superglobal.

**It is solely used for initializing the application `Configuration` prior to loading of Zesk's `autoload.php`. Once the application Configuration is instantiated, the `$_ZESK` global is not longer used.**

Global keys are normalized to support use in a variety of contexts, but the general rule is stray punctuation is converted to underscores, and keys are lowercase. So:

	"View_Date::format"
	"view_date__format"

... are identical. The function

	_zesk_global_key($key)
	
Normalizes all keys before they are used to access a path into the `zesk\Configuration` object.

Also, the `$_ZESK` global structure is multi-dimensional and is accessed using a "path" with `::` as the delimiter to different levels.

So, for example:

	$zesk->configuration->path_set("a::b::c::d", "hello");
	
Would result in the global `$_ZESK` to have the value:

	array(
		"a" => array(
			"b" => array(
				"c" => array(
					d" => "hello"
				)
			)
		)
	)

# zesk\Settings

`zesk\Settings` is an object which enables loading of Zesk globals from the database, and supports loading and saving those globals.

	zesk\Settings::instance()->set("name", $value);
	
Values are serialized to the database, so complex structures can be stored and re-animated as needed. (However, use caution when storing large data as a global.) 

If an application supports `Settings` for application configuration, all settings are loaded at Application configuration time. The `Settings` are loaded into the global scope, so:

	zesk\Settings::instance()->get("named-value")
	
and

	zesk()->configuration->get("named-value")
	
Are synonymous once loaded. To save a global, do:

	Settings::instance()->set("named-value", $value);
	
Finally, to enable `zesk\Settings` support in an application, simply register its hooks (TODO Is this still true?):

	zesk\Hooks::registerClass('Settings');

... prior to `zesk\Application` configuration.

# Reserved globals

***KMD: This section needs updating, and is not accurate as of 2016-08-31.***

## `zesk_root`

This global is set automatically by the system and can not be overwritten. It is the absolute path (including a trailing slash) to the root directory where `Zesk` code is stored.

## `zesk_application_root`

This global is set automatically by the system and can not be overwritten. It is the absolute path (including a trailing slash) to the root directory where all application code is stored.

## `application_class`

The class name of the `Application`. Defaults to `Application`. Created by `Application::instance()`, e.g.

	class MyLittlePony extends Zesk_Application {
		// Fill in methods here
	}
	zesk::set("application_class", "MyLittlePony");
	$app = Application::instance();
	assert($app instanceof MyLittlePony);

## `temporary_path`

Path to a directory in the local file system to store temporary files. Defaults to `ZESK_APPLICATION_ROOT/cache/temp`. Access via `zesk::temporary_path()`

    $data_path = zesk::temporary_path("download-to-process");
	// Returns /path/to/app/root/cache/temp/download-to-process
	
It is assumed that any files stored in the temporary path can be deleted after a reasonable amount of time and the application will be able to recover. To store files longer-term, store them in the `data_path`.

## `data_path`

Path to a directory in the local file system to store long-term data files. Should be backed up with the application, if needed. Defaults to `ZESK_APPLICATION_ROOT/data`. Access via `zesk::data_path()`

    $data_path = zesk::data_path("my_images");
	// Returns /path/to/app/root/data/my_images

## `document_root`

The directory where the web server serves all content from. This is an absolute path and is configured automatically by Zesk but can be overridden by an application if desired.

## `document_root_prefix`

If a site is not served from a rooted web site (e.g. `http://example.com/path/to/the/application/index.php`) then this value is set to the prefix of the document root. It is prepended to any URL generated by the system, so in the above URL, it would be "/path/to/the/application".

## `command_path`

Search path for shell or external commands. Similar to `$PATH` in `bash`, if not set it will use `$_SERVER['PATH']` which is separated by an operating-specific separator. 
A semicolon-separated list of paths in the file-system.

## `zeskCommandPath`

Search path for zesk shell commands, invoked by [zesk.sh](zesk.sh.md). Similar to `command_path`, semicolon-separated. Defaults to "$ZESK_ROOT/command".

## `autoload_path`

List of absolute paths (separated)

## `assert_callback`

The internal PHP method to call when an assertion failed. 

## `assert`

Set handling of `assert` failures.

## `deprecated`

Set handling of [deprecated](deprecated.md) functionality in Zesk. Can be one of:

- `log`: Log all deprecated function calls to the [log](log.md)
- `exception`: Throw an `Deprecated` when a deprecated function is invoked

## `lf`

Linefeed character. Defaults to global defined value `ZESK_DEFAULT_NEWLINE` which is `\n` for console invocation, `<br />` for web invocations. Can be set explicitly by calling `newline($new_newline_characters)`.

## 

# Debugging Globals

## `debug_command_path`



# Deprecated Globals

## `zesk_site_root`

a.k.a. `zesk_application_root`
