<!-- readme.md v1.0.0.0
Exploration Expansion (LEE)
created: 13 Dec 2022
updated: 16 Mar 2023

TEMPLATE: readme.md v1.7.0.3
created: 17 Jul 2017
updated: 17 Feb 2023

this file: CC BY-ND 4.0 by zer0Kerbal -->

[![Exploration Expansion (LEE)][SHD:mod]][CURSFG:url] [![KSP version][KSP:shd]][KSP:url]  [![License][LIC:shd]][LIC:url]  
[![Curseforge][CURSFG:shd]][CURSFG:url] [![GitHub][GITHUB:shd]][GITHUB:url] 
[![Pages][SHD:pages]][pages]


# Exploration Expansion (LEE)

12 piece add-on planetary exploration parts pack for the LazTek Launch Pack that includes advanced engines, a habitat, fuel tanks and fairings.

NOTE: only the normal textures are included, the 'HD' / 'LD' textures are available to download and use instead. Only one is intended to be used at once, and in fact installing another should replace the existing textures.

## By [`zer0Kerbal`][zer0Kerbal], originally by [`LazarusLuan`][lazarusluan]

<img src="https://raw.githubusercontent.com/zer0Kerbal/ExplorationExpansion/master/img/HeroLogo_1920x1920.png" alt="ExplorationExpansion Hero" width="50%" height="50%">

### Preamble by [LazarusLuan][LazarusLuan]

> The LazTek Exploration Expansion Kit is designed as an add-on for our LazTek Launch Pack, and the included .craft files require the installation of the Launch Pack to load correctly.
>
> Available for download in low, medium and high resolution versions, these mods include replicas of the new LazTek Dragon V2 capsule and trunk, LazTek Falcon 9 v1.1 and Falcon Heavy launch platforms, proposed Exploration Expansion, plus special configurations for exploration, asteroid redirection, refueling, colonization and more! Add the LazTek Exploration Expansion for access to the original DragonRider concept spacecraft.

### Included

* Parts
  * Dragon
    * Habitat
      * A complete living quarters and mobile laboratory solution for extraplanetary exploration.
      * Has inflatable living/working area that accomodates 7 kerbalnauts with interior views.
    * Aft Dock
      * designed to allow docking between Dragon V2 and Dragon Trunk V2 when equipped with Dragon Dock
    * Retractable Solar Panel Cover
      * Fits over Habitat solar panels and may be toggled open and closed
    * Explorer Shield V2
      * Protects Dragon Habitat during atmospheric entry, has top decoupler
    * Habitat Landing Leg
      * Retractable landing gear for Dragon Habitat module, designed to be surface attached in a set of four.
  * Falcon
    * Short Interstage
      * Protective decoupler that allows ARM claw to be installed under the Dragon 2 and Explorer Habitat
    * Tanker
      * Large upper stage fuel and monopropellant tank for orbital refueling of interplanetary missions
    * Solar Array
      * A surface-mounted small solar panel array that includes a smaller version of the Dragon Solar Panels hidden behind retractable protective doors and designed to be used with the Falcon tanker for orbital electrical power
  * Engines
    * Advanced VTOL Engine
      * Monopropellant-burning, advanced hybrid engine contained in a 1m cowling, switchable between air-breathing and closed system modes for single stage to orbit spacecraft.
      * Has vector thrust that can be switched 90 degrees in two directions.
    * NERVA II Nuclear Vacuum Engine
      * NASA NERVA II Nuclear vacuum engine, mount and protective cowling designed to be attached to 2.5m upper tank of long-range space vehicles.
  * Monopropellant Tanks
  * 200 Small, attachable monopropellant tank for extended use of Draco-engine spacecraft.
  * 400 Attachable monopropellant tank for extended use of Draco-engine spacecraft.

* Ships (.craft)
  * LazTek Dragon Explorer V2 - Designed to explore and return from any solid body in the Kerbol system, this ship is set up with an inflatable habitat with living quarters for up to seven Kerbalnauts and a Nerva II long-range nuclear engine for interplanetary travel. The Dragon V2 craft is equipped with an aft dock for use as a lander that can redock with orbiter.
  * LazTek DragonClaw V2 - Created for asteroid redirect missions, local system small body exploration and colonization, spacecraft and satellite towing and deorbiting. Carries extra monopropellant and uses reverse-mounted claw for towing objects. 
  * LazTek Falcon Tanker - Designed to refuel explorer craft for long-range, interplanetary missions while still in home orbit. Uses specialized upper tank that carries regular and monopropellant fuel.

  * [Craft Notes](https://zer0kerbal.github.io/ExplorationExpansion/HowItWorks.html)

### See more

>* [Dragon 2 wiki](https://en.wikipedia.org/wiki/LazTek_Dragon_2)
>* [Falcon 9 wiki](https://en.wikipedia.org/wiki/Falcon_9)
>* [GitHub Pages][pages]
>* [Marketing Slicks][markt]
>* [Parts Catalog][parts] for part pictures
>* [Discussions][discu] or [KSP Forums][forum] for discussions and news
>* [ChangeLog][chlog] for more details of changes
>* [Known Issues][issue] for more details of feature requests and known issues

### YouTube

* [DragonRider Demonstration Flight](https://youtu.be/YHweoLbBh64)
* [Falcon 9 Reusability Demonstration](https://youtu.be/tfXa-zItqjU)
* [Falcon Heavy Reusability Demonstration](https://youtu.be/EmL7K2l8sbg)
* [3.75m Payload Bay Demonstration](https://youtu.be/c2qMbbS55Pg)

### Help Wanted

> * Stock Balance Pass - can 50 kerbals actually fit in the pod?
> * Compatibility patches
>   * RPM/MAS, life support, other
> * IVA's
>   * Update the pod's IVA
> * Sample Crafts
> * Contracts for these glorious parts
> * Variant Textures
> * Update the landing legs to use stock leg modules instead of ModuleAnimateGeneric
> * Marketing Images and Videos such as hero shots, animated gifs, short highlights
> * Translations: See the [README in the Localization folder][lreadme] for instructions for adding or improving translations. There is also the [quickstart guide][qstart]. [GitHub][GitHub:url] push is the best way to contribute. *Additions and corrections welcome!*
> * Have a request? Glad to have them, kindly submit through [GitHub][issue].

### Localization

>* ![English][EN] English
>* ***your translation here***

### Installation Directions

***Only available on***
  CurseForge Website / OverWolf App

  <a href="https://download.curseforge.com/"> <img src="https://www.overwolf.com/brand-guidelines/img/logo2.svg" alt="CurseForge/OverWolf App" width="15%" height="15%"></a>

### Dependencies

* [LazTek Dev (LTD)][LTD]
  * [LaunchPack (LLP)][LLP]

### Recommends

* [LazTek Dev (LTD)][LTD]'s
  * [Colonial Transport (LCT)][LCT]
  * [Exploration Expansion (LHA)][LHA]

### Suggests

* [Adjustable Mod Panel (KAMP)][KAMP]
* [Biomatic (BIO)][BIO]
* [Docking Port Descriptions (DPD)][DPD]
* [Field Training Facility (FTF)][FTF]
* [Field Training Lab (FTL)][FTL]
* [GPO (Goo Pumps & Oils') Speed Pump (GPO)][GPO]
* [Kaboom! (BOOM)][BOOM]
* [Keridian Dynamics (KDVA)][KDVA]
* [MoarKerbals (MOAR)][MOAR]
* [Not So SimpleConstructon! (NSSC)][NSSC]
* [On Demand Fuel Cells (ODFC)][ODFC]
* [OScience Laboratories (OSL)][OSL]
* [Papa Kerballini's Pizza (PIZZA)][PIZZA]
* [Precise Maneuver (PM)][PM]
* [SimpleConstruction! (SCON)][SCON]
* [SimpleLogistics! (SLOG)][SLOG]
* [SimpleNotes! (NOTE)][NOTES]
* [Solar Science (SOL)][SOL]
* [Stock Inline Lights (SIL)][SIL]
* [Kerbal Attachment System][kas]
* [Kerbal Inventory System][kis]
* [Kerbal Joint Reinforcement][kjr]
* [TweakScale][twk]

### Supports

* Either
  * [Modular Management (MM)][MM]
  * [Module Manager][m-m]

*Be Kind: lithobrake, not jakebrake! Keep your ModMan up to date!*

### Tags

parts, config

<div style="border:0.5px solid Tomato; background-color: #BADA55; color: #FF0000; text-align:center">
  <p><b>red box below is a link to forum post on how to get support</b></p>
  <a href="https://forum.kerbalspaceprogram.com/index.php?/topic/83212-*">
    <p><img src="https://i.postimg.cc/vHP6zmrw/image.png" alt="How to get support"></p></a>
  <p style="color: #000000;">Be Kind: Lithobrake, not jakebrake! Keep your Module Manager up to date</p>
</div>

### Credits and Special Thanks

* [LazarusLuan][lazarusluan] for creating this glorious parts addon!
* see [Attribution.md][attrb] for more

### Legal Mumbo Jumbo (License *provenance*)

#### Current (1) - [`zer0Kerbal`][zer0Kerbal]

> Forum: [Thread][forum] - Source: [GitHub][GITHUB:url]  
> License: [![License][LIC:shd]][LIC:url] ![License][LIC:log]
>
> ##### Disclaimer(s)
>
> ***All bundled mods are distributed under their own licenses***  
> ***All assets, including but not limited to: animations, models, sounds and textures are distributed under their own licenses. [![License][LIC:0:shd]][LIC:0:url]***

##### see [Notices.md][notic] for more *legal Mumbo Jumbo*

#### Original (0) - Author: [`LazarusLuan`][lazarusluan]

> Forum: [Thread][MOD:0:thread] - Download: [CurseForge][MOD:0:dnload] - Source: [CurseForge][MOD:0:source]  
> License: [![License][LIC:0:shd]][LIC:0:url]

### How to support this and other great mods by [`zer0Kerbal`][zer0Kerbal]  

Comment, click, like, share, up-vote, subscribe

> ***Completely voluntary, absolutely amazing, and really does help me out a lot!***  
> quote from <a href="https://forum.kerbalspaceprogram.com/index.php?/profile/32393-*/"><img alt="cybutek" src="https://kerbal-forum-uploads.s3.us-west-2.amazonaws.com/monthly_2020_06/kappa-kerbal-anarchy.thumb.png.673a2f6f7b36cc60a35c24efef217246.png" width="25px" height="25px"> cybutek</a> creator of <a href="https://forum.kerbalspaceprogram.com/index.php?/topic/17833-130-*/" alt="Kerbal Engineer Redux (KER)"> Kerbal Engineer</a>

[![Support][PAYPAL:img]][PAYPAL:url] [![Patreon][PATREON:img]][PATREON:url]

*and it is true.*
<!-- links -->
[attrb]: https://zer0kerbal.github.io/ExplorationExpansion/Attributions "Attribution"
[chlog]: https://raw.githubusercontent.com/zer0Kerbal/ExplorationExpansion/master/changelog.md  "Changelog"
[discu]: https://github.com/zer0Kerbal/ExplorationExpansion/discussions "Discussions"
[forum]: https://www.curseforge.com/kerbal/ksp-mods/ExplorationExpansion "Exploration Expansion"
[issue]: https://github.com/zer0Kerbal/ExplorationExpansion/issues "Issues"
[markt]: https://zer0kerbal.github.io/ExplorationExpansion/Marketing "Marketing Slicks"
[notic]: https://zer0kerbal.github.io/ExplorationExpansion/Notices "Notices"
[pages]: https://zer0kerbal.github.io/ExplorationExpansion "GitHub Pages"
[parts]: https://zer0kerbal.github.io/ExplorationExpansion/PartsCatalog "Parts Catalog"

<!--- shields -->
[SHD:mod]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/ExplorationExpansion/master/json/mod.json
[SHD:pages]: https://img.shields.io/badge/GitHub-Pages-white?style=plastic&labelColor=9cf&logoColor=181717&logo=github "GitHub IO"

<!--- mod provenance -->
[MOD:0:dnload]: https://www.curseforge.com/kerbal/ksp-mods/ExplorationExpansion "CurseForge"
[MOD:0:source]: https://www.curseforge.com/kerbal/ksp-mods/ExplorationExpansion "CurseForge"
[MOD:0:thread]: https://forum.kerbalspaceprogram.com/index.php?/topic/27154-*/ "KSP Forum"

<!--- license provenance -->
[LIC:0:url]: https://en.wikipedia.org/wiki/All_rights_reserved "All Rights Reserved"
[LIC:0:shd]: https://img.shields.io/badge/License-All%20Rights%20Reserved-white?labelColor=black&style=plastic "All Rights Reserved"

[LIC:url]: https://creativecommons.org/licenses/by-sd/4.0/ "CC BY-ND 4.0"
[LIC:log]: https://licensebuttons.net/i/l/by-nd/transparent/33/66/99/76x22.png "CC BY-ND 4.0"
[LIC:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/ExplorationExpansion/master/json/license.json "CC BY-ND 4.0"

<!--- release links -->
[CURSFG:url]: https://www.curseforge.com/kerbal/ksp-mods/ExplorationExpansion "Curseforge"
[CURSFG:shd]: https://img.shields.io/badge/CurseForge-Link-CCFF00.svg?labelColor=6441A4&style=plastic&logo=curseforge "Curseforge"

[GITHUB:url]: https://github.com/zer0Kerbal/ExplorationExpansion/ "GitHub"
[GITHUB:shd]: https://img.shields.io/badge/Github-Link-CCFF00.svg?labelColor=181717&style=plastic&logo=github "GitHub"

<!-- Kerbal Space Program -->
[KSP:url]: https://kerbalspaceprogram.com/ "Kerbal Space Program"
[KSP:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/ExplorationExpansion/master/json/ksp.json "Kerbal Space Program"

<!-- links to add-ons/mods -->
[BIO]: https://forum.kerbalspaceprogram.com/index.php?/topic/191426-*/ "Biomatic (BIO)"
[BOOM]: https://forum.kerbalspaceprogram.com/index.php?/topic/192938-*/ "Kaboom (BOOM)"
[DPD]: https://forum.kerbalspaceprogram.com/index.php?/topic/192184-*/ "Docking Port Descriptions"
[FTF]: https://forum.kerbalspaceprogram.com/index.php?/topic/188841-*/ "Field Training Facility (FTF)"
[FTL]: https://forum.kerbalspaceprogram.com/index.php?/topic/188841-*/ "Field Training Lab (FTL)"
[GPO]: https://forum.kerbalspaceprogram.com/index.php?/topic/207732-*/ "GPO SpeedPump (GPO)"
[KAMP]: https://forum.kerbalspaceprogram.com/index.php?/topic/207263-*/ "Adjustable Mod Panel (KAMP)"
[KDVA]: https://forum.kerbalspaceprogram.com/index.php?/topic/202945-*/ "Keridian Dynamics (KDVA)"
[LTD]: https://github.com/zer0Kerbal/LazTekDev "LazTek Dev (LTD)"
[LHA]: https://github.com/zer0Kerbal/HistoricArchive "Exploration Expansion (LHA)"
[LCT]: https://github.com/zer0Kerbal/ColonialTransporter "Colonial Transporter (LCT)"
[LLP]: https://github.com/zer0Kerbal/LaunchPack "Launch Pack (LLP)"
[MOAR]: https://forum.kerbalspaceprogram.com/index.php?/topic/191525-*/ "MoarKerbals (MOAR)"
[NOTES]: https://forum.kerbalspaceprogram.com/index.php?/topic/207118-*/ "SimpleNotes! (NOTES)"
[NSSC]: https://forum.kerbalspaceprogram.com/index.php?/topic/191504-*/ "Not So SimpleConstructon! (NSSC)"
[ODFC]: https://forum.kerbalspaceprogram.com/index.php?/topic/187625-*/ "On Demand Fuel Cells (ODFC)"
[OSL]: https://forum.kerbalspaceprogram.com/index.php?/topic/209490-*/ "OScience Laboratories (OSL)"
[PIZZA]: https://forum.kerbalspaceprogram.com/index.php?/topic/209577-*/ "Papa Kerballini's Pizza (PIZZA)"
[PM]: https://forum.kerbalspaceprogram.com/index.php?/topic/207261-*/ "Precise Maneuver (PM)"
[SCON]: https://forum.kerbalspaceprogram.com/index.php?/topic/191424-*/ "SimpleConstructon! (SCON)"
[SIL]: https://forum.kerbalspaceprogram.com/index.php?/topic/193050-*/ "Stock Inline Lights (SIL)"
[SLOG]: https://forum.kerbalspaceprogram.com/index.php?/topic/191045-*/ "SimpleLogistics! (SLOG)"
[SOL]: https://forum.kerbalspaceprogram.com/index.php?/topic/192489-*/ "Solar Science (SOL)"

[kas]: http://forum.kerbalspaceprogram.com/index.php?/topic/142594-*/ "Kerbal Attachment System"
[kis]: http://forum.kerbalspaceprogram.com/index.php?/topic/149848-*/ "Kerbal Inventory System"
[kjr]: https://forum.kerbalspaceprogram.com/index.php?/topic/184206-*/ "Kerbal Joint Reinforcement"
[m-m]: https://forum.kerbalspaceprogram.com/index.php?/topic/50533-*/ "Module Manager"
[MM]: https://github.com/net-lisias-ksp/ModuleManager "Modular Management (MM)"
[twk]: https://forum.kerbalspaceprogram.com/index.php?/topic/179030-*/ "TweakScale"

<!-- financial support -->
[PAYPAL:img]: https://img.shields.io/badge/Buy%20me%20some%20-LFO-BADA55?style=for-the-badge&logo=paypal&labelColor=FFDD00/ "PayPal"
[PAYPAL:url]: https://www.paypal.com/donate?hosted_button_id=DC22YHMEJREKL/ "PayPal"
[PATREON:img]: https://img.shields.io/badge/Patreon%20-Patreonize-FF424D?style=for-the-badge&logo=patreon/ "Patreon"
[PATREON:url]: https://www.patreon.com/bePatron?u=23390503/ "Patreon"
[BMCC:url]: https://buymeacoffee.com/zer0Kerbal/ "Buy Me A Snack"

<!-- Localization -->
[lreadme]: https://github.com/zer0Kerbal/zer0Kerbal/blob/master/Localization/readme.md "Localization Readme"
[qstart]: https://github.com/zer0Kerbal/zer0Kerbal/blob/master/Localization/quickstart.md "Quickstart"
[EN]: https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/master/img/EN.png "English"

[curseforge]: https://www.curseforge.com/members/zer0kerbal/projects
[reddit]: https://www.reddit.com/user/zer0Kerbal
[twitch]: https://www.twitch.tv/zer0kerbal
[twitter]: https://twitter.com/zer0Kerbal
[youtube]: https://www.youtube.com/@zer0Kerbal

[LazarusLuan]: https://forum.kerbalspaceprogram.com/index.php?/profile/61673-*/ "LazarusLuan"
[zer0Kerbal]: https://forum.kerbalspaceprogram.com/index.php?/profile/190933-*/ "zer0Kerbal"

#### Connect with me

Track progress: issues [here][issue] and projects [here](https://github.com/zer0Kerbal/ExplorationExpansion/projects/) along with **[The Short List](https://github.com/users/zer0Kerbal/projects/27)**

[<img align="left" alt="zer0Kerbal | kerbalspaceprogram.com" width="32px" src="https://cdn.icon-icons.com/icons2/1381/PNG/32/kerbalspaceprogram_93898.png" />][zer0Kerbal] [<img align="left" alt="zer0Kerbal | CurseForge" width="32px" src="https://cdn.jsdelivr.net/npm/simple-icons@v3/icons/curseforge.svg" />][curseforge] [<img align="left" alt="zer0Kerbal | reddit" width="32px" src="https://cdn.icon-icons.com/icons2/1945/PNG/512/iconfinder-reddit-4661631_122483.png" />][reddit] [<img align="left" alt="zer0Kerbal | Patreon" width="32px" src="https://cdn.icon-icons.com/icons2/2429/PNG/512/patreon_logo_icon_147253.png" />][PATREON:url] [<img align="left" alt="zer0Kerbal | YouTube" width="32px" src="https://cdn.icon-icons.com/icons2/836/PNG/512/Youtube_icon-icons.com_66802.png" />][youtube] [<img align="left" alt="zer0Kerbal | Twitch" width="32px" src="https://cdn.icon-icons.com/icons2/2699/PNG/512/twitch_logo_icon_170383.png" />][twitch] [<img align="left" alt="zer0Kerbal | PayPal" width="32px" src="https://cdn.icon-icons.com/icons2/2699/PNG/512/paypal_logo_icon_168055.png" />][PAYPAL:url] [<img align="left" alt="zer0Kerbal | Buy Me a Coffee" width="32px" src="https://www.buymeacoffee.com/assets/img/bmc-meta-new/new/favicon.ico" />][BMCC:url] [<img align="left" alt="zer0Kerbal | Twitter" width="32px" src="https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/master/img/twitter-32.ico" />][twitter]</br>