<!-- readme.md v1.6.99.1
Behemoth Aerospace Engineering (BAE)
created: 02 Jun 2015
updated: 01 Jul 2023

TEMPLATE: readme.md v1.7.4.2
created: 17 Jul 2017
updated: 18 Jun 2023

THIS FILE: CC BY-ND 4.0 by zer0Kerbal -->
# [Behemoth Aerospace Engineering (BAE)][CURSFG:url]

[![Behemoth Aerospace Engineering (BAE)][SHD:mod]][CURSFG:url]  
[![KSP version][KSP:shd]][KSP:url] [![License][LIC:shd]][LIC:url]  
[![Curseforge][CURSFG:shd]][CURSFG:url] [![GitHub][GITHUB:shd]][GITHUB:url] [![GitHub Pages][SHD:pgs]][pages]

99 Behemoth Parts

This parts pack contains engines, tanks, and other part categories in three sizes that do not exist in stock KSP, namely 5m, 7.5m, and 10m. Parts are color-coded according to the [universal electronic color code](http://en.wikipedia.org/wiki/Electronic_color_code), simply because the author is an old [RDAF](https://en.wikipedia.org/wiki/Royal_Danish_Air_Force) radar technician. Hence, size4 (5m) is yellow, size5 (7.5m) is green, and size6 (10m) is blue.

Engines are kept at reasonable thrust figures and are thus not overpowered compared to the thrust/size curve of stock parts. The same goes for reaction wheels. Big spaceships are going to be sluggish, as one would expect.

## By [`zer0Kerbal`][zer0Kerbal], originally by [`greystork`][greystork] then by [Comwarrior`][comwarrior]

<img src="https://raw.githubusercontent.com/zer0Kerbal/BehemothAerospaceEngineering/master/img/HeroLogo.png" alt="Behemoth Aerospace Engineering Hero" width="50%" height="50%">

### See More

>* [ChangeLog][chlog] for more details of changes
>* [Discussions][discu] or [forums][forum] for discussions and news
>* [GitHub Pages][pages]
>* [Known Issues][issue] for more details of feature requests and known issues
>* [Marketing Slicks][markt]
>* [Parts Catalog][parts] for part pictures
>* [Wiki: universal electronic color code](http://en.wikipedia.org/wiki/Electronic_color_code)

### <img src="https://cdn.pixabay.com/photo/2014/05/14/14/17/youtube-344106_960_720.png" alt="Youtube logo" height="33px" width="66px">

>  Review by [`Kottabos Gaming`](https://forum.kerbalspaceprogram.com/index.php?/profile/36583-*/)
>
>[![KSP Mods - Behemoth Aerospace Engineering](https://img.youtube.com/vi/CVAygrQ98AI/0.jpg)](https://www.youtube.com/watch?v=CVAygrQ98AI)
</details>

### Localization

>* ![English](https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/zed'K/img/EN.png) English
>* ***your translation here***

### Help Wanted

> * Compatibility patches
> * Contracts for these glorious parts
> * Sample crafts/subassemblies
> * Variant textures and model updates (add/improve: lights, iva, hatches et al)
> * Marketing Images and Videos such as hero shots, animated gifs, short highlights
> * Translations: See the [README's in the Localization folder](https://github.com/zer0Kerbal/zer0Kerbal/blob/master/Localization/readme.md) for instructions for adding or improving translations. There is also the [quick start guide(s)](https://github.com/zer0Kerbal/zer0Kerbal/blob/master/Localization/quickstart.md). [GitHub][GitHub:url] push is the best way to contribute. *Additions and corrections welcome!*
> * Have a request? Glad to have them, kindly submit through [GitHub][issue].

### Installation Directions

Most recent releases only available via CurseForge/OverWolf Website/App

<a href="https://download.curseforge.com/"><img src="https://www.overwolf.com/brand-guidelines/img/logo2.svg" alt="CurseForge/OverWolf App" height="100px"></a>

### Dependencies

* [Kerbal Space Program][KSP:url] [![Kerbal Space Program][KSP:shd]][KSP:url]

### Suggests

* [Adjustable Mod Panel (KAMP)](https://curseforge.com/kerbal/ksp-mods/AdjustableModPanel)
* [Drop Tanks (DROP)](https://curseforge.com/kerbal/ksp-mods/DropTanks)
* [Drop Tanks III (DTIII)](https://curseforge.com/kerbal/ksp-mods/DropTanksIII)
* [Exception Detector (EXCD)](https://curseforge.com/kerbal/ksp-mods/ExceptionDetector)
* [Gimbal Trim (TRIM)](https://curseforge.com/kerbal/ksp-mods/GimbalTrim)
* [GPO (Goo Pumps & Oils') Speed Pump (GPO)](https://curseforge.com/kerbal/ksp-mods/GPOSpeedPump)
* [Kaboom! (BOOM)](https://curseforge.com/kerbal/ksp-mods/Kaboom)
* [On Demand Fuel Cells (ODFC)](https://curseforge.com/kerbal/ksp-mods/OnDemandFuelCells)
* [Precise Maneuver (PM)](https://curseforge.com/kerbal/ksp-mods/PreciseManeuver)
* [SimpleLogistics! (SLOG)](https://curseforge.com/kerbal/ksp-mods/SimpleLogistics)
* [SimpleNotes! (NOTE)](https://curseforge.com/kerbal/ksp-mods/Notes)
* More large parts:
  * [Coyote Cargo Freighter (CCF)](https://curseforge.com/kerbal/ksp-mods/CoyoteCargoFreighter)
  * [Lithobrake Exploration Technologies (LET)](https://curseforge.com/kerbal/ksp-mods/LithobrakeExplorationTechnologies) lander parts, large chutes/legs/ladders/etc
  * [Modular Rocket Systems (MRS)](https://curseforge.com/kerbal/ksp-mods/ModularRocketSystems) stock-alike parts pack, NASA-like alternatives, and filling the gaps
  * [Modular Rocket Systems LITE (MRSL)](https://curseforge.com/kerbal/ksp-mods/ModularRocketSystemsLite)
  * [SeaDragon (SEA)](https://curseforge.com/kerbal/ksp-mods/SeaDragon)
  * [SpaceY Expanded (SYX)](https://curseforge.com/kerbal/ksp-mods/SpaceYExpanded)
  * [SpaceY Lifters (SYL)](https://curseforge.com/kerbal/ksp-mods/SpaceYLifters) stock-balanced large rocket parts, 5m parts, large SRBs
  * [The Elephant Engine (ELEP)](https://curseforge.com/kerbal/ksp-mods/ElephantEngine)
* [Kerbal Joint Reinforcement (kjr)](https://forum.kerbalspaceprogram.com/index.php?/topic/184206-*/) - <small><i>ensures that your big spaceships suffer less from unplanned rapid disassembly.</small></i>

### Supports

* [~~Cross Feed Enabler] - enables cross feed to radially attached 'Predator' tanks~~
* [Booster Segments (BSEG)](https://curseforge.com/kerbal/ksp-mods/BoosterSegments)<small><i></small></i>
* [Community Tech Tree (ctt)](https://legacy.curseforge.com/kerbal/ksp-mods/community-tech-tree) - <small><i>extends the stock technology tree with lots of new nodes for your favorite parts packs to fill.* </small></i>
* [Connected Living Space (CLS)](https://curseforge.com/kerbal/ksp-mods/connectedlivingspace)
* [Default Action Groups (DAG)](http://forum.kerbalspaceprogram.com/index.php?/topic/125832-*/) enables automatic toggling of SAS on reaction wheels
* [Engine Ignitor (ign)](https://forum.kerbalspaceprogram.com/index.php?/topic/168424-*/)
* [Kerbal Operating System (KOS)](https://forum.kerbalspaceprogram.com/index.php?/topic/165628-*/)
* [ModularManagement (MM)](https://curseforge.com/kerbal/ksp-mods/ModularManagement) or [Module Manager](https://forum.kerbalspaceprogram.com/index.php?/topic/50533-*/)
* [RemoteTech (RT)](https://remotetechnologiesgroup.github.io/RemoteTech/)
* [SCANSat (scan)](https://forum.kerbalspaceprogram.com/index.php?/topic/72679-*/)
* [Tarsier Space Tech (tst)](http://forum.kerbalspaceprogram.com/index.php?/topic/154853-*/)
* [TweakScale (twk)](https://curseforge.com/kerbal/ksp-mods/TweakScale)
* Fuel Switchers:
  * [B9 Part Switch](https://forum.kerbalspaceprogram.com/topic/140541-*/)
  * [FireSpitter Core](https://legacy.curseforge.com/kerbal/ksp-mods/firespitter)
  * [Interstellar Fuel Switch Core](https://legacy.curseforge.com/kerbal/ksp-mods/interstellar-fuel-switch)
  * [Modular Fuel Tanks](http://forum.kerbalspaceprogram.com/index.php?/topic/58235-*/)
  * [SimpleFuelSwitch](https://forum.kerbalspaceprogram.com/topic/181274-*/)

### Tags

parts, flags, agency, sound

<div style="border:0.5px solid Tomato; background-color: #BADA55; color: #FF0000; text-align:center">
  <p><b>red box below is a link to forum post on how to get support</b></p>
  <a href="https://forum.kerbalspaceprogram.com/index.php?/topic/83212-*">
    <p><img src="https://i.postimg.cc/vHP6zmrw/image.png" alt="How to get support"></p></a>
  <p style="color: #000000;">Be Kind: Lithobrake, not jakebrake! Keep your Module Manager up to date</p>
</div>

### Credits and Special Thanks

* [`greystork`][greystork] for creating this glorious parts addon!
* [`Comwarrior`][comwarrior] for the picking up where [greystork][greystork] left off
* see [Attribution.md][attr] for more

### Legal Mumbo Jumbo (License *provenance*)

#### Author (1) - [`zer0Kerbal`][zer0Kerbal]

> Forum: [Thread][forum] - Source: [GitHub][GITHUB:url] - Download [CurseForge][CURSFG:url]  
> License: [![License][LIC:shd]][LIC:url] ![License][LIC:log]

#### Author (1) - Author: [`Comwarrior`][Comwarrior]

> Forum: [Thread][1:thd] - Download: [CurseForge][1:dwn] - Source: [SpaceDock][1:src]  
> License: [![License][1:shd]][1:url] ![License][1:log]

#### Original Author (ROOT) (0): [`greystork`][greystork]

> Forum: [Thread][0:thd] - Download: [CurseForge][0:dwn] - Source: [SpaceDock][0:src]  
> License: [![License][0:shd]][0:url] ![License][0:log]

#### Disclaimer(s)
>
>* ***All bundled mods are distributed under their own licenses***  
>* ***All assets, including but not limited to: animations, models, sounds and textures are distributed under their own licenses. [![License][LIC:sp:shd]][LIC:sp:url]***
>
>* see [Notices][notic] for more *legal Mumbo Jumbo*

### How to support this and other great mods by [`zer0Kerbal`][zer0Kerbal]

Comment, click, like, share, up-vote, subscribe

> ***Completely voluntary, absolutely amazing, and really does help out a lot!***  
> *and it is true.*

[![Support][PAYPAL:img]][PAYPAL:url] [![Patreon][PATREON:img]][PATREON:url]

<!-- links -->
[attr]: https://zer0kerbal.github.io/BehemothAerospaceEngineering/Attributions "Attribution"
[chlog]: https://raw.githubusercontent.com/zer0Kerbal/BehemothAerospaceEngineering/master/changelog.md  "Changelog"
[discu]: https://github.com/zer0Kerbal/BehemothAerospaceEngineering/discussions "Discussions"
[forum]: https://forum.kerbalspaceprogram.com/index.php?/topic/208327-*/ "Behemoth Aerospace Engineering (BAE) Thread"
[issue]: https://github.com/zer0Kerbal/BehemothAerospaceEngineering/issues "Issues"
[markt]: https://zer0kerbal.github.io/BehemothAerospaceEngineering/Marketing "Marketing Slicks"
[notic]: https://zer0kerbal.github.io/BehemothAerospaceEngineering/Notices "GitHub Pages"
[pages]: https://zer0kerbal.github.io/BehemothAerospaceEngineering/ "GitHub Pages"
[parts]: https://zer0kerbal.github.io/BehemothAerospaceEngineering/PartsCatalog "Parts Catalog"

<!--- shields -->
[SHD:mod]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/BehemothAerospaceEngineering/master/json/mod.json
[SHD:pgs]: https://img.shields.io/badge/GitHub-Pages-white?style=plastic&labelColor=9cf&logoColor=181717&logo=github "GitHub IO"

<!--- mod provenance -->
[1:dwn]: https://www.curseforge.com/kerbal/ksp-mods/behemothaerospaceengineering "CurseForge"
[1:src]: https://spacedock.info/mod/2109 "SpaceDock"
[1:thd]: https://forum.kerbalspaceprogram.com/index.php?/topic/182825-*/ "KSP Forum"

[0:dwn]: https://www.curseforge.com/kerbal/ksp-mods/behemothaerospaceengineering "CurseForge"
[0:src]: https://spacedock.info/mod/2109 "SpaceDock"
[0:thd]: https://forum.kerbalspaceprogram.com/index.php?/topic/111733-*/ "KSP Forum"

<!--- license provenance -->
[1:url]: https://creativecommons.org/licenses/by-nc-sa/4.0/ "CC BY-NC-SA 4.0"
[1:log]: https://licensebuttons.net/i/l/by-nc-sa/transparent/33/66/99/76x22.png "CC BY-NC-SA 4.0"
[1:shd]: https://img.shields.io/badge/License-CC%20BY--NC--SA%204.0-ef9421?labelColor=black&style=plastic&logoColor=ef9421&logo=creativecommons "CC BY-NC-SA 4.0"

[0:url]: https://creativecommons.org/licenses/by-nc-sa/4.0/ "CC BY-NC-SA 4.0"
[0:log]: https://licensebuttons.net/i/l/by-nc-sa/transparent/33/66/99/76x22.png "CC BY-NC-SA 4.0"
[0:shd]: https://img.shields.io/badge/License-CC%20BY--NC--SA%204.0-ef9421?labelColor=black&style=plastic&logoColor=ef9421&logo=creativecommons "CC BY-NC-SA 4.0"

[LIC:url]: https://creativecommons.org/licenses/by-nc-sa/4.0/ "CC BY-NC-SA 4.0"
[LIC:log]: https://licensebuttons.net/i/l/by-nc-sa/transparent/33/66/99/76x22.png "CC BY-NC-SA 4.0"
[LIC:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/BehemothAerospaceEngineering/master/json/license.json "CC BY-NC-SA 4.0"

[LIC:sp:url]: https://en.wikipedia.org/wiki/All_rights_reserved "All Rights Reserved"
[LIC:sp:shd]: https://img.shields.io/badge/License-All%20Rights%20Reserved-white?labelColor=black&style=plastic "All Rights Reserved"

<!--- release links -->
[CURSFG:url]: https://www.curseforge.com/kerbal/ksp-mods/behemothaerospaceengineering "Curseforge"
[CURSFG:shd]: https://img.shields.io/badge/CurseForge-Link-CCFF00.svg?labelColor=6441A4&style=plastic&logo=curseforge "Curseforge"

[GITHUB:url]: https://github.com/zer0Kerbal/BehemothAerospaceEngineering/ "GitHub"
[GITHUB:shd]: https://img.shields.io/badge/Github-Link-CCFF00.svg?labelColor=181717&style=plastic&logo=github "GitHub"

[KSP:url]: https://kerbalspaceprogram.com/ "Kerbal Space Program"
[KSP:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/BehemothAerospaceEngineering/master/json/ksp.json "Kerbal Space Program"

<!-- links -->  
[greystork]: https://forum.kerbalspaceprogram.com/index.php?/profile/131085-*/ "greystork"
[comwarrior]: https://forum.kerbalspaceprogram.com/index.php?/profile/101751-*/ "Comwarrior"  
[zer0Kerbal]: https://forum.kerbalspaceprogram.com/index.php?/profile/190933-*/ "zer0Kerbal"

<!-- financial support -->
[PAYPAL:img]: https://img.shields.io/badge/Buy%20me%20some%20-LFO-BADA55?style=for-the-badge&logo=paypal&labelColor=FFDD00/ "PayPal"
[PAYPAL:url]: https://www.paypal.com/donate/?hosted_button_id=DC22YHMEJREKL "PayPal"
[PATREON:img]: https://img.shields.io/badge/Patreon%20-Patreonize-FF424D?style=for-the-badge&logo=patreon/ "Patreon"
[PATREON:url]: https://www.patreon.com/zer0Kerbal/membership "Patreon"

[curseforge]: https://www.curseforge.com/members/zer0kerbal/projects
[reddit]: https://www.reddit.com/user/zer0Kerbal
[twitch]: https://www.twitch.tv/zer0kerbal
[twitter]: https://twitter.com/zer0Kerbal
[youtube]: https://www.youtube.com/@zer0Kerbal
[steam]: https://steamcommunity.com/id/zeroKerbal
[projects]: https://zer0kerbal.github.io/zer0Kerbal/projects.html

#### Connect with me

Track progress: issues [here][issue] and projects [here](https://github.com/zer0Kerbal/behemothaerospaceengineering/projects/) along with **[The Short List](https://github.com/users/zer0Kerbal/projects/27)**

[<img align="left" alt="zer0Kerbal | kerbalspaceprogram.com" width="32px" src="https://cdn.icon-icons.com/icons2/1381/PNG/32/kerbalspaceprogram_93898.png" />][zer0Kerbal] [<img align="left" alt="zer0Kerbal | CurseForge" width="32px" src="https://cdn.jsdelivr.net/npm/simple-icons@v3/icons/curseforge.svg" />][curseforge] [<img align="left" alt="zer0Kerbal | reddit" width="32px" src="https://cdn.icon-icons.com/icons2/1945/PNG/512/iconfinder-reddit-4661631_122483.png" />][reddit] [<img align="left" alt="zer0Kerbal | Patreon" width="32px" src="https://cdn.icon-icons.com/icons2/2429/PNG/512/patreon_logo_icon_147253.png" />][PATREON:url] [<img align="left" alt="zer0Kerbal | YouTube" width="32px" src="https://cdn.icon-icons.com/icons2/836/PNG/512/Youtube_icon-icons.com_66802.png" />][youtube] [<img align="left" alt="zer0Kerbal | Twitch" width="32px" src="https://cdn.icon-icons.com/icons2/2699/PNG/512/twitch_logo_icon_170383.png" />][twitch] [<img align="left" alt="zer0Kerbal | PayPal" width="32px" src="https://cdn.icon-icons.com/icons2/2699/PNG/512/paypal_logo_icon_168055.png" />][PAYPAL:url] [<img align="left" alt="zer0Kerbal | steam" width="32px" src="https://icons.iconarchive.com/icons/3xhumed/mega-games-pack-05/48/Steam-icon.png" />][steam] [<img align="left" alt="zer0Kerbal | Twitter" width="32px" src="https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/master/img/twitter-32.ico" />][twitter] [<img align="left" alt="zer0Kerbal | project list" width="32px" src="https://www.pngall.com/wp-content/uploads/5/Vector-Checklist-PNG-HD-Image-180x180.png" />][projects]</br>