# Generated by Django 2.2.3 on 2019-09-25 02:55

from django.db import migrations


def convert_probe_source(apps, schema_editor):
    ProbeSource = apps.get_model("probes", "ProbeSource")
    for ps in ProbeSource.objects.all():
        old_payload_filters = ps.body.get("filters", {}).get("payload", [])
        if not old_payload_filters:
            continue
        new_payload_filters = []
        for old_payload_filter in old_payload_filters:
            new_payload_filters.append(
                {k: {"operator": "IN", "values": v}
                 for k, v in old_payload_filter.items()}
            )
        ps.body["filters"]["payload"] = new_payload_filters
        ps.save()


class Migration(migrations.Migration):

    dependencies = [
        ('probes', '0009_auto_20161212_1358'),
    ]

    operations = [
        migrations.RunPython(convert_probe_source),
    ]
