# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2016-11-29 17:33
from __future__ import unicode_literals

from django.db import migrations
from zentral.core.probes import probe_classes


def load_probe(probe_source):
    probe_cls = probe_classes.get(probe_source.model)
    if not probe_cls:
        probe_cls = probe_classes.get("BaseProbe")
    return probe_cls(probe_source)


def deactivate_bad_probe_sources(apps, schema_editor):
    ProbeSource = apps.get_model("probes", "ProbeSource")
    for ps in ProbeSource.objects.all():
        p = load_probe(ps)
        if not p.loaded:
            ps.status = "INACTIVE"
            ps.save()
            print("PROBE", ps.name, "set to INACTIVE:", "SYNTAX ERROR")


class Migration(migrations.Migration):

    dependencies = [
        ('probes', '0009_auto_20161127_1928'),
    ]

    operations = [
        migrations.RunPython(deactivate_bad_probe_sources),
    ]
