# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2016-11-27 19:28
from __future__ import unicode_literals

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import json
import yaml


def convert_probe_source(apps, schema_editor):
    ProbeSource = apps.get_model("probes", "ProbeSource")
    for ps in ProbeSource.objects.all():
        # fix model
        ps.model = ps.model.split(".")[-1]
        # fix osquery model
        ps.model = ps.model.replace("OSQ", "Osq")
        # fix body
        probe_d = yaml.load(ps.body)
        # fix inventory filters
        for inventory_filter in probe_d.get("filters", {}).get("inventory", []):
            mf_mbu = inventory_filter.pop("business_units", None)
            if mf_mbu:
                if not isinstance(mf_mbu, list):
                    mf_mbu = [mf_mbu]
                inventory_filter["meta_business_unit_ids"] = mf_mbu
            mf_tag = inventory_filter.pop("tags", None)
            if mf_tag:
                if not isinstance(mf_tag, list):
                    mf_tag = [mf_tag]
                inventory_filter["tag_ids"] = mf_tag
        # fix payload filters
        for payload_filter in probe_d.get("filters", {}).get("payload", []):
            for k, v in list(payload_filter.items()):
                if not isinstance(v, list):
                    payload_filter[k] = [v]
        # fix metadata filters
        for metadata_filter in probe_d.get("filters", {}).get("metadata", []):
            mf_type = metadata_filter.pop("type", None)
            if mf_type:
                metadata_filter["event_types"] = mf_type
            mf_tags = metadata_filter.pop("tags", None)
            if mf_tags:
                metadata_filter["event_tags"] = mf_tags
        if ps.model == "OsqueryProbe":
            probe_d["queries"] = []
            for q in probe_d.pop("osquery", {}).pop("schedule", []):
                for k, v in list(q.items()):
                    if (v == "") or (v is None):
                        del q[k]
                probe_d["queries"].append(q)
        elif ps.model == "OsqueryComplianceProbe":
            oc = probe_d.pop("osquery_compliance", {})
            fc = oc.pop("file_checksums", [])
            if fc:
                probe_d["file_checksums"] = fc
            pf = oc.pop("preference_files", [])
            if pf:
                probe_d["preference_files"] = pf
        elif ps.model == "MunkiInstallProbe":
            ps.model = "BaseProbe"
        elif ps.model == "OsqueryDistributedQueryProbe":
            probe_d["distributed_query"] = probe_d.pop("osquery_distributed_query")
        elif ps.model == "OsqueryFIMProbe":
            probe_d["file_paths"] = probe_d.pop("osquery_fim", [])
        elif ps.model == "SantaProbe":
            probe_d["rules"] = probe_d.pop("santa", [])
        # serialize body as json
        ps.body = json.dumps(probe_d)
        ps.save()


class Migration(migrations.Migration):

    dependencies = [
        ('probes', '0008_auto_20161111_1906'),
    ]

    operations = [
        migrations.RunPython(convert_probe_source),
        migrations.CreateModel(
            name='Feed',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField()),
                ('name', models.TextField()),
                ('description', models.TextField(blank=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='FeedImport',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('OK', 'OK'),
                                                     ('DOWNLOAD_ERROR', 'download error'),
                                                     ('FEED_ERROR', 'feed error')], max_length=32)),
                ('new_probes', models.PositiveIntegerField(default=0)),
                ('updated_probes', models.PositiveIntegerField(default=0)),
                ('archived_probes', models.PositiveIntegerField(default=0)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('feed', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='probes.Feed')),
            ],
        ),
        migrations.CreateModel(
            name='FeedProbe',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model', models.CharField(max_length=255)),
                ('key', models.CharField(max_length=255)),
                ('body', django.contrib.postgres.fields.jsonb.JSONField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('archived_at', models.DateTimeField(blank=True, null=True)),
                ('feed', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='probes.Feed')),
            ],
        ),
        migrations.RemoveField(
            model_name='probesource',
            name='apps',
        ),
        migrations.AlterField(
            model_name='probesource',
            name='body',
            field=django.contrib.postgres.fields.jsonb.JSONField(editable=False),
        ),
        migrations.AlterUniqueTogether(
            name='feedprobe',
            unique_together=set([('feed', 'key')]),
        ),
    ]
