# -*- coding: utf-8 -*-
# Generated by Django 1.10.2 on 2016-11-04 13:43
from __future__ import unicode_literals

from django.db import migrations
import yaml
from zentral.core.events import event_types as available_event_types


def set_probe_source_apps_event_type_model(apps, schema_editor):
    ProbeSource = apps.get_model("probes", "ProbeSource")
    for ps in ProbeSource.objects.all():
        probe_d = yaml.load(ps.body)
        ps.event_types = []
        if "santa" in probe_d:
            ps.model = "SantaProbe"
            ps.event_types.append("santa_event")
        elif "osquery" in probe_d:
            if isinstance(probe_d["osquery"], dict) and probe_d["osquery"].get("file_categories"):
                ps.model = "OsqueryFIMProbe"
            else:
                ps.model = "OsqueryProbe"
            ps.event_types.append("osquery_result")
        else:
            ps.model = "BaseProbe"
            for metadata_filter in probe_d.get("filters", {}).get("metadata", []):
                mf_type = metadata_filter.get("type", [])
                if isinstance(mf_type, str):
                    mf_type = [mf_type]
                for t in mf_type:
                    if t in available_event_types and t not in ps.event_types:
                        ps.event_types.append(t)
        ps.apps = []
        ps.event_types.sort()
        ps.save()


class Migration(migrations.Migration):

    dependencies = [
        ('probes', '0005_auto_20161104_1343'),
    ]

    operations = [
        migrations.RunPython(set_probe_source_apps_event_type_model),
    ]
