# -*- coding: utf-8 -*-
# Generated by Django 1.10.2 on 2016-11-03 17:28
from __future__ import unicode_literals

from django.db import migrations
import yaml


def migrate_file_paths(apps, schema_editor):
    ProbeSource = apps.get_model("probes", "ProbeSource")
    for ps in ProbeSource.objects.filter(body__icontains="file_paths"):
        def func(probe_d):
            osquery_d = probe_d.get("osquery", {})
            if not osquery_d:
                return
            file_paths = osquery_d.pop("file_paths", {})
            file_categories = osquery_d.get("file_categories", {})
            for file_path_name, paths in file_paths.items():
                if file_path_name not in file_categories:
                    file_categories[file_path_name] = {"paths": paths,
                                                       "file_access": False}
        try:
            probe_d = yaml.load(ps.body)
            func(probe_d)
            ps.body = yaml.safe_dump(probe_d,
                                     default_flow_style=False,
                                     default_style='')
            ps.save()
        except:
            pass


class Migration(migrations.Migration):

    dependencies = [
        ('probes', '0003_auto_20160604_0908'),
    ]

    operations = [
        migrations.RunPython(migrate_file_paths),
    ]
