# Generated by Django 2.2.24 on 2021-12-01 12:24

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models


def set_incident_defaults(apps, schema_editor):
    Incident = apps.get_model("incidents", "Incident")
    for incident in Incident.objects.all():
        incident.incident_type = "probe"
        incident.key = {"probe_pk": incident.probe_source_id or 0}
        incident.status_time = incident.updated_at
        incident.save()
    MachineIncident = apps.get_model("incidents", "MachineIncident")
    for machine_incident in MachineIncident.objects.all():
        machine_incident.status_time = machine_incident.updated_at
        machine_incident.save()


class Migration(migrations.Migration):

    dependencies = [
        ('incidents', '0001_initial'),
    ]

    operations = [
        # remove legacy constraint
        migrations.RemoveConstraint(
            model_name='incident',
            name='one_open_incident_per_probe',
        ),
        # remove legacy fields
        migrations.RemoveField(
            model_name='incident',
            name='description',
        ),
        migrations.RemoveField(
            model_name='incident',
            name='event_id',
        ),
        migrations.RemoveField(
            model_name='incident',
            name='name',
        ),
        # add the new unique fields
        migrations.AddField(
            model_name='incident',
            name='incident_type',
            field=models.CharField(editable=False, max_length=256, null=True),
        ),
        migrations.AddField(
            model_name='incident',
            name='key',
            field=django.contrib.postgres.fields.jsonb.JSONField(editable=False, null=True),
        ),
        # add status time
        migrations.AddField(
            model_name='incident',
            name='status_time',
            field=models.DateTimeField(null=True),
        ),
        # machine incident, remove event_id, add status_time
        migrations.RemoveField(
            model_name='machineincident',
            name='event_id',
        ),
        migrations.AddField(
            model_name='machineincident',
            name='status_time',
            field=models.DateTimeField(null=True),
        ),
        # set default values for the new fields
        migrations.RunPython(set_incident_defaults),
        # remove optional foreign key to probe source
        migrations.RemoveField(
            model_name='incident',
            name='probe_source',
        ),
        # make new fields mandatory
        migrations.AlterField(
            model_name='incident',
            name='incident_type',
            field=models.CharField(max_length=256),
        ),
        migrations.AlterField(
            model_name='incident',
            name='key',
            field=django.contrib.postgres.fields.jsonb.JSONField(),
        ),
        migrations.AlterField(
            model_name='incident',
            name='status_time',
            field=models.DateTimeField(),
        ),
        migrations.AlterField(
            model_name='machineincident',
            name='status_time',
            field=models.DateTimeField(),
        ),
        # add new index
        migrations.AddIndex(
            model_name='incident',
            index=models.Index(fields=['incident_type', 'key'], name='incidents_i_inciden_3d0004_idx'),
        ),
        # add new constraint
        migrations.AddConstraint(
            model_name='incident',
            constraint=models.UniqueConstraint(
                condition=models.Q(status__in={'REOPENED', 'OPEN', 'IN_PROGRESS'}),
                fields=('incident_type', 'key'),
                name='one_open_incident_per_incident_type_and_key'),
        ),
    ]
