# Generated by Django 2.2 on 2019-04-19 19:14

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('probes', '0009_auto_20161212_1358'),
    ]

    operations = [
        migrations.CreateModel(
            name='Incident',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.TextField()),
                ('description', models.TextField(blank=True)),
                ('severity', models.PositiveIntegerField(choices=[(300, 'Critical'), (200, 'Major'), (100, 'Minor')])),
                ('status', models.CharField(choices=[('OPEN', 'Open'), ('IN_PROGRESS', 'In Progress'), ('RESOLVED', 'Resolved'), ('CLOSED', 'Closed'), ('REOPENED', 'Reopened')], max_length=64)),
                ('event_id', models.UUIDField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('probe_source', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='probes.ProbeSource')),
            ],
            options={
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='MachineIncident',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('serial_number', models.TextField(db_index=True)),
                ('status', models.CharField(choices=[('OPEN', 'Open'), ('IN_PROGRESS', 'In Progress'), ('RESOLVED', 'Resolved'), ('CLOSED', 'Closed'), ('REOPENED', 'Reopened')], max_length=64)),
                ('event_id', models.UUIDField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('incident', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='incidents.Incident')),
            ],
            options={
                'ordering': ('-created_at',),
            },
        ),
        migrations.AddConstraint(
            model_name='machineincident',
            constraint=models.UniqueConstraint(condition=models.Q(status__in={'OPEN', 'IN_PROGRESS', 'REOPENED'}), fields=('incident', 'serial_number'), name='one_open_machine_incident_per_incident'),
        ),
        migrations.AddConstraint(
            model_name='incident',
            constraint=models.UniqueConstraint(condition=models.Q(status__in={'OPEN', 'IN_PROGRESS', 'REOPENED'}), fields=('probe_source',), name='one_open_incident_per_probe'),
        ),
    ]
