# Generated by Django 2.2.24 on 2021-12-20 20:17

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ComplianceCheck',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model', models.CharField(editable=False, max_length=256)),
                ('name', models.TextField()),
                ('description', models.TextField(blank=True)),
                ('version', models.PositiveIntegerField(default=1, editable=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'unique_together': {('model', 'name')},
            },
        ),
        migrations.CreateModel(
            name='MachineStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('compliance_check_version', models.PositiveIntegerField()),
                ('serial_number', models.TextField()),
                ('status', models.PositiveSmallIntegerField(choices=[(0, 'OK'), (200, 'Unknown'), (300, 'Failed')])),
                ('status_time', models.DateTimeField()),
                ('previous_status', models.PositiveSmallIntegerField(
                    choices=[(0, 'OK'), (200, 'Unknown'), (300, 'Failed')], null=True)),
                ('compliance_check', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE, to='compliance_checks.ComplianceCheck')),
            ],
            options={
                'unique_together': {('compliance_check', 'serial_number')},
            },
        ),
    ]
