# Generated by Django 4.2.16 on 2024-11-05 14:43

from django.db import migrations, models


def update_is_voting_rule(apps, schema_editor):
    Configuration = apps.get_model("santa", "Configuration")
    Vote = apps.get_model("santa", "Vote")
    for configuration in Configuration.objects.all():
        oldest_vote = Vote.objects.filter(configuration=configuration).order_by("created_at").first()
        if not oldest_vote:
            continue
        for rule in configuration.rule_set.select_related("target").all():
            if rule.created_at < oldest_vote.created_at:
                continue
            vote_targets = {rule.target}
            if hasattr(rule.target, "parent_metabundle"):
                vote_targets.update(mb.target for mb in rule.target.parent_metabundle.select_related("target").all())
            elif hasattr(rule.target, "parent_bundle"):
                vote_targets.update(b.target for b in rule.target.parent_bundle.select_related("target").all())
            if Vote.objects.filter(ballot__target__in=vote_targets,
                                   configuration=configuration).exists():
                rule.is_voting_rule = True
                rule.save()


class Migration(migrations.Migration):

    dependencies = [
        ('santa', '0037_configuration_banned_threshold_and_more'),
    ]

    operations = [
        migrations.AddField(
            model_name='rule',
            name='is_voting_rule',
            field=models.BooleanField(default=False, editable=False),
        ),
        migrations.RunPython(update_is_voting_rule),
    ]
