# Generated by Django 4.2.15 on 2024-08-27 08:36

import django.contrib.postgres.fields
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import uuid


def create_metabundles(apps, schema_editor):
    try:
        from zentral.contrib.santa.utils import update_metabundles
    except ImportError:
        return
    update_metabundles()


def flatten_bundle_rules(apps, schema_editor):
    Rule = apps.get_model("santa", "Rule")
    rules_to_delete = []
    for rule in Rule.objects.filter(target__type="BUNDLE"):
        rules_to_delete.append(rule.pk)
        for binary_target in list(rule.target.bundle.binary_targets.all()):
            rule.pk = None
            rule.target = binary_target
            rule.save()
    Rule.objects.filter(pk__in=rules_to_delete).delete()


class Migration(migrations.Migration):

    dependencies = [
        ("realms", "0011_realm_user_portal_alter_realm_enabled_for_login"),
        ("santa", "0036_remove_target_blocked_count_and_more"),
    ]

    operations = [
        migrations.AddField(
            model_name="configuration",
            name="banned_threshold",
            field=models.IntegerField(
                blank=True, default=-26,
                help_text="Voting score (-1000 → -1) at which a target is banned",
                validators=[
                    django.core.validators.MinValueValidator(-1000),
                    django.core.validators.MaxValueValidator(-1),
                ],
            ),
        ),
        migrations.AddField(
            model_name="configuration",
            name="default_ballot_target_types",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(
                    choices=[
                        ("TEAMID", "Team ID"),
                        ("CERTIFICATE", "Certificate"),
                        ("METABUNDLE", "MetaBundle"),
                        ("BUNDLE", "Bundle"),
                        ("SIGNINGID", "Signing ID"),
                        ("BINARY", "Binary"),
                        ("CDHASH", "cdhash"),
                    ],
                    max_length=16,
                ),
                blank=True,
                default=list,
                help_text="List of the target types users have the permission to vote on by default",
                size=None,
            ),
        ),
        migrations.AddField(
            model_name="configuration",
            name="default_voting_weight",
            field=models.PositiveIntegerField(
                blank=True, default=0, help_text="Default users voting weight"
            ),
        ),
        migrations.AddField(
            model_name="configuration",
            name="globally_allowlisted_threshold",
            field=models.IntegerField(
                blank=True, default=50,
                help_text="Voting score (1 → 1000) at which a target is allowlisted "
                          "for all the devices enrolled in the configuration",
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(1000),
                ],
            ),
        ),
        migrations.AddField(
            model_name="configuration",
            name="partially_allowlisted_threshold",
            field=models.IntegerField(
                blank=True, default=5,
                help_text="Voting score (1 → 1000) at which a target is allowlisted "
                          "for the users having requested an exception",
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(1000),
                ],
            ),
        ),
        migrations.AddField(
            model_name="configuration",
            name="voting_realm",
            field=models.ForeignKey(
                blank=True,
                help_text="Realm used to authenticate the users of the exception portal",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="realms.realm",
            ),
        ),
        migrations.AlterField(
            model_name="machinerule",
            name="policy",
            field=models.PositiveSmallIntegerField(
                choices=[
                    (1, "Allowlist"),
                    (2, "Blocklist"),
                    (3, "Silent blocklist"),
                    (4, "Remove"),
                    (5, "Allowlist compiler"),
                ]
            ),
        ),
        migrations.AlterField(
            model_name="target",
            name="type",
            field=models.CharField(
                choices=[
                    ("TEAMID", "Team ID"),
                    ("CERTIFICATE", "Certificate"),
                    ("METABUNDLE", "MetaBundle"),
                    ("BUNDLE", "Bundle"),
                    ("SIGNINGID", "Signing ID"),
                    ("BINARY", "Binary"),
                    ("CDHASH", "cdhash"),
                ],
                max_length=16,
            ),
        ),
        migrations.CreateModel(
            name="MetaBundle",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "signing_id_targets",
                    models.ManyToManyField(
                        related_name="parent_metabundle", to="santa.target"
                    ),
                ),
                (
                    "target",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT, to="santa.target"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Ballot",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("user_uid", models.CharField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "event_target",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="santa.target",
                    ),
                ),
                (
                    "realm_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="realms.realmuser",
                    ),
                ),
                (
                    "replaced_by",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="santa.ballot",
                    ),
                ),
                (
                    "target",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="santa.target"
                    ),
                ),
            ],
            options={
                "unique_together": {
                    ("target", "realm_user", "user_uid", "replaced_by")
                },
            },
        ),
        migrations.AddField(
            model_name="bundle",
            name="metabundle",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="santa.metabundle",
            ),
        ),
        migrations.CreateModel(
            name="VotingGroup",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("can_unflag_target", models.BooleanField(default=False)),
                ("can_mark_malware", models.BooleanField(default=False)),
                ("can_reset_target", models.BooleanField(default=False)),
                (
                    "ballot_target_types",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(
                            choices=[
                                ("TEAMID", "Team ID"),
                                ("CERTIFICATE", "Certificate"),
                                ("METABUNDLE", "MetaBundle"),
                                ("BUNDLE", "Bundle"),
                                ("SIGNINGID", "Signing ID"),
                                ("BINARY", "Binary"),
                                ("CDHASH", "cdhash"),
                            ],
                            max_length=16,
                        ),
                        size=None,
                    ),
                ),
                ("voting_weight", models.PositiveIntegerField(default=1)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "configuration",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="santa.configuration",
                    ),
                ),
                (
                    "realm_group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="realms.realmgroup",
                    ),
                ),
            ],
            options={
                "unique_together": {("configuration", "realm_group")},
            },
        ),
        migrations.CreateModel(
            name="Vote",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("was_yes_vote", models.BooleanField()),
                ("weight", models.PositiveIntegerField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "ballot",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="santa.ballot"
                    ),
                ),
                (
                    "configuration",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="santa.configuration",
                    ),
                ),
            ],
            options={
                "unique_together": {("ballot", "configuration")},
            },
        ),
        migrations.CreateModel(
            name="TargetState",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("flagged", models.BooleanField(default=False)),
                (
                    "state",
                    models.IntegerField(
                        choices=[
                            (-100, "Banned"),
                            (-50, "Suspect"),
                            (0, "Untrusted"),
                            (50, "Partially Allowlisted"),
                            (100, "Globally Allowlisted"),
                        ],
                        default=0,
                    ),
                ),
                ("score", models.IntegerField(default=0)),
                ("reset_at", models.DateTimeField(null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "configuration",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="santa.configuration",
                    ),
                ),
                (
                    "target",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="santa.target"
                    ),
                ),
            ],
            options={
                "unique_together": {("target", "configuration")},
            },
        ),
        migrations.RunPython(create_metabundles),
        migrations.RunPython(flatten_bundle_rules),
    ]
