# Generated by Django 2.2.27 on 2022-02-07 21:12

import django.contrib.postgres.fields
import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('santa', '0026_configuration_allow_unknown_shard'),
    ]

    operations = [
        migrations.RenameField(
            model_name='target',
            old_name='sha256',
            new_name='identifier',
        ),
        migrations.AddField(
            model_name='configuration',
            name='block_usb_mass_storage',
            field=models.BooleanField(
                default=False,
                help_text='If set, blocking USB Mass storage feature is enabled.'
            ),
        ),
        migrations.AddField(
            model_name='configuration',
            name='remount_usb_mode',
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=16, validators=[django.core.validators.MinLengthValidator(2)]),
                blank=True, default=list, size=None
            ),
        ),
        migrations.AlterField(
            model_name='target',
            name='type',
            field=models.CharField(
                choices=[('BINARY', 'Binary'),
                         ('BUNDLE', 'Bundle'),
                         ('CERTIFICATE', 'Certificate'),
                         ('TEAMID', 'Team ID')],
                max_length=16
            ),
        ),
        migrations.AlterUniqueTogether(
            name='target',
            unique_together={('type', 'identifier')},
        ),
        migrations.AddField(
            model_name='enrolledmachine',
            name='teamid_rule_count',
            field=models.IntegerField(null=True),
        ),
    ]
