# Generated by Django 2.2.24 on 2021-11-11 08:49

import django.core.validators
from django.db import migrations, models
from django.db.models import Count


def add_shard_to_no_rule_configurations(apps, schema_editor):
    Configuration = apps.get_model("santa", "Configuration")
    for configuration in Configuration.objects.annotate(num_rules=Count('rule')).filter(num_rules=0):
        configuration.allow_unknown_shard = 5
        configuration.save()


class Migration(migrations.Migration):

    dependencies = [
        ('santa', '0025_auto_20210921_1517'),
    ]

    operations = [
        migrations.AddField(
            model_name='configuration',
            name='allow_unknown_shard',
            field=models.IntegerField(
                default=100,
                help_text="Restrict the reporting of 'Allow Unknown' events to a percentage (0-100) of hosts",
                validators=[django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100)]
            ),
        ),
        migrations.RunPython(add_shard_to_no_rule_configurations),
    ]
