# Generated by Django 2.2.17 on 2021-01-21 17:45

from django.db import migrations


POLICY_DICT = {
    "BLACKLIST": 2,
    "WHITELIST": 1,
    "SILENT_BLACKLIST": 3,
}


def convert_santa_probes(apps, schema_editor):
    ProbeSource = apps.get_model("probes", "ProbeSource")
    Tag = apps.get_model("inventory", "Tag")
    Configuration = apps.get_model("santa", "Configuration")
    Rule = apps.get_model("santa", "Rule")
    Target = apps.get_model("santa", "Target")
    configurations = list(Configuration.objects.all())
    if not configurations:
        return
    for ps in ProbeSource.objects.filter(model="SantaProbe", status="ACTIVE"):
        body = ps.body
        if not body:
            continue
        rules = body.get("rules", [])
        if not rules:
            continue
        tag_ids = set([])
        for inv_filter in body.get("filters", {}).get("inventory", []):
            for tag_id in inv_filter.get("tag_ids", []):
                tag_ids.add(tag_id)
        tags = []
        if tag_ids:
            tags = list(Tag.objects.filter(pk__in=tag_ids))
        for rule in rules:
            policy = rule.get("policy")
            if policy == "REMOVE":
                continue
            defaults = {}
            try:
                defaults["policy"] = POLICY_DICT[policy]
            except KeyError:
                continue
            custom_msg = rule.get("custom_msg")
            if custom_msg:
                defaults["custom_msg"] = custom_msg
            else:
                defaults["custom_msg"] = ""
            target_type = rule.get("rule_type")
            if target_type not in ("CERTIFICATE", "BINARY"):
                continue
            sha256 = rule.get("sha256")
            if not sha256:
                continue
            target, _ = Target.objects.get_or_create(type=target_type, sha256=sha256)
            for configuration in configurations:
                r, _ = Rule.objects.update_or_create(configuration=configuration,
                                                     target=target,
                                                     defaults=defaults)
                for tag in tags:
                    r.tags.add(tag)
    ProbeSource.objects.filter(model="SantaProbe").delete()


class Migration(migrations.Migration):

    dependencies = [
        ('santa', '0021_delete_collectedapplication'),
    ]

    operations = [
        migrations.RunPython(convert_santa_probes),
    ]
