# Generated by Django 2.2.17 on 2021-01-19 16:49

from django.db import migrations, models


def update_enrolled_machine_client_mode(apps, schema_editor):
    EnrolledMachine = apps.get_model("santa", "EnrolledMachine")
    for em in EnrolledMachine.objects.all():
        em.client_mode = em.enrollment.configuration.client_mode
        em.save()


class Migration(migrations.Migration):

    dependencies = [
        ('santa', '0019_bundle_machinerule_rule_ruleset_target'),
    ]

    operations = [
        migrations.AddField(
            model_name='enrolledmachine',
            name='client_mode',
            field=models.IntegerField(choices=[(1, 'Monitor'), (2, 'Lockdown')], null=True),
        ),
        migrations.AddField(
            model_name='enrolledmachine',
            name='primary_user',
            field=models.TextField(null=True),
        ),
        migrations.AddField(
            model_name='enrolledmachine',
            name='santa_version',
            field=models.TextField(default='Unknown'),
            preserve_default=False,
        ),
        migrations.RunPython(update_enrolled_machine_client_mode),
        migrations.AlterField(
            model_name='enrolledmachine',
            name='client_mode',
            field=models.IntegerField(choices=[(1, 'Monitor'), (2, 'Lockdown')], null=False),
        ),
    ]
