# Generated by Django 2.2.27 on 2022-02-24 23:04

import django.contrib.postgres.fields
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('inventory', '0066_jmespathcheck_platforms'),
    ]

    operations = [
        migrations.CreateModel(
            name='Instance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(verbose_name="URL", help_text='PuppetDB base URL', unique=True)),
                ('ca_chain', models.TextField(
                    verbose_name="CA chain",
                    help_text='Puppet CA chain (PEM). Used to verify the PuppetDB certificate')),
                ('rbac_token', models.TextField(editable=False)),
                ('cert', models.TextField(blank=True,
                                          verbose_name="Client certificate",
                                          help_text='Client certificate (PEM) to authenticate with PuppetDB')),
                ('key', models.TextField(editable=False)),
                ('timeout', models.IntegerField(default=10,
                                                verbose_name="Requests timeout",
                                                help_text='Timeout in seconds (1→30) used for the PuppetDB requests',
                                                validators=[django.core.validators.MinValueValidator(1),
                                                            django.core.validators.MaxValueValidator(30)])),
                ('group_fact_keys', django.contrib.postgres.fields.ArrayField(
                    base_field=models.CharField(
                        max_length=256,
                        validators=[django.core.validators.MinLengthValidator(1)]
                    ),
                    blank=True, default=list,
                    help_text='Comma separated list of the group facts to collect', size=None)),
                ('extra_fact_keys', django.contrib.postgres.fields.ArrayField(
                    base_field=models.CharField(
                        max_length=256,
                        validators=[django.core.validators.MinLengthValidator(1)]
                    ),
                    blank=True, default=list,
                    help_text='Comma separated list of the extra facts to collect', size=None)),
                ('puppetboard_url', models.URLField(verbose_name="PuppetBoard URL", blank=True)),
                ('deb_packages_shard', models.IntegerField(
                    default=100,
                    verbose_name="Debian packages shard",
                    help_text='Restrict the collection of Debian packages to a percentage (0→100) of hosts',
                    validators=[django.core.validators.MinValueValidator(0),
                                django.core.validators.MaxValueValidator(100)])),
                ('programs_shard', models.IntegerField(
                    default=100,
                    verbose_name="Windows programs shard",
                    help_text='Restrict the collection of Windows programs to a percentage (0→100) of hosts',
                    validators=[django.core.validators.MinValueValidator(0),
                                django.core.validators.MaxValueValidator(100)])),
                ('report_processor_token', models.TextField(editable=False)),
                ('version', models.PositiveIntegerField(editable=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('business_unit', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT,
                                                    related_name='+', to='inventory.BusinessUnit')),
            ],
        ),
    ]
