# Generated by Django 2.2.18 on 2021-03-23 18:44

import django.contrib.postgres.fields
import django.core.validators
from django.db import migrations, models
from django.db.models import F


def update_osquery_queries(apps, schema_editor):
    Pack = apps.get_model("osquery", "Pack")

    for pack in Pack.objects.all():
        for packquery in pack.packquery_set.all():
            platforms = packquery.platforms or pack.platforms
            minimum_osquery_version = packquery.minimum_osquery_version or pack.minimum_osquery_version
            if platforms or minimum_osquery_version:
                packquery.query.platforms = platforms
                packquery.query.minimum_osquery_version = minimum_osquery_version
                packquery.query.version = F("version") + 1
                packquery.query.save()


def update_osquery_enrolled_machine_platform_mask(apps, schema_editor):
    try:
        from zentral.contrib.inventory.models import MetaMachine
        from zentral.contrib.inventory.conf import LINUX, MACOS, WINDOWS
    except ImportError:
        pass
    EnrolledMachine = apps.get_model("osquery", "EnrolledMachine")
    for enrolled_machine in EnrolledMachine.objects.all():
        mm = MetaMachine(enrolled_machine.serial_number)
        if mm.platform:
            if mm.platform == LINUX:
                enrolled_machine.platform_mask = 0x01 | 0x08
            elif mm.platform == MACOS:
                enrolled_machine.platform_mask = 0x01 | 0x04 | 0x10
            elif mm.platform == WINDOWS:
                enrolled_machine.platform_mask = 0x02
            else:
                print("Unsupported osquery enrolled machine platform", mm.platform)
                continue
            enrolled_machine.save()


class Migration(migrations.Migration):

    dependencies = [
        ('osquery', '0007_auto_20210215_2159'),
    ]

    operations = [
        migrations.AddField(
            model_name='distributedquery',
            name='minimum_osquery_version',
            field=models.CharField(
                editable=False, max_length=14, null=True,
                validators=[django.core.validators.RegexValidator('^[0-9]{1,4}\\.[0-9]{1,4}\\.[0-9]{1,4}(\\.[0-9]{1,4})?$')]
            ),
        ),
        migrations.AddField(
            model_name='distributedquery',
            name='platforms',
            field=django.contrib.postgres.fields.ArrayField(base_field=models.CharField(choices=[('darwin', 'darwin'), ('freebsd', 'freebsd'), ('linux', 'linux'), ('posix', 'posix'), ('windows', 'windows')], max_length=32), default=list, editable=False, size=None),
        ),
        migrations.AddField(
            model_name='query',
            name='minimum_osquery_version',
            field=models.CharField(
                blank=True,
                help_text='This query will only execute on osquery versions greater than or equal-to this version string',
                max_length=14, null=True,
                validators=[django.core.validators.RegexValidator('^[0-9]{1,4}\\.[0-9]{1,4}\\.[0-9]{1,4}(\\.[0-9]{1,4})?$')]
            ),
        ),
        migrations.AddField(
            model_name='query',
            name='platforms',
            field=django.contrib.postgres.fields.ArrayField(base_field=models.CharField(choices=[('darwin', 'darwin'), ('freebsd', 'freebsd'), ('linux', 'linux'), ('posix', 'posix'), ('windows', 'windows')], max_length=32), blank=True, default=list, help_text="Restrict this query to some platforms, default is 'all' platforms", size=None),
        ),
        migrations.RunPython(update_osquery_queries),
        migrations.RemoveField(
            model_name='pack',
            name='minimum_osquery_version',
        ),
        migrations.RemoveField(
            model_name='pack',
            name='platforms',
        ),
        migrations.RemoveField(
            model_name='packquery',
            name='minimum_osquery_version',
        ),
        migrations.RemoveField(
            model_name='packquery',
            name='platforms',
        ),
        migrations.AddField(
            model_name='enrolledmachine',
            name='platform_mask',
            field=models.PositiveSmallIntegerField(default=0),
        ),
        migrations.RunPython(update_osquery_enrolled_machine_platform_mask),
    ]
