# Generated by Django 4.1.12 on 2023-10-20 17:00

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('inventory', '0077_file_signing_id'),
        ('compliance_checks', '0001_initial'),
        ('munki', '0011_configuration_description'),
    ]

    operations = [
        migrations.AddField(
            model_name='configuration',
            name='script_checks_run_interval_seconds',
            field=models.IntegerField(default=86400,
                                      validators=[django.core.validators.MinValueValidator(3600),
                                                  django.core.validators.MaxValueValidator(604800)],
                                      verbose_name='Script checks run interval in seconds'),
        ),
        migrations.AddField(
            model_name='munkistate',
            name='last_script_checks_run',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.CreateModel(
            name='ScriptCheck',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('arch_amd64', models.BooleanField(default=True, verbose_name='Run on Intel architecture')),
                ('arch_arm64', models.BooleanField(default=True, verbose_name='Run on Apple Silicon architecture')),
                ('min_os_version', models.CharField(blank=True, max_length=32)),
                ('max_os_version', models.CharField(blank=True, max_length=32)),
                ('type', models.CharField(choices=[('ZSH_STR', 'ZSH script with string result'),
                                                   ('ZSH_INT', 'ZSH script with integer result'),
                                                   ('ZSH_BOOL', 'ZSH script with boolean result')],
                                          default='ZSH_STR', max_length=32)),
                ('source', models.TextField()),
                ('expected_result', models.TextField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('compliance_check', models.OneToOneField(editable=False,
                                                          on_delete=django.db.models.deletion.CASCADE,
                                                          related_name='script_check',
                                                          to='compliance_checks.compliancecheck')),
                ('tags', models.ManyToManyField(blank=True, to='inventory.tag')),
            ],
        ),
    ]
