# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2018-05-31 10:05
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('inventory', '0037_auto_20180213_1407'),
        ('munki', '0003_auto_20151213_1521'),
    ]

    operations = [
        migrations.CreateModel(
            name='EnrolledMachine',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('serial_number', models.TextField(db_index=True)),
                ('token', models.CharField(max_length=64, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='Enrollment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.PositiveSmallIntegerField(default=1, editable=False)),
                ('distributor_pk', models.PositiveIntegerField(editable=False, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('distributor_content_type', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='contenttypes.ContentType')),
                ('secret', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE,
                                                related_name='%(app_label)s_%(class)s',
                                                to='inventory.enrollmentsecret')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='enrolledmachine',
            name='enrollment',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='munki.Enrollment'),
        ),
        migrations.AlterUniqueTogether(
            name='enrollment',
            unique_together=set([('distributor_content_type', 'distributor_pk')]),
        ),
    ]
