# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2018-05-30 08:41
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('inventory', '0037_auto_20180213_1407'),
        ('monolith', '0033_auto_20180522_1743'),
    ]

    operations = [
        migrations.CreateModel(
            name='Configuration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, unique=True)),
                ('no_restart', models.BooleanField(default=False, help_text='Remove the launchd package restart requirement')),
                ('depnotify_release', models.CharField(blank=True, help_text='Choose a DEPNotify release to be installed', max_length=64)),
                ('depnotify_commands', models.TextField(blank=True, help_text='Configure DEPNotify with some commands')),
                ('eula', models.TextField(blank=True, help_text='This text will be displayed in DEPNotify, and the user will be asked to accept it')),
                ('setup_script', models.TextField(blank=True, help_text='A script that will be run when this enrollment package is installed')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='EnrolledMachine',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('serial_number', models.TextField(db_index=True)),
                ('token', models.CharField(max_length=64, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='Enrollment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.PositiveSmallIntegerField(default=1, editable=False)),
                ('distributor_pk', models.PositiveIntegerField(editable=False, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('munki_release', models.CharField(blank=True, max_length=64)),
                ('configuration', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='monolith.Configuration')),
                ('distributor_content_type', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='contenttypes.ContentType')),
                ('manifest', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='monolith.Manifest')),
                ('secret', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE,
                                                related_name='%(app_label)s_%(class)s',
                                                to='inventory.enrollmentsecret')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='enrolledmachine',
            name='enrollment',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='monolith.Enrollment'),
        ),
        migrations.AlterUniqueTogether(
            name='enrollment',
            unique_together=set([('distributor_content_type', 'distributor_pk')]),
        ),
    ]
