# -*- coding: utf-8 -*-
# Generated by Django 1.9.2 on 2016-02-19 10:55
from __future__ import unicode_literals

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('inventory', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Catalog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, unique=True)),
                ('priority', models.PositiveIntegerField(default=0)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('archived_at', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'ordering': ('-priority', 'name'),
            },
        ),
        migrations.CreateModel(
            name='Manifest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('catalogs', models.ManyToManyField(to='monolith.Catalog')),
                ('meta_business_unit', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='inventory.MetaBusinessUnit')),
            ],
        ),
        migrations.CreateModel(
            name='PkgInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('data', django.contrib.postgres.fields.jsonb.JSONField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('archived_at', models.DateTimeField(blank=True, null=True)),
                ('catalogs', models.ManyToManyField(to='monolith.Catalog')),
            ],
        ),
        migrations.CreateModel(
            name='PkgInfoCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='PkgInfoName',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='SubManifest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256)),
                ('description', models.TextField(blank=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('managed_installs', models.ManyToManyField(related_name='_submanifest_managed_installs_+', to='monolith.PkgInfoName')),
                ('managed_uninstalls', models.ManyToManyField(related_name='_submanifest_managed_uninstalls_+', to='monolith.PkgInfoName')),
                ('managed_updates', models.ManyToManyField(related_name='_submanifest_managed_updates_+', to='monolith.PkgInfoName')),
                ('meta_business_unit', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='inventory.MetaBusinessUnit')),
                ('optional_installs', models.ManyToManyField(related_name='_submanifest_optional_installs_+', to='monolith.PkgInfoName')),
            ],
        ),
        migrations.AddField(
            model_name='pkginfo',
            name='category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='monolith.PkgInfoCategory'),
        ),
        migrations.AddField(
            model_name='pkginfo',
            name='name',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='monolith.PkgInfoName'),
        ),
        migrations.AddField(
            model_name='manifest',
            name='sub_manifests',
            field=models.ManyToManyField(to='monolith.SubManifest'),
        ),
    ]
