# Generated by Django 4.2.16 on 2024-09-12 07:24

from django.db import migrations, models
import django.db.models.deletion


def migrate_realm_tag_mappings(apps, schema_editor):
    RealmTagMapping = apps.get_model("realms", "RealmTagMapping")
    RealmGroup = apps.get_model("realms", "RealmGroup")
    RealmGroupTagMapping = apps.get_model("mdm", "RealmGroupTagMapping")
    for rtm in RealmTagMapping.objects.select_related("tag").all():
        try:
            realm_group = RealmGroup.objects.get(display_name__iexact=rtm.group_name)
        except RealmGroup.DoesNotExist:
            continue
        RealmGroupTagMapping.objects.create(realm_group=realm_group, tag=rtm.tag)


class Migration(migrations.Migration):

    dependencies = [
        ('inventory', '0078_file_cdhash'),
        ('realms', '0011_realm_user_portal_alter_realm_enabled_for_login'),
        ('mdm', '0082_alter_depenrollment_enrollment_secret_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='RealmGroupTagMapping',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('realm_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                                  to='realms.realmgroup', verbose_name="Group")),
                ('tag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='inventory.tag')),
            ],
            options={
                'unique_together': {('realm_group', 'tag')},
            },
        ),
        migrations.RunPython(migrate_realm_tag_mappings),
    ]
