# Generated by Django 4.2.13 on 2024-06-28 13:54

from django.db import migrations, models
from zentral.core.secret_engines import decrypt, encrypt


def rewrap_push_certificate_private_keys(apps, schema_editor):
    PushCertificate = apps.get_model("mdm", "PushCertificate")
    for pc in PushCertificate.objects.all():
        old_pk_kwargs = {"name": pc.name, "model": "mdm.pushcertificate", "field": "private_key"}
        new_pk_kwargs = {"pk": pc.pk, "model": "mdm.pushcertificate", "field": "private_key"}
        pc.private_key = encrypt(
            decrypt(pc.private_key, **old_pk_kwargs),
            **new_pk_kwargs
        )
        pc.save()


class Migration(migrations.Migration):

    dependencies = [
        ('mdm', '0080_scepconfig_provisioning_uid'),
    ]

    operations = [
        migrations.AddField(
            model_name='pushcertificate',
            name='provisioning_uid',
            field=models.CharField(editable=False, max_length=256, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='pushcertificate',
            name='not_after',
            field=models.DateTimeField(editable=False, null=True),
        ),
        migrations.AlterField(
            model_name='pushcertificate',
            name='not_before',
            field=models.DateTimeField(editable=False, null=True),
        ),
        migrations.AlterField(
            model_name='pushcertificate',
            name='private_key',
            field=models.TextField(default='', editable=False),
        ),
        migrations.AlterField(
            model_name='pushcertificate',
            name='topic',
            field=models.CharField(editable=False, max_length=256, null=True, unique=True),
        ),
        migrations.RunPython(rewrap_push_certificate_private_keys),
    ]
