# Generated by Django 4.2.10 on 2024-04-05 10:11

from django.db import migrations, models


def add_default_username_pattern(apps, schema_editor):
    DEPEnrollment = apps.get_model("mdm", "DEPEnrollment")
    DEPEnrollment.objects.filter(use_realm_user=True).update(username_pattern="$REALM_USER.DEVICE_USERNAME")


class Migration(migrations.Migration):

    dependencies = [
        ('mdm', '0075_pushcertificate_signed_csr_and_more'),
    ]

    operations = [
        migrations.AddField(
            model_name='depenrollment',
            name='username_pattern',
            field=models.CharField(blank=True,
                                   choices=[('$REALM_USER.DEVICE_USERNAME', "Username prefix without '.'"),
                                            ('$REALM_USER.EMAIL_PREFIX', 'Email prefix')],
                                   help_text='The pattern used to derive the account username from '
                                             'the realm user attributes.',
                                   max_length=255),
        ),
        migrations.RunPython(add_default_username_pattern),
        migrations.AlterField(
            model_name='depenrollment',
            name='realm_user_is_admin',
            field=models.BooleanField(default=True,
                                      help_text='If false, the user created from the realm user during the Setup '
                                                'Assistant will be a regular user, and the admin account information '
                                                'is required.'),
        ),
        migrations.AlterField(
            model_name='depenrollment',
            name='use_realm_user',
            field=models.BooleanField(default=False,
                                      help_text='Use this option to prefill the account creation info with the realm '
                                                'user attributes.'),
        ),
    ]
