# Generated by Django 4.2.8 on 2023-12-06 09:25

import datetime
import django.contrib.postgres.fields
import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('mdm', '0071_alter_artifact_platforms_and_more'),
    ]

    operations = [
        migrations.AddField(
            model_name='softwareupdateenforcement',
            name='platforms',
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(choices=[('iOS', 'iOS'),
                                                     ('iPadOS', 'iPadOS'),
                                                     ('macOS', 'macOS'),
                                                     ('tvOS', 'tvOS')], max_length=64), default=['macOS'], size=None),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='softwareupdateenforcement',
            name='build_version',
            field=models.CharField(
                blank=True,
                help_text='The target build version to update the device to by the appropriate time, '
                          'for example, 20A242.',
                max_length=32, verbose_name='Target build version'),
        ),
        migrations.AlterField(
            model_name='softwareupdateenforcement',
            name='delay_days',
            field=models.IntegerField(
                blank=True, default=14,
                help_text='Number of days after a software update release before the device force installs it.',
                null=True,
                validators=[django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(120)],
                verbose_name='Delay in days'),
        ),
        migrations.AlterField(
            model_name='softwareupdateenforcement',
            name='local_time',
            field=models.TimeField(
                blank=True,
                default=datetime.time(9, 30),
                help_text='The local time value that specifies when to force install the software update.',
                null=True,
                verbose_name='Target local time'),
        ),
        migrations.AlterField(
            model_name='softwareupdateenforcement',
            name='max_os_version',
            field=models.CharField(
                blank=True,
                help_text='The maximum target OS version to update the device to by the appropriate time.',
                max_length=32,
                verbose_name='Maximum target OS version'),
        ),
    ]
