# Generated by Django 4.1.9 on 2023-10-30 08:20

import datetime
import django.contrib.postgres.fields
import django.core.validators
from django.db import migrations, models
import zentral.contrib.mdm.models


class Migration(migrations.Migration):

    dependencies = [
        ('inventory', '0077_file_signing_id'),
        ('mdm', '0070_enterpriseapp_package_sha256_and_more'),
    ]

    operations = [
        migrations.AlterField(
            model_name='artifact',
            name='platforms',
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(choices=[('iOS', 'iOS'),
                                                     ('iPadOS', 'iPadOS'),
                                                     ('macOS', 'macOS'),
                                                     ('tvOS', 'tvOS')], max_length=64),
                default=zentral.contrib.mdm.models.get_platform_values, size=None),
        ),
        migrations.AlterField(
            model_name='asset',
            name='supported_platforms',
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(choices=[('iOS', 'iOS'),
                                                     ('iPadOS', 'iPadOS'),
                                                     ('macOS', 'macOS'),
                                                     ('tvOS', 'tvOS')], max_length=64),
                size=None),
        ),
        migrations.AlterField(
            model_name='enrolleddevice',
            name='platform',
            field=models.CharField(choices=[('iOS', 'iOS'),
                                            ('iPadOS', 'iPadOS'),
                                            ('macOS', 'macOS'),
                                            ('tvOS', 'tvOS')], max_length=64),
        ),
        migrations.AlterField(
            model_name='softwareupdate',
            name='platform',
            field=models.CharField(choices=[('iOS', 'iOS'),
                                            ('iPadOS', 'iPadOS'),
                                            ('macOS', 'macOS'),
                                            ('tvOS', 'tvOS')], max_length=64),
        ),
        migrations.CreateModel(
            name='SoftwareUpdateEnforcement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, unique=True)),
                ('details_url',
                 models.URLField(blank=True,
                                 help_text='The URL of a web page that shows details that the organization '
                                           'provides about the enforced update.', verbose_name='Details URL')),
                ('os_version',
                 models.CharField(blank=True,
                                  help_text='The target OS version to update the device to by the appropriate time.',
                                  max_length=32, verbose_name='Target OS version')),
                ('build_version',
                 models.CharField(blank=True,
                                  help_text='The target build version to update the device to by the appropriate time,'
                                            'for example, 20A242.',
                                  max_length=32, verbose_name='Target build version')),
                ('local_datetime',
                 models.DateTimeField(blank=True,
                                      help_text='If the user doesn’t trigger the software update before this time, '
                                                'the device force installs it.',
                                      null=True, verbose_name='Target local date time')),
                ('max_os_version',
                 models.CharField(blank=True,
                                  help_text='The maximum target OS version to update the device to by the appropriate '
                                            'time.',
                                  max_length=32, verbose_name='Maximum OS version')),
                ('delay_days',
                 models.IntegerField(blank=True, default=14,
                                     help_text='Number of days after a software update release before the device force'
                                               'installs it.',
                                     null=True, validators=[django.core.validators.MinValueValidator(0),
                                                            django.core.validators.MaxValueValidator(120)],
                                     verbose_name='Enforcement delay in days')),
                ('local_time',
                 models.TimeField(blank=True, default=datetime.time(9, 30), null=True,
                                  verbose_name='The local time value that specifies when to force install the software'
                                               ' update.')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('tags', models.ManyToManyField(blank=True, to='inventory.tag')),
            ],
        ),
        migrations.AddField(
            model_name='blueprint',
            name='software_update_enforcements',
            field=models.ManyToManyField(blank=True, to='mdm.softwareupdateenforcement'),
        ),
    ]
